/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import weblogic.servlet.HTTPLogger;
import weblogic.servlet.utils.OC4JURLMapping;
import weblogic.servlet.utils.ServletMapping;
import weblogic.servlet.utils.StandardURLMapping;
import weblogic.servlet.utils.URLMapping;

public class URLMappingFactory {
    public static ServletMapping createDefaultURLMapping() {
        return new ServletMapping();
    }

    public static ServletMapping createDefaultURLMapping(boolean bl, boolean bl2) {
        return new ServletMapping(bl, bl2);
    }

    public static URLMapping createCustomURLMapping(String string, ClassLoader classLoader, boolean bl) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            URLMapping uRLMapping = (URLMapping)clazz.newInstance();
            uRLMapping.setCaseInsensitive(bl);
            uRLMapping.setExtensionCaseInsensitive(bl);
            return uRLMapping;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logCouldNotLoadUrlMatchMapClass((String)string, (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            HTTPLogger.logCouldNotLoadUrlMatchMapClass((String)string, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            HTTPLogger.logCouldNotLoadUrlMatchMapClass((String)string, (Throwable)illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            HTTPLogger.logCouldNotLoadUrlMatchMapClass((String)string, (Throwable)classCastException);
        }
        return null;
    }

    public static StandardURLMapping createCompatibleURLMapping(String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        if (string == null || !string.equals(OC4JURLMapping.class.getName())) {
            return URLMappingFactory.createDefaultURLMapping(bl, bl2);
        }
        return (StandardURLMapping)URLMappingFactory.createCustomURLMapping(string, classLoader, bl);
    }

    public static boolean isInvalidUrlPattern(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        return (string == null || !string.equals(OC4JURLMapping.class.getName())) && string2.length() > 1 && string2.endsWith("*") && !string2.endsWith("/*");
    }
}

