/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import weblogic.servlet.utils.URLMapping;

public class URLMatchMap
implements URLMapping {
    protected static final int ARRAY_SIZE = 257;
    protected URLMatchNode[] nodes = null;
    protected URLExtensionNode[] exts = null;
    protected Object defaultObject;
    protected Object jspObject;
    private boolean caseInsensitive = false;
    private boolean extnCaseInsensitive = false;
    static String[][] mappings = new String[][]{{"/foo/*", "FooServlet"}, {"/foo/bar/*", "FooBarServlet"}, {"/baz/*", "BazServlet"}, {"*.html", "FileServlet"}, {"*.jsp", "JSPServlet"}, {"*.class", "ClasspathServlet"}, {"*.x", "SingleCharExtn"}, {"*.yz", "TwoCharExtn"}, {"/", "DefaultServlet"}, {"foo2/*", "FooServlet2"}, {"foo2/bar2/*", "FooBarServlet2"}, {"baz2/*", "BazServlet2"}, {"boom/*", "BoomServlet"}, {"/common/*", "Common1"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/a/*", "a"}, {"/aa/*", "aa"}, {"/aaa/*", "aaa"}, {"/specviol/*", "SpecWildCard"}, {"/specviol", "SpecExact"}};
    static String[][] tests = new String[][]{{"/foo/xxx", "FooServlet"}, {"/baz/xxx", "BazServlet"}, {"/foo/bar/xxxx", "FooBarServlet"}, {"/foo/xxx.html", "FooServlet"}, {"/qqq/yyy/ttt.html", "FileServlet"}, {"/qqq/yyy/ttt", "DefaultServlet"}, {"/qqq/jjj.jsp", "JSPServlet"}, {"/qqq/jjj.class", "ClasspathServlet"}, {"/foo2/xxx", "FooServlet2"}, {"/foo2/bar2/xxxx", "FooBarServlet2"}, {"/baz2/xxx", "BazServlet2"}, {"foo2/xxx", "FooServlet2"}, {"foo2/bar2/xxxx", "FooBarServlet2"}, {"baz2/xxx", "BazServlet2"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/blah.yz", "TwoCharExtn"}, {"/blah.x", "SingleCharExtn"}, {"/a", "a"}, {"/a/", "a"}, {"/a/x", "a"}, {"/a/xx", "a"}, {"/a/xxx", "a"}, {"/a/xxxx", "a"}, {"/a/xxxxx", "a"}, {"/aa", "aa"}, {"/aa/", "aa"}, {"/aa/x", "aa"}, {"/aa/xx", "aa"}, {"/aa/xxx", "aa"}, {"/aa/xxxx", "aa"}, {"/aa/xxxxx", "aa"}, {"/aaa", "aaa"}, {"/aaa/", "aaa"}, {"/aaa/x", "aaa"}, {"/aaa/xx", "aaa"}, {"/aaa/xxx", "aaa"}, {"/aaa/xxxx", "aaa"}, {"/aaa/xxxxx", "aaa"}, {"boom", "BoomServlet"}, {"boom/", "BoomServlet"}, {"boom/x", "BoomServlet"}, {"boom/xx", "BoomServlet"}, {"boom/xxx", "BoomServlet"}, {"boom/xxxx", "BoomServlet"}, {"/home", "DefaultServlet"}, {"/foo", "FooServlet"}, {"/specviol/foo", "SpecWildCard"}, {"/specviol/", "SpecWildCard"}, {"/specviol", "SpecExact"}};
    static String[] removes = new String[]{"/foo/bar/*", "foo2/*", "boom/*", "*.jsp", "*.class", "/"};
    static String[][] tests1 = new String[][]{{"/foo/xxx", "FooServlet"}, {"/baz/xxx", "BazServlet"}, {"/foo/bar/xxxx", "FooServlet"}, {"/foo/xxx.html", "FooServlet"}, {"/qqq/yyy/ttt.html", "FileServlet"}, {"/qqq/yyy/ttt", "null"}, {"/qqq/jjj.jsp", "null"}, {"/qqq/jjj.class", "null"}, {"/foo2/xxx", "null"}, {"/foo2/bar2/xxxx", "FooBarServlet2"}, {"/baz2/xxx", "BazServlet2"}, {"foo2/xxx", "null"}, {"foo2/bar2/xxxx", "FooBarServlet2"}, {"baz2/xxx", "BazServlet2"}, {"boom/xxx", "null"}, {"/commonxyz/pdf/gy/*", "Common1"}, {"/common/kjh/*", "Common2"}, {"/commonjkhjk/*", "Common3"}, {"/commo/*", "Common4"}, {"/home", "null"}, {"/foo", "FooServlet"}};

    public URLMatchMap() {
        this(null, false, false);
    }

    public URLMatchMap(Object object, boolean bl) {
        this(object, bl, bl);
    }

    public URLMatchMap(Object object, boolean bl, boolean bl2) {
        this.defaultObject = object;
        this.caseInsensitive = bl;
        this.extnCaseInsensitive = bl2;
        this.nodes = new URLMatchNode[257];
        this.exts = new URLExtensionNode[0];
    }

    public void setDefault(Object object) {
        this.defaultObject = object;
    }

    public Object getDefault() {
        return this.defaultObject;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public boolean isExtensionCaseInsensitive() {
        return this.extnCaseInsensitive;
    }

    public void setExtensionCaseInsensitive(boolean bl) {
        this.extnCaseInsensitive = bl;
    }

    public void put(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("null pattern put");
        }
        if (object == null) {
            throw new NullPointerException("null object put");
        }
        if (string.length() < 1 || string.equals("/")) {
            string = "/*";
        }
        if (string.startsWith("*.")) {
            this.putByExtension(string, object);
            return;
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        if (string.equals("/") || string.equals("/*") || string.equals("*")) {
            this.defaultObject = object;
            return;
        }
        if (string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException("bad URLMatchMap path: '" + string + "'");
        }
        if (this.caseInsensitive) {
            string = string.toLowerCase();
        }
        int n = URLMatchMap.hashPath(string);
        URLMatchNode uRLMatchNode = new URLMatchNode(string, object, n);
        int n2 = (n & Integer.MAX_VALUE) % 257;
        URLMatchNode uRLMatchNode2 = this.nodes[n2];
        if (uRLMatchNode2 == null) {
            this.nodes[n2] = uRLMatchNode;
            return;
        }
        if (uRLMatchNode.len >= uRLMatchNode2.len) {
            if (uRLMatchNode.len == uRLMatchNode2.len && uRLMatchNode.exact == uRLMatchNode2.exact && uRLMatchNode.pattern.equals(uRLMatchNode2.pattern)) {
                uRLMatchNode2.val = object;
                return;
            }
            this.nodes[n2] = uRLMatchNode;
            uRLMatchNode.next = uRLMatchNode2;
            return;
        }
        while (uRLMatchNode2.next != null) {
            if (uRLMatchNode.len >= uRLMatchNode2.next.len) {
                if (uRLMatchNode.len == uRLMatchNode2.next.len && uRLMatchNode.exact == uRLMatchNode2.next.exact && uRLMatchNode.pattern.equals(uRLMatchNode2.next.pattern)) {
                    uRLMatchNode2.next.val = object;
                    return;
                }
                uRLMatchNode.next = uRLMatchNode2.next;
                uRLMatchNode2.next = uRLMatchNode;
                return;
            }
            uRLMatchNode2 = uRLMatchNode2.next;
        }
        uRLMatchNode2.next = uRLMatchNode;
        uRLMatchNode.next = null;
    }

    private void putByExtension(String string, Object object) {
        if (string.equals(".jsp")) {
            this.jspObject = object;
        }
        if (!string.startsWith("*.") || string.length() < 3) {
            throw new IllegalArgumentException("bad URLMath extension pattern: '" + string + "'");
        }
        string = string.substring(2);
        if (this.caseInsensitive) {
            string = string.toLowerCase();
        }
        int n = this.exts.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.exts[i].ext)) continue;
            this.exts[i] = new URLExtensionNode(string, this.caseInsensitive || this.extnCaseInsensitive, object);
            return;
        }
        URLExtensionNode[] uRLExtensionNodeArray = new URLExtensionNode[n + 1];
        System.arraycopy(this.exts, 0, uRLExtensionNodeArray, 0, n);
        this.exts = uRLExtensionNodeArray;
        this.exts[n] = new URLExtensionNode(string, this.caseInsensitive || this.extnCaseInsensitive, object);
    }

    public Object get(String string) {
        Object object;
        if (string == null || string.length() == 0 || string.equals("/")) {
            return this.defaultObject;
        }
        if (string.charAt(0) != '/') {
            object = new StringBuffer(string.length() + 1);
            ((StringBuffer)object).append('/').append(string);
            string = ((StringBuffer)object).toString();
        }
        if (this.caseInsensitive) {
            string = string.toLowerCase();
        }
        if ((object = this.getByPath(string)) != null) {
            return object;
        }
        if (string.endsWith(".jsp") && this.jspObject != null) {
            return this.jspObject;
        }
        object = this.getByExtension(string);
        return object != null ? object : this.defaultObject;
    }

    private Object getByPath(String string) {
        int n = URLMatchMap.hashPath(string);
        int n2 = (n & Integer.MAX_VALUE) % 257;
        int n3 = string.length();
        URLMatchNode uRLMatchNode = this.nodes[n2];
        return uRLMatchNode != null ? uRLMatchNode.match(string, n3, n) : null;
    }

    private Object getByExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        int n2 = string.length();
        if (n == n2 - 1) {
            return null;
        }
        int n3 = n + 1;
        int n4 = n2 - n3;
        int n5 = this.exts.length;
        for (int i = 0; i < n5; ++i) {
            if (!this.exts[i].match(string, n3, n4)) continue;
            return this.exts[i].val;
        }
        return null;
    }

    public void remove(String string) {
        int n;
        int n2;
        URLMatchNode uRLMatchNode;
        if (string == null) {
            throw new NullPointerException("null pattern put");
        }
        if (string.length() < 1 || string.equals("/")) {
            this.defaultObject = null;
            return;
        }
        if (string.startsWith("*.")) {
            this.removeByExtension(string);
            return;
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        if (string.length() == 0 || string.charAt(0) != '/') {
            throw new IllegalArgumentException("bad URLMatchMap path: '" + string + "'");
        }
        if (this.caseInsensitive) {
            string = string.toLowerCase();
        }
        if ((uRLMatchNode = this.nodes[n2 = ((n = URLMatchMap.hashPath(string)) & Integer.MAX_VALUE) % 257]) == null) {
            return;
        }
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.equals(uRLMatchNode.pattern)) {
            this.nodes[n2] = uRLMatchNode.next;
            return;
        }
        while (uRLMatchNode.next != null) {
            if (string.equals(uRLMatchNode.next.pattern)) {
                uRLMatchNode.next = uRLMatchNode.next.next;
                return;
            }
            uRLMatchNode = uRLMatchNode.next;
        }
    }

    private void removeByExtension(String string) {
        if (string.equals(".jsp")) {
            this.jspObject = null;
        }
        if (!string.startsWith("*.") || string.length() < 3) {
            throw new IllegalArgumentException("bad URLMath extension pattern: '" + string + "'");
        }
        string = string.substring(2);
        if (this.caseInsensitive) {
            string = string.toLowerCase();
        }
        int n = this.exts.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.exts[i].ext)) continue;
            int n2 = n - 1;
            for (int j = i; j < n2; ++j) {
                this.exts[j] = this.exts[j + 1];
            }
            URLExtensionNode[] uRLExtensionNodeArray = new URLExtensionNode[n2];
            System.arraycopy(this.exts, 0, uRLExtensionNodeArray, 0, n2);
            this.exts = uRLExtensionNodeArray;
            return;
        }
    }

    private static int hashPath(String string) {
        int n = string.indexOf(47, 1);
        if (n != -1 && n < 4) {
            string = string.substring(0, n);
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n2 > 1) {
            n3 = string.charAt(1);
            if (n2 > 2) {
                n4 = string.charAt(2);
                if (n2 > 3) {
                    n5 = string.charAt(3);
                }
            }
        }
        int n6 = n3 + n4 + n5 + n3 * n4;
        return n6;
    }

    public Object clone() {
        int n;
        URLMatchMap uRLMatchMap = new URLMatchMap(this.defaultObject, this.caseInsensitive, this.extnCaseInsensitive);
        uRLMatchMap.jspObject = this.jspObject;
        uRLMatchMap.nodes = new URLMatchNode[257];
        for (n = 0; n < 257; ++n) {
            uRLMatchMap.nodes[n] = this.nodes[n];
        }
        int n2 = this.exts.length;
        uRLMatchMap.exts = new URLExtensionNode[n2];
        for (n = 0; n < n2; ++n) {
            uRLMatchMap.exts[n] = this.exts[n];
        }
        return uRLMatchMap;
    }

    public int size() {
        int n = this.exts.length;
        for (int i = 0; i < 257; ++i) {
            URLMatchNode uRLMatchNode = this.nodes[i];
            if (uRLMatchNode == null) continue;
            ++n;
            while (uRLMatchNode.next != null) {
                uRLMatchNode = uRLMatchNode.next;
                ++n;
            }
        }
        if (this.defaultObject != null) {
            ++n;
        }
        return n;
    }

    public Object[] values() {
        int n;
        int n2 = this.size();
        int n3 = 0;
        Object[] objectArray = new Object[n2];
        if (this.defaultObject != null) {
            objectArray[n3++] = this.defaultObject;
        }
        for (n = 0; n < this.exts.length; ++n) {
            objectArray[n3] = this.exts[n].val;
            ++n3;
        }
        for (n = 0; n < 257; ++n) {
            URLMatchNode uRLMatchNode = this.nodes[n];
            if (uRLMatchNode == null) continue;
            objectArray[n3] = uRLMatchNode.val;
            ++n3;
            while (uRLMatchNode.next != null) {
                uRLMatchNode = uRLMatchNode.next;
                objectArray[n3] = uRLMatchNode.val;
                ++n3;
            }
        }
        return objectArray;
    }

    public String[] keys() {
        int n;
        int n2 = this.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        if (this.defaultObject != null) {
            stringArray[n3++] = "";
        }
        for (n = 0; n < this.exts.length; ++n) {
            stringArray[n3] = "*." + this.exts[n].ext;
            ++n3;
        }
        for (n = 0; n < 257; ++n) {
            URLMatchNode uRLMatchNode = this.nodes[n];
            if (uRLMatchNode == null) continue;
            stringArray[n3] = uRLMatchNode.pattern;
            ++n3;
            while (uRLMatchNode.next != null) {
                uRLMatchNode = uRLMatchNode.next;
                stringArray[n3] = uRLMatchNode.pattern;
                ++n3;
            }
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        URLMatchMap uRLMatchMap = new URLMatchMap(null, false);
        System.err.println("### RUN 1 ###");
        for (n = 0; n < mappings.length; ++n) {
            uRLMatchMap.put(mappings[n][0], mappings[n][1]);
        }
        for (n = 0; n < tests.length; ++n) {
            object = uRLMatchMap.get(tests[n][0]);
            if (!tests[n][1].equals(object)) {
                System.err.println("FAILED: expected '" + tests[n][0] + "'->'" + tests[n][1] + "' got '" + object + "'");
                continue;
            }
            System.err.println("SUCCESS: '" + tests[n][0] + "'->'" + tests[n][1] + "'");
        }
        System.err.println("### RUN 2 ###");
        for (n = 0; n < removes.length; ++n) {
            uRLMatchMap.remove(removes[n]);
        }
        for (n = 0; n < tests1.length; ++n) {
            object = uRLMatchMap.get(tests1[n][0]);
            if (!tests1[n][1].equals("" + object)) {
                System.err.println("FAILED: expected '" + tests1[n][0] + "'->'" + tests1[n][1] + "' got '" + object + "'");
                continue;
            }
            System.err.println("SUCCESS: '" + tests1[n][0] + "'->'" + tests1[n][1] + "'");
        }
    }

    public class URLMatchNode {
        String pattern;
        int len;
        int hash;
        boolean exact;
        Object val;
        URLMatchNode next;

        URLMatchNode(String string, Object object, int n) {
            this.val = object;
            this.hash = n;
            if (string.length() == 0 || string.charAt(0) != '/' || string.equals("/") || string.equals("/*")) {
                throw new IllegalArgumentException("bad URLMatchMap path: '" + string + "'");
            }
            if (string.endsWith("/*")) {
                this.exact = false;
                string = string.substring(0, string.length() - 1);
            } else {
                this.exact = true;
            }
            this.pattern = string;
            this.len = this.pattern.length();
        }

        public Object match(String string, int n, int n2) {
            Object object = this.exactMatch(string, n, n2);
            return object != null ? object : this.wildCardMatch(string, n, n2);
        }

        Object exactMatch(String string, int n, int n2) {
            URLMatchNode uRLMatchNode = this;
            do {
                if (!uRLMatchNode.exact || uRLMatchNode.hash != n2 || n != uRLMatchNode.len || !string.equals(uRLMatchNode.pattern)) continue;
                return uRLMatchNode.val;
            } while ((uRLMatchNode = uRLMatchNode.next) != null);
            return null;
        }

        Object wildCardMatch(String string, int n, int n2) {
            URLMatchNode uRLMatchNode = this;
            do {
                if (uRLMatchNode.exact || uRLMatchNode.hash != n2) continue;
                if (n >= uRLMatchNode.len) {
                    if (!string.startsWith(uRLMatchNode.pattern)) continue;
                    return uRLMatchNode.val;
                }
                if (n == uRLMatchNode.len - 1 && uRLMatchNode.pattern.endsWith("/") && uRLMatchNode.pattern.startsWith(string)) {
                    return uRLMatchNode.val;
                }
                if (n != uRLMatchNode.len || !string.equals(uRLMatchNode.pattern)) continue;
                return uRLMatchNode.val;
            } while ((uRLMatchNode = uRLMatchNode.next) != null);
            return null;
        }
    }

    public class URLExtensionNode {
        String ext;
        char[] extChars;
        int len;
        boolean caseInsensitive;
        Object val;

        URLExtensionNode(String string, boolean bl, Object object) {
            this.caseInsensitive = bl;
            this.val = object;
            if (this.caseInsensitive) {
                string = string.toLowerCase();
            }
            this.ext = string;
            this.extChars = this.ext.toCharArray();
            this.len = this.extChars.length;
        }

        boolean match(String string, int n, int n2) {
            if (this.len != n2) {
                return false;
            }
            if (!this.caseInsensitive) {
                int n3 = 0;
                int n4 = n;
                while (n3 < this.len) {
                    if (this.extChars[n3] != string.charAt(n4)) {
                        return false;
                    }
                    ++n3;
                    ++n4;
                }
            } else {
                int n5 = 0;
                int n6 = n;
                while (n5 < this.len) {
                    if (Character.toLowerCase(this.extChars[n5]) != Character.toLowerCase(string.charAt(n6))) {
                        return false;
                    }
                    ++n5;
                    ++n6;
                }
            }
            return true;
        }
    }
}

