/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import weblogic.application.utils.ClassLoaderUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.ContainerDescriptorBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.PreferApplicationPackagesBean;
import weblogic.j2ee.descriptor.wl.PreferApplicationResourcesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.utils.Debug;
import weblogic.utils.application.WarDetector;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public final class WarUtils {
    private static final String WEB_XML = "WEB-INF" + File.separator + "web.xml";
    private static final String WEB_XML_URI = "WEB-INF/web.xml";
    public static final String WEBLOGIC_XML = "WEB-INF" + File.separator + "weblogic.xml";
    private static final String WEB_SERVICES_XML = "WEB-INF" + File.separator + "web-services.xml";
    private static final String WEB_SERVICES_URI = "WEB-INF/web-services.xml";
    private static final String JSF_RI_LIB_NAME = "jsf";
    private static final String FACES_SERVLET_NAME = "javax.faces.webapp.FacesServlet";
    private static final String JAVAX_FACES_CONFIG_FILES = "javax.faces.CONFIG_FILES";
    private static final boolean diDisabled = Boolean.getBoolean("weblogic.servlet.DIDisabled");

    public static boolean isWar(File file) throws IOException {
        return WarDetector.instance.isWar(file);
    }

    public static boolean isPre15War(File file) throws IOException {
        if (file.isDirectory()) {
            return new File(file, WEB_XML).exists();
        }
        return WarUtils.existsInWar(file, WEB_XML_URI);
    }

    public static boolean isWebServices(File file) throws IOException {
        if (file.isDirectory()) {
            return new File(file, WEB_SERVICES_XML).exists();
        }
        return WarUtils.existsInWar(file, WEB_SERVICES_URI);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean existsInWar(File file, String string) throws IOException {
        boolean bl;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                bl = zipFile.getEntry(string) != null;
                Object var5_5 = null;
                if (zipFile == null) return bl;
            }
            catch (ZipException zipException) {
                throw new ZipException("Error opening file - " + file.getPath() + " Message - " + zipException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        zipFile.close();
        return bl;
    }

    public static WebAppDescriptor getWebAppDescriptor(File file, VirtualJarFile virtualJarFile, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        if (file != null) {
            return new WebAppDescriptor(file, (File)null, file2, deploymentPlanBean, string);
        }
        return new WebAppDescriptor(virtualJarFile, file2, deploymentPlanBean, string);
    }

    public static WeblogicWebAppBean getWlWebAppBean(WebAppDescriptor webAppDescriptor) throws ToolFailureException {
        WeblogicWebAppBean weblogicWebAppBean = null;
        try {
            weblogicWebAppBean = webAppDescriptor.getWeblogicWebAppBean();
        }
        catch (IOException iOException) {
            throw new ToolFailureException(iOException.getMessage());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException(xMLStreamException.getMessage());
        }
        return weblogicWebAppBean;
    }

    public static WebAppBean getWebAppBean(WebAppDescriptor webAppDescriptor) throws ToolFailureException {
        WebAppBean webAppBean = null;
        try {
            webAppBean = webAppDescriptor.getWebAppBean();
        }
        catch (IOException iOException) {
            throw new ToolFailureException(iOException.getMessage());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ToolFailureException(xMLStreamException.getMessage());
        }
        return webAppBean;
    }

    public static boolean isJsfApplication(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) {
        int n;
        LibraryRefBean[] libraryRefBeanArray;
        if (weblogicWebAppBean != null && (libraryRefBeanArray = weblogicWebAppBean.getLibraryRefs()) != null) {
            for (n = 0; n < libraryRefBeanArray.length; ++n) {
                if (!JSF_RI_LIB_NAME.equals(libraryRefBeanArray[n].getLibraryName())) continue;
                return true;
            }
        }
        if (webAppBean != null && (libraryRefBeanArray = webAppBean.getServlets()) != null) {
            for (n = 0; n < libraryRefBeanArray.length; ++n) {
                if (!FACES_SERVLET_NAME.equals(libraryRefBeanArray[n].getServletClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getFacesConfigFiles(WebAppBean webAppBean) {
        if (webAppBean == null) {
            return null;
        }
        ParamValueBean[] paramValueBeanArray = webAppBean.getContextParams();
        for (int i = 0; i < paramValueBeanArray.length; ++i) {
            if (!JAVAX_FACES_CONFIG_FILES.equals(paramValueBeanArray[i].getParamName())) continue;
            return paramValueBeanArray[i].getParamValue();
        }
        return null;
    }

    public static boolean isDIEnabled(WebAppBean webAppBean) {
        if (diDisabled) {
            return false;
        }
        String string = ((DescriptorBean)webAppBean).getDescriptor().getOriginalVersionInfo();
        Debug.assertion((string != null ? 1 : 0) != 0);
        try {
            return (double)Float.parseFloat(string) >= 2.5 && webAppBean.getVersion() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAnnotationEnabled(WebAppBean webAppBean) {
        return WarUtils.isDIEnabled(webAppBean) && !webAppBean.isMetadataComplete();
    }

    public static boolean configureFCL(WeblogicWebAppBean weblogicWebAppBean, GenericClassLoader genericClassLoader, boolean bl) throws ToolFailureException {
        PreferApplicationPackagesBean preferApplicationPackagesBean = null;
        PreferApplicationResourcesBean preferApplicationResourcesBean = null;
        if (weblogicWebAppBean != null && weblogicWebAppBean.getContainerDescriptors() != null && weblogicWebAppBean.getContainerDescriptors().length > 0) {
            ContainerDescriptorBean containerDescriptorBean = weblogicWebAppBean.getContainerDescriptors()[0];
            preferApplicationPackagesBean = containerDescriptorBean.getPreferApplicationPackages();
            preferApplicationResourcesBean = containerDescriptorBean.getPreferApplicationResources();
            if ((preferApplicationPackagesBean != null && preferApplicationPackagesBean.getPackageNames().length > 0 || preferApplicationResourcesBean != null && preferApplicationResourcesBean.getResourceNames().length > 0) && containerDescriptorBean.isPreferWebInfClasses()) {
                throw new ToolFailureException("Neither <prefer-application-packages> nor <prefer-application-resources> can be specified when <prefer-web-inf-classes> is turned on in weblogic.xml");
            }
        }
        if (bl) {
            ClassLoaderUtils.initFilterPatterns(preferApplicationPackagesBean, preferApplicationResourcesBean, genericClassLoader);
            return false;
        }
        return preferApplicationPackagesBean != null && preferApplicationPackagesBean.getPackageNames().length > 0 || preferApplicationResourcesBean != null && preferApplicationResourcesBean.getResourceNames().length > 0;
    }
}

