/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weblogic.application.library.CachableLibMetadataType;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.library.LibraryReferencer;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.utils.WarUtils;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class WebAppLibraryUtils {
    private WebAppLibraryUtils() {
    }

    public static LibraryManager getEmptyWebAppLibraryManager() {
        return WebAppLibraryUtils.getEmptyWebAppLibraryManager(null);
    }

    public static LibraryManager getEmptyWebAppLibraryManager(String string) {
        return new LibraryManager(WebAppLibraryUtils.getLibraryReferencer(string));
    }

    public static LibraryManager getWebAppLibraryManager(WeblogicWebAppBean weblogicWebAppBean, String string) throws ToolFailureException {
        LibraryManager libraryManager = new LibraryManager(WebAppLibraryUtils.getLibraryReferencer(string));
        WebAppLibraryUtils.initWebAppLibraryManager(libraryManager, weblogicWebAppBean, string);
        return libraryManager;
    }

    public static void initWebAppLibraryManager(LibraryManager libraryManager, WeblogicWebAppBean weblogicWebAppBean, String string) throws ToolFailureException {
        if (weblogicWebAppBean == null) {
            return;
        }
        if (weblogicWebAppBean.getLibraryRefs() == null) {
            return;
        }
        LibraryReference[] libraryReferenceArray = WebAppLibraryUtils.getWebLibRefs(weblogicWebAppBean, string);
        libraryManager.lookup(libraryReferenceArray);
        if (libraryManager.hasUnresolvedReferences()) {
            throw new ToolFailureException("Error: " + libraryManager.getUnresolvedReferencesError());
        }
    }

    public static LibraryReference[] getWebLibRefs(WeblogicWebAppBean weblogicWebAppBean, String string) throws ToolFailureException {
        LibraryReference[] libraryReferenceArray = null;
        try {
            libraryReferenceArray = LibraryReferenceFactory.getWebLibReference(weblogicWebAppBean.getLibraryRefs());
        }
        catch (IllegalSpecVersionTypeException illegalSpecVersionTypeException) {
            throw new ToolFailureException(HTTPLogger.logIllegalWebLibSpecVersionRefLoggable((String)(string == null ? "" : string), (String)illegalSpecVersionTypeException.getSpecVersion()).getMessage());
        }
        if (libraryReferenceArray == null) {
            return new LibraryReference[0];
        }
        return libraryReferenceArray;
    }

    private static War extractWebAppLibraries(LibraryManager libraryManager, File file, String string) throws IOException {
        War war = new War(string);
        WebAppLibraryUtils.extractWebAppLibraries(libraryManager, war, file);
        return war;
    }

    public static void extractWebAppLibraries(LibraryManager libraryManager, War war, File file) throws IOException {
        Library[] libraryArray = libraryManager.getReferencedLibraries();
        for (int i = 0; i < libraryArray.length; ++i) {
            war.addLibrary(libraryArray[i], file);
        }
    }

    public static void copyWebAppLibraries(LibraryManager libraryManager, File file, File file2) throws IOException {
        War war = WebAppLibraryUtils.extractWebAppLibraries(libraryManager, file, "webappmerge");
        WebAppLibraryUtils.writeWar(war, file2);
    }

    public static void writeWar(War war, File file) throws IOException {
        ClassFinder classFinder = war.getResourceFinder("/");
        String string = classFinder.getClassPath();
        classFinder.close();
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(stringArray[i]);
            if (!file2.exists()) continue;
            Set set = WebAppLibraryUtils.getExcludedFiles(file2);
            FileUtils.copyNoOverwrite((File)file2, (File)file, (Set)set);
        }
    }

    public static void removeLibraryReferences(WeblogicWebAppBean weblogicWebAppBean) {
        if (weblogicWebAppBean == null) {
            return;
        }
        LibraryRefBean[] libraryRefBeanArray = weblogicWebAppBean.getLibraryRefs();
        if (libraryRefBeanArray == null) {
            return;
        }
        for (int i = 0; i < libraryRefBeanArray.length; ++i) {
            weblogicWebAppBean.destroyLibraryRef(libraryRefBeanArray[i]);
        }
    }

    private static Set getExcludedFiles(File file) {
        HashSet<File> hashSet = new HashSet<File>(5);
        hashSet.add(new File(file, "WEB-INF/web.xml"));
        hashSet.add(new File(file, "WEB-INF/weblogic.xml"));
        hashSet.add(new File(file, CachableLibMetadataType.ANNOTATED_CLASSES.getName()));
        hashSet.add(new File(file, CachableLibMetadataType.TLD.getName()));
        hashSet.add(new File(file, CachableLibMetadataType.FACE_BEANS.getName()));
        return hashSet;
    }

    public static LibraryReferencer getLibraryReferencer(String string) {
        String string2 = "Unresolved WebApp library references defined in weblogic.xml";
        if (string != null) {
            string2 = string2 + ", of module '" + string + "'";
        }
        return new LibraryReferencer(null, null, string2);
    }

    public static LibraryReference[] initAllWebLibRefs(File file) throws ToolFailureException {
        ArrayList<LibraryReference> arrayList = new ArrayList<LibraryReference>();
        File[] fileArray = FileUtils.find((File)file, (FileFilter)new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().equals("weblogic.xml") && file.getParentFile().getName().equals("WEB-INF");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            LibraryReference[] libraryReferenceArray = WebAppLibraryUtils.initWebLibRefs(fileArray[i].getParentFile().getParentFile());
            if (libraryReferenceArray == null) continue;
            arrayList.addAll(Arrays.asList(libraryReferenceArray));
        }
        return arrayList.toArray(new LibraryReference[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LibraryReference[] initWebLibRefs(File file) throws ToolFailureException {
        VirtualJarFile virtualJarFile = null;
        LibraryReference[] libraryReferenceArray = null;
        try {
            try {
                virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                WebAppDescriptor webAppDescriptor = new WebAppDescriptor(virtualJarFile);
                WeblogicWebAppBean weblogicWebAppBean = WarUtils.getWlWebAppBean(webAppDescriptor);
                libraryReferenceArray = WebAppLibraryUtils.getWebLibRefs(weblogicWebAppBean, file.getName());
            }
            catch (IOException iOException) {
                throw new ToolFailureException("Error parsing weblogic.xml");
            }
            Object var6_6 = null;
            if (virtualJarFile == null) return libraryReferenceArray;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (virtualJarFile == null) throw throwable;
            try {
                virtualJarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        virtualJarFile.close();
        return libraryReferenceArray;
    }
}

