/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils.annotation;

import com.bea.objectweb.asm.Type;
import com.bea.objectweb.asm.commons.EmptyVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationDetectContext {
    private boolean isAnnotationPresent;
    private boolean isClassLevelOnly;
    private List<String> includes;
    private static final String[] excludes = new String[]{Type.getDescriptor(Deprecated.class).intern(), Type.getDescriptor(Override.class).intern(), Type.getDescriptor(SuppressWarnings.class).intern()};
    static final EmptyVisitor EMPTY_VISITOR = new EmptyVisitor();

    public AnnotationDetectContext(String ... stringArray) {
        this(false, stringArray);
    }

    public AnnotationDetectContext(boolean bl, String ... stringArray) {
        this.isClassLevelOnly = bl;
        this.isAnnotationPresent = false;
        this.includes = Collections.EMPTY_LIST;
        if (stringArray.length != 0) {
            this.includes = new ArrayList<String>();
            for (String string : stringArray) {
                this.includes.add(string.intern());
            }
        }
    }

    public void setClassLevelOnly(boolean bl) {
        this.isClassLevelOnly = bl;
    }

    public boolean isClassLevelOnly() {
        return this.isClassLevelOnly;
    }

    public boolean isAnnotationPresent() {
        return this.isAnnotationPresent;
    }

    public boolean checkIfAnnotationPresent(String string, boolean bl) {
        if (!bl) {
            return false;
        }
        for (String string2 : excludes) {
            if (string.intern() != string2) continue;
            return false;
        }
        if (this.includes.isEmpty() || this.includes.contains(string.intern())) {
            this.isAnnotationPresent = true;
            return true;
        }
        return false;
    }
}

