/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.utils.annotation;

import com.bea.objectweb.asm.AnnotationVisitor;
import com.bea.objectweb.asm.ClassAdapter;
import com.bea.objectweb.asm.ClassReader;
import com.bea.objectweb.asm.ClassVisitor;
import com.bea.objectweb.asm.FieldVisitor;
import com.bea.objectweb.asm.MethodVisitor;
import java.io.IOException;
import java.io.InputStream;
import weblogic.servlet.utils.annotation.AnnotationDetectContext;
import weblogic.servlet.utils.annotation.FieldAnnotationDetector;
import weblogic.servlet.utils.annotation.MethodAnnotationDetector;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.Source;

public class ClassAnnotationDetector
extends ClassAdapter {
    private boolean isClassV5 = false;
    private AnnotationDetectContext context;
    private ClassFinder finder;
    private MethodVisitor mv;
    private FieldVisitor fv;

    public ClassAnnotationDetector(ClassVisitor classVisitor, AnnotationDetectContext annotationDetectContext, ClassFinder classFinder) {
        super(classVisitor);
        this.context = annotationDetectContext;
        this.finder = classFinder;
        if (!annotationDetectContext.isClassLevelOnly()) {
            this.mv = new MethodAnnotationDetector((MethodVisitor)AnnotationDetectContext.EMPTY_VISITOR, annotationDetectContext);
            this.fv = new FieldAnnotationDetector((FieldVisitor)AnnotationDetectContext.EMPTY_VISITOR, annotationDetectContext);
        } else {
            this.mv = null;
            this.fv = null;
        }
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        boolean bl = this.isClassV5 = (n & 0xFF) >= 49;
        if (!this.isClassV5) {
            return;
        }
        if (this.context.isClassLevelOnly()) {
            return;
        }
        if (!string3.equals("java/lang/Object")) {
            this.visitSuper(ClassAnnotationDetector.convertClassName(string3));
        }
        for (String string4 : stringArray) {
            this.visitSuper(ClassAnnotationDetector.convertClassName(string4));
        }
    }

    private void visitSuper(String string) {
        ClassAnnotationDetector.visit(string, this.finder, this.context);
    }

    private static String convertClassName(String string) {
        return string.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visit(String string, ClassFinder classFinder, AnnotationDetectContext annotationDetectContext) {
        Source source = classFinder.getClassSource(string);
        InputStream inputStream = null;
        try {
            if (source != null) {
                inputStream = source.getInputStream();
                ClassReader classReader = new ClassReader(inputStream);
                ClassAnnotationDetector classAnnotationDetector = new ClassAnnotationDetector((ClassVisitor)AnnotationDetectContext.EMPTY_VISITOR, annotationDetectContext, classFinder);
                classReader.accept((ClassVisitor)classAnnotationDetector, 7);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isClassHasAnnotation(ClassFinder classFinder, String string) {
        AnnotationDetectContext annotationDetectContext = new AnnotationDetectContext(new String[0]);
        ClassAnnotationDetector.visit(string, classFinder, annotationDetectContext);
        return annotationDetectContext.isAnnotationPresent();
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (!this.isClassV5) {
            return null;
        }
        if (!this.context.isAnnotationPresent()) {
            this.context.checkIfAnnotationPresent(string, bl);
        }
        return null;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (!this.isClassV5) {
            return null;
        }
        return this.mv;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (!this.isClassV5) {
            return null;
        }
        return this.fv;
    }
}

