/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.Socket;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.MessageReceiverStatistics;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.server.channels.ServerConnectionRuntimeImpl;
import weblogic.socket.BaseAbstractMuxableSocket;
import weblogic.socket.ChannelSSLSocketFactory;
import weblogic.socket.ChannelSocketFactory;
import weblogic.socket.MaxConnectionsExceededException;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.utils.Debug;
import weblogic.utils.io.Chunk;

public abstract class AbstractMuxableSocket
extends BaseAbstractMuxableSocket
implements MessageReceiverStatistics {
    private static final long serialVersionUID = 7960171920400419300L;
    private static final boolean DEBUG = false;
    private final ServerConnectionRuntimeImpl runtime;

    protected AbstractMuxableSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        this(chunk, serverChannel);
        Object object;
        this.connect(socket);
        this.socket.setTcpNoDelay(true);
        if (KernelStatus.isServer() && serverChannel instanceof ServerChannelImpl) {
            object = (ServerChannelImpl)serverChannel;
            Debug.assertion((((ServerChannelImpl)object).getRuntime() != null ? 1 : 0) != 0);
            if (((ServerChannelImpl)object).getRuntime().getConnectionsCount() > (long)serverChannel.getMaxConnectedClients()) {
                throw new MaxConnectionsExceededException(serverChannel.getMaxConnectedClients(), serverChannel.getChannelName());
            }
        }
        object = this.head;
        while (object != null) {
            this.availBytes += ((Chunk)object).end;
            this.tail = object;
            object = ((Chunk)object).next;
        }
        if (this.availBytes > this.maxMessageSize) {
            throw new MaxMessageSizeExceededException(this.availBytes, this.maxMessageSize, serverChannel.getConfiguredProtocol());
        }
    }

    public void prepareForReuse() {
        this.resetData();
    }

    protected void registerForRuntimeMonitoring(ServerChannel serverChannel, ServerConnectionRuntimeImpl serverConnectionRuntimeImpl) {
        if (serverChannel instanceof ServerChannelImpl && ((ServerChannelImpl)serverChannel).getRuntime() != null) {
            ((ServerChannelImpl)serverChannel).getRuntime().addServerConnectionRuntime(serverConnectionRuntimeImpl);
        }
    }

    protected AbstractMuxableSocket(Chunk chunk, ServerChannel serverChannel) {
        super(chunk, serverChannel);
        this.socketFactory = serverChannel.supportsTLS() ? new ChannelSSLSocketFactory(this.channel) : new ChannelSocketFactory(this.channel);
        this.runtime = new ServerConnectionRuntimeImpl(null, this, this);
        this.registerForRuntimeMonitoring(this.channel, this.runtime);
    }

    protected AbstractMuxableSocket(ServerChannel serverChannel) {
        this(Chunk.getChunk(), serverChannel);
    }

    protected static void p(String string) {
        System.out.println("<AbstractMuxableSocket>: " + string);
    }

    public final void addSenderStatistics(MessageSenderStatistics messageSenderStatistics) {
        this.runtime.addSender(messageSenderStatistics);
    }

    protected void cleanup() {
        ServerChannelImpl serverChannelImpl;
        super.cleanup();
        if (KernelStatus.isServer() && this.channel instanceof ServerChannelImpl && (serverChannelImpl = (ServerChannelImpl)this.channel).getRuntime() != null) {
            serverChannelImpl.getRuntime().removeServerConnectionRuntime(this);
        }
    }
}

