/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.net.SocketFactory;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.server.channels.SocketRuntimeImpl;
import weblogic.socket.ChannelSocketFactory;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicSocketFactory;
import weblogic.utils.Debug;
import weblogic.utils.concurrent.Latch;
import weblogic.utils.io.Chunk;

public abstract class BaseAbstractMuxableSocket
implements MuxableSocket,
SocketRuntime,
ContextHandler,
Serializable {
    private static final long serialVersionUID = 7960171920400419300L;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    private static final boolean DEBUG = false;
    protected final ServerChannel channel;
    protected Socket socket;
    protected int soTimeout;
    protected InputStream sis;
    protected OutputStream sos;
    protected SocketInfo info;
    protected MuxableSocket filter = null;
    protected SocketFactory socketFactory;
    protected final Latch closeLatch = new Latch();
    protected final int maxMessageSize;
    protected Chunk head;
    protected Chunk tail;
    protected int availBytes = 0;
    protected int msgLength = -1;
    private final long connectTime = System.currentTimeMillis();
    private long messagesReceived = 0L;
    private long bytesReceived = 0L;
    private static final String[] KEYS = new String[]{"com.bea.contextelement.channel.Port", "com.bea.contextelement.channel.PublicPort", "com.bea.contextelement.channel.RemotePort", "com.bea.contextelement.channel.Protocol", "com.bea.contextelement.channel.Address", "com.bea.contextelement.channel.PublicAddress", "com.bea.contextelement.channel.RemoteAddress", "com.bea.contextelement.channel.ChannelName", "com.bea.contextelement.channel.Secure"};

    protected BaseAbstractMuxableSocket(Chunk chunk, ServerChannel serverChannel) {
        this.channel = serverChannel;
        Debug.assertion((this.channel != null ? 1 : 0) != 0);
        this.socketFactory = new ChannelSocketFactory(this.channel);
        this.maxMessageSize = serverChannel.getMaxMessageSize();
        this.setSocketFilter(this);
        this.tail = this.head = chunk;
    }

    protected BaseAbstractMuxableSocket(ServerChannel serverChannel) {
        this(Chunk.getChunk(), serverChannel);
    }

    public final void connect(Socket socket) throws IOException {
        this.socket = socket;
        this.sis = socket.getInputStream();
        this.sos = socket.getOutputStream();
    }

    public void connect(InetAddress inetAddress, int n) throws IOException {
        this.connect(this.createSocket(inetAddress, n));
    }

    public void connect(InetAddress inetAddress, int n, int n2) throws IOException {
        this.connect(this.createSocket(inetAddress, n, n2));
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    protected Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        try {
            WeblogicSocketFactory weblogicSocketFactory = (WeblogicSocketFactory)this.socketFactory;
            return weblogicSocketFactory.createSocket(inetAddress, n, n2);
        }
        catch (ClassCastException classCastException) {
            return this.socketFactory.createSocket(inetAddress, n);
        }
    }

    protected static void p(String string) {
        System.out.println("<BaseAbstractMuxableSocket>: " + string);
    }

    protected void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final Chunk getChunk() {
        return this.head;
    }

    public byte[] getBuffer() {
        Chunk chunk = this.ensureCapacity(this.head);
        return chunk.buf;
    }

    public int getBufferOffset() {
        Chunk chunk = this.tailWithSpace(this.head);
        return chunk.end;
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        ByteBuffer byteBuffer;
        if (this.tail == null) {
            this.tail = this.head;
        }
        Chunk chunk = this.tail = this.ensureCapacity(this.tail);
        ByteBuffer byteBuffer2 = chunk.getReadByteBuffer();
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        arrayList.add(byteBuffer2);
        for (int i = byteBuffer2.remaining(); i < n; i += byteBuffer.remaining()) {
            Chunk chunk2 = chunk.next;
            if (chunk2 == null) {
                chunk.next = chunk2 = Chunk.getChunk();
            }
            byteBuffer = chunk2.getReadByteBuffer();
            arrayList.add(byteBuffer);
            chunk = chunk2;
        }
        return arrayList.toArray(new ByteBuffer[arrayList.size()]);
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        if (this.tail == null) {
            this.tail = this.head;
        }
        Chunk chunk = this.tail = this.tailWithSpace(this.tail);
        this.availBytes += n;
        while (true) {
            int n2 = Math.min(n, Chunk.CHUNK_SIZE - chunk.end);
            chunk.end += n2;
            if ((n -= n2) == 0) break;
            chunk = chunk.next;
        }
        if (chunk.next != null && chunk.next.end == 0) {
            Chunk.releaseChunks((Chunk)chunk.next);
            chunk.next = null;
        }
        this.tail = chunk;
        if (this.availBytes > this.maxMessageSize) {
            throw new MaxMessageSizeExceededException(this.availBytes, this.maxMessageSize, this.channel.getConfiguredProtocol());
        }
    }

    private Chunk tailWithSpace(Chunk chunk) {
        Chunk chunk2 = chunk;
        while (chunk2.next != null && (chunk2.end == Chunk.CHUNK_SIZE || chunk2.next.end != 0)) {
            chunk2 = chunk2.next;
        }
        return chunk2;
    }

    private Chunk ensureCapacity(Chunk chunk) {
        chunk = this.tailWithSpace(chunk);
        if (Chunk.CHUNK_SIZE == chunk.end) {
            chunk.next = Chunk.getChunk();
            return chunk.next;
        }
        return chunk;
    }

    protected Chunk makeChunkList() {
        Chunk chunk = this.head;
        if (this.availBytes == this.msgLength) {
            this.head = this.tail = Chunk.getChunk();
        } else {
            this.head = Chunk.split((Chunk)this.head, (int)this.msgLength);
            this.tail = null;
        }
        ++this.messagesReceived;
        this.bytesReceived += (long)this.msgLength;
        this.availBytes -= this.msgLength;
        this.msgLength = -1;
        return chunk;
    }

    public long getMessagesReceivedCount() {
        return this.messagesReceived;
    }

    public long getBytesReceivedCount() {
        return this.bytesReceived;
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    public final int getFileDescriptor() {
        if (this.isClosed()) {
            return -1;
        }
        SocketInfo socketInfo = this.getSocketInfo();
        return socketInfo == null ? -1 : socketInfo.getFD();
    }

    public final String getLocalAddress() {
        if (this.isClosed() || this.socket == null) {
            return "<closed>";
        }
        return this.socket.getLocalAddress().toString();
    }

    public final int getLocalPort() {
        if (this.isClosed() || this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    public final String getRemoteAddress() {
        if (this.isClosed() || this.socket == null) {
            return "<closed>";
        }
        return this.socket.getInetAddress().toString();
    }

    public final int getRemotePort() {
        if (this.isClosed() || this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    public final Protocol getProtocol() {
        return this.channel.getProtocol();
    }

    private Object writeReplace() {
        return new SocketRuntimeImpl(this);
    }

    public boolean isMessageComplete() {
        if (this.msgLength > -1) {
            return this.availBytes >= this.msgLength;
        }
        if (this.availBytes >= this.getHeaderLength()) {
            this.msgLength = this.getMessageLength();
            return this.availBytes >= this.msgLength && this.msgLength > -1;
        }
        return false;
    }

    protected final byte getHeaderByte(int n) {
        return this.head.end > n ? this.head.buf[n] : this.head.next.buf[n - this.head.end];
    }

    public void dispatch() {
        while (this.isMessageComplete()) {
            this.dispatch(this.makeChunkList());
        }
        SocketMuxer.getMuxer().read(this.getSocketFilter());
    }

    protected int getMessageLength() {
        throw new UnsupportedOperationException("getMessageLength()");
    }

    protected int getHeaderLength() {
        throw new UnsupportedOperationException("getHeaderLength()");
    }

    protected final int getAvailableBytes() {
        return this.availBytes;
    }

    protected void dispatch(Chunk chunk) {
        throw new UnsupportedOperationException("dispatch()");
    }

    public final ServerChannel getChannel() {
        return this.channel;
    }

    public final Socket getSocket() {
        return this.socket;
    }

    public boolean closeSocketOnError() {
        return true;
    }

    public final InputStream getSocketInputStream() {
        return this.sis;
    }

    public final OutputStream getSocketOutputStream() {
        return this.sos;
    }

    public final void setSoTimeout(int n) throws SocketException {
        if (n == this.soTimeout) {
            return;
        }
        this.soTimeout = n;
        this.socket.setSoTimeout(n);
    }

    protected final int getSoTimeout() {
        return this.soTimeout;
    }

    protected final boolean isClosed() {
        return this.closeLatch.isLocked();
    }

    public final void close() {
        if (this.closeLatch.tryLock()) {
            this.cleanup();
        }
    }

    protected void cleanup() {
        this.sis = null;
        this.sos = null;
    }

    public void hasException(Throwable throwable) {
        this.close();
    }

    public void endOfStream() {
        this.close();
    }

    public boolean timeout() {
        this.close();
        return true;
    }

    public boolean requestTimeout() {
        return true;
    }

    public int getIdleTimeoutMillis() {
        return this.channel.getIdleConnectionTimeout() * 1000;
    }

    public int getCompleteMessageTimeoutMillis() {
        return this.channel.getCompleteMessageTimeout() * 1000;
    }

    public final MuxableSocket getSocketFilter() {
        return this.filter;
    }

    public final void setSocketFilter(MuxableSocket muxableSocket) {
        this.filter = muxableSocket;
    }

    public final SocketInfo getSocketInfo() {
        return this.info;
    }

    public final void setSocketInfo(SocketInfo socketInfo) {
        this.info = socketInfo;
    }

    public String toString() {
        return super.toString() + ":" + this.socket;
    }

    public int size() {
        return KEYS.length;
    }

    public String[] getNames() {
        return KEYS;
    }

    public Object getValue(String string) {
        if (string.equals("com.bea.contextelement.channel.Port")) {
            return new Integer(this.channel.getPort());
        }
        if (string.equals("com.bea.contextelement.channel.PublicPort")) {
            return new Integer(this.channel.getPublicPort());
        }
        if (string.equals("com.bea.contextelement.channel.RemotePort")) {
            return new Integer(this.getRemotePort());
        }
        if (string.equals("com.bea.contextelement.channel.Protocol")) {
            return this.getProtocol().getAsURLPrefix();
        }
        if (string.equals("com.bea.contextelement.channel.Address")) {
            return this.channel.getAddress();
        }
        if (string.equals("com.bea.contextelement.channel.PublicAddress")) {
            return this.channel.getPublicAddress();
        }
        if (string.equals("com.bea.contextelement.channel.RemoteAddress")) {
            return this.getRemoteAddress();
        }
        if (string.equals("com.bea.contextelement.channel.ChannelName")) {
            return this.channel.getChannelName();
        }
        if (string.equals("com.bea.contextelement.channel.Secure")) {
            return new Boolean(this.channel.supportsTLS());
        }
        return null;
    }

    public ContextElement[] getValues(String[] stringArray) {
        ContextElement[] contextElementArray = new ContextElement[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            contextElementArray[i] = new ContextElement(stringArray[i], this.getValue(stringArray[i]));
        }
        return contextElementArray;
    }

    protected void resetData() {
        this.tail = this.head = Chunk.getChunk();
        this.availBytes = 0;
        this.msgLength = -1;
        this.bytesReceived = 0L;
        this.messagesReceived = 0L;
    }

    public boolean supportsScatteredRead() {
        return false;
    }

    public long read(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }
}

