/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import javax.net.ssl.SSLSocketFactory;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerChannel;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.Security;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLSetup;
import weblogic.socket.SocketMuxer;

public final class ChannelSSLSocketFactory
extends weblogic.security.SSL.SSLSocketFactory {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ServerChannel channel;
    private SSLClientInfo sslInfo;

    public ChannelSSLSocketFactory(ServerChannel serverChannel) {
        super((SSLSocketFactory)null);
        if (serverChannel == null) {
            throw new IllegalArgumentException("Channel must not be null");
        }
        this.channel = serverChannel;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n);
    }

    public weblogic.security.SSL.SSLSocketFactory initializeFromThread() throws IOException {
        this.sslInfo = this.createSSLClientInfo();
        return this;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSocketFactory();
        if (KernelStatus.isServer() && this.channel.isOutboundEnabled()) {
            return sSLSocketFactory.createSocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0);
        }
        Socket socket = SocketMuxer.getMuxer().newSSLClientSocket(inetAddress, n);
        if (socket != null) {
            return sSLSocketFactory.createSocket(socket, inetAddress.getHostAddress(), n, true);
        }
        return sSLSocketFactory.createSocket(inetAddress, n);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket;
        int n3;
        int n4 = n3 = n2 > 0 ? n2 : this.channel.getConnectTimeout() * 1000;
        if (n3 == 0) {
            return this.createSocket(inetAddress, n);
        }
        if (KernelStatus.isServer() && this.channel.isOutboundEnabled()) {
            socket = this.channel.getProxyAddress() != null ? SocketMuxer.getMuxer().newProxySocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0, InetAddress.getByName(this.channel.getProxyAddress()), this.channel.getProxyPort(), n3) : SocketMuxer.getMuxer().newSocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0, n3);
        } else {
            socket = SocketMuxer.getMuxer().newSSLClientSocket(inetAddress, n, n3);
            if (socket == null) {
                socket = SocketMuxer.getMuxer().newSocket(inetAddress, n, n3);
            }
        }
        return this.createSocket(socket, inetAddress.getHostName(), n, true);
    }

    private InetAddress getInetAddressFor(String string) throws UnknownHostException {
        return string != null ? InetAddress.getByName(string) : (InetAddress)null;
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getSocketFactory().getDefaultCipherSuites();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new IllegalStateException().initCause(iOException);
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getSocketFactory().getSupportedCipherSuites();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new IllegalStateException().initCause(iOException);
        }
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.getSocketFactory().createSocket(socket, string, n, bl);
    }

    private SSLSocketFactory getSocketFactory() throws IOException {
        if (this.sslInfo == null) {
            this.sslInfo = this.createSSLClientInfo();
            this.sslInfo.setNio(SocketMuxer.getMuxer().isAsyncMuxer());
        }
        return this.sslInfo.getSSLSocketFactory();
    }

    public SSLClientInfo getSSLClientInfo() {
        return this.sslInfo;
    }

    private SSLClientInfo createSSLClientInfo() throws IOException {
        SSLClientInfo sSLClientInfo = Security.getThreadSSLClientInfo();
        if (KernelStatus.isServer() && (sSLClientInfo == null || sSLClientInfo.isEmpty()) && kernelId == SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId) || this.channel.isOutboundEnabled() && this.channel.isOutboundPrivateKeyEnabled()) {
            try {
                return SSLContextManager.getChannelSSLClientInfo(this.channel, kernelId);
            }
            catch (Exception exception) {
                throw (IOException)new IOException(exception.getMessage()).initCause(exception);
            }
        }
        return sSLClientInfo;
    }

    public void setSSLClientInfo(SSLClientInfo sSLClientInfo) {
        try {
            if (SocketMuxer.getMuxer().isAsyncMuxer()) {
                if (sSLClientInfo != null && !sSLClientInfo.isNioSet()) {
                    sSLClientInfo.setNio(true);
                }
                this.jsseFactory = sSLClientInfo == null ? SSLSetup.getSSLContext(sSLClientInfo).getSSLNioSocketFactory() : sSLClientInfo.getSSLSocketFactory();
            } else {
                this.jsseFactory = sSLClientInfo == null ? SSLSetup.getSSLContext(sSLClientInfo).getSSLSocketFactory() : sSLClientInfo.getSSLSocketFactory();
            }
            this.sslInfo = sSLClientInfo;
        }
        catch (SocketException socketException) {
            SSLSetup.debug(3, socketException, "Failed to create context");
            throw new RuntimeException("Failed to update factory: " + socketException.getMessage());
        }
    }
}

