/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.ServerChannel;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicSocketFactory;

public final class ChannelSocketFactory
extends WeblogicSocketFactory {
    private ServerChannel channel;

    public ChannelSocketFactory(ServerChannel serverChannel) {
        if (serverChannel == null) {
            throw new IllegalArgumentException("Channel must not be null");
        }
        this.channel = serverChannel;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        int n3;
        int n4 = n3 = n2 > 0 ? n2 : this.channel.getConnectTimeout() * 1000;
        if (KernelStatus.isServer() && this.channel.isOutboundEnabled()) {
            if (this.channel.getProxyAddress() != null) {
                return SocketMuxer.getMuxer().newProxySocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0, InetAddress.getByName(this.channel.getProxyAddress()), this.channel.getProxyPort(), n3);
            }
            if (this.channel.isSDPEnabled()) {
                return SocketMuxer.getMuxer().newSDPSocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0, n3);
            }
            return SocketMuxer.getMuxer().newSocket(inetAddress, n, this.getInetAddressFor(this.channel.getAddress()), 0, n3);
        }
        return SocketMuxer.getMuxer().newClientSocket(inetAddress, n, n3);
    }

    private InetAddress getInetAddressFor(String string) throws UnknownHostException {
        return string != null ? InetAddress.getByName(string) : (InetAddress)null;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        throw new UnsupportedOperationException("Binding characteristics are determined by the channel");
    }
}

