/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketMuxer;
import weblogic.utils.AssertionError;
import weblogic.utils.io.ChunkedInputStream;

public final class ClientSSLFilterImpl
implements SSLFilter {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private boolean activated = false;
    private final InputStream in;
    private int pos;
    private int availBytes;
    private MuxableSocket delegate;
    private final SSLSocket sslSocket;
    private SocketInfo sockInfo;

    public ClientSSLFilterImpl(InputStream inputStream, SSLSocket sSLSocket) throws IOException {
        this.in = inputStream;
        this.sslSocket = sSLSocket;
        SSLSetupLogging.info("Filtering JSSE SSLSocket");
    }

    public String toString() {
        return "ClientSSLFilterImpl[" + this.getDelegate() + "]";
    }

    public MuxableSocket getDelegate() {
        return this.delegate;
    }

    public void setDelegate(MuxableSocket muxableSocket) {
        this.delegate = muxableSocket;
    }

    public void asyncOn() {
        this.activated = true;
    }

    public void asyncOff() {
        this.activated = false;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public int available() throws IOException {
        if (!this.activated) {
            return this.in.available();
        }
        return this.availBytes;
    }

    public void activate() throws IOException {
        SSLSetupLogging.info("ClientSSLFilterImpl.activate()");
        this.activateNoRegister();
        if (this.delegate.isMessageComplete()) {
            SocketMuxer.getMuxer().register(this);
            this.delegate.dispatch();
        } else {
            SocketMuxer.getMuxer().register(this);
            SocketMuxer.getMuxer().read(this);
        }
    }

    public void activateNoRegister() throws IOException {
        SSLSetupLogging.info("activateNoRegister()");
        this.activated = true;
        SSLSetupLogging.info("ClientSSLFilterImpl.activate(): activated: " + this.in.hashCode());
    }

    public int getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    public byte[] getBuffer() {
        return this.delegate.getBuffer();
    }

    public int getBufferOffset() {
        return this.delegate.getBufferOffset();
    }

    private static void p(String string) {
        System.out.println("ClientSSLFilterImpl: " + string);
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        this.delegate.incrementBufferOffset(n);
    }

    public boolean isMessageComplete() {
        return this.delegate.isMessageComplete();
    }

    public void dispatch() {
        this.delegate.dispatch();
    }

    public InputStream getSocketInputStream() {
        return this.in;
    }

    public void setSoTimeout(int n) throws SocketException {
        this.delegate.setSoTimeout(n);
    }

    public Socket getSocket() {
        return this.sslSocket;
    }

    public boolean closeSocketOnError() {
        return true;
    }

    public void hasException(Throwable throwable) {
        if (!(throwable instanceof SocketException)) {
            SSLSetupLogging.debug(3, throwable, "hasException");
        }
        this.delegate.hasException(throwable);
    }

    public void endOfStream() {
        this.delegate.endOfStream();
    }

    public boolean timeout() {
        return this.delegate.timeout();
    }

    public boolean requestTimeout() {
        return this.delegate.requestTimeout();
    }

    public int getCompleteMessageTimeoutMillis() {
        return this.delegate.getCompleteMessageTimeoutMillis();
    }

    public void setSocketFilter(MuxableSocket muxableSocket) {
        throw new AssertionError("Re-register Muxer not allowed on ClientSSLFilterImpl");
    }

    public MuxableSocket getSocketFilter() {
        return this;
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.sockInfo = socketInfo;
    }

    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    public void ensureForceClose() {
        try {
            this.sslSocket.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ChunkedInputStream getInputStream() {
        return null;
    }

    public boolean supportsScatteredRead() {
        return false;
    }

    public long read(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        throw new UnsupportedOperationException();
    }
}

