/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import weblogic.kernel.Kernel;
import weblogic.socket.DevPollSocketInfo;
import weblogic.socket.MuxableSocket;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.utils.Debug;
import weblogic.utils.NestedError;
import weblogic.utils.net.SocketResetException;

final class DevPollSocketMuxer
extends ServerSocketMuxer {
    private final DevPollSocketInfo[] sockRecords;
    private final int maxNumberOfFds;
    private final Object pollLock = new String("pollLock");
    private final Object pollSetLock = new String("pollSetLock");
    private static final boolean debug = Debug.getCategory((String)"weblogic.socket.DevPollSocketMuxer").isEnabled();
    static final byte FD_ADD = 2;
    static final byte FD_REM = 4;

    public DevPollSocketMuxer() throws IOException {
        Debug.assertion((boolean)Kernel.isServer());
        System.loadLibrary("muxer");
        try {
            this.maxNumberOfFds = DevPollSocketMuxer.initDevPoll() + 1;
        }
        catch (IOException iOException) {
            SocketLogger.logInitPerf();
            throw new NestedError("Could not initialize /dev/poll Performance Pack. Ensure that /dev/poll device exists and is initialized.", (Throwable)iOException);
        }
        SocketLogger.logFdCurrent((int)this.maxNumberOfFds);
        SocketLogger.logTimeStamp((String)DevPollSocketMuxer.getBuildTime());
        this.initSocketReaderThreads(3, "weblogic.socket.Muxer", "weblogic.DevPollSocketReaders");
        this.sockRecords = new DevPollSocketInfo[this.maxNumberOfFds];
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        DevPollSocketInfo devPollSocketInfo = new DevPollSocketInfo(muxableSocket);
        muxableSocket.setSocketInfo((SocketInfo)devPollSocketInfo);
        super.register(muxableSocket);
        if (debug) {
            DevPollSocketMuxer.p("Registered ms=" + muxableSocket + " info=" + (Object)((Object)devPollSocketInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(MuxableSocket muxableSocket) {
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        if (!this.initiateIO(socketInfo)) {
            return;
        }
        DevPollSocketInfo devPollSocketInfo = (DevPollSocketInfo)socketInfo;
        int n = devPollSocketInfo.fd;
        DevPollSocketInfo devPollSocketInfo2 = devPollSocketInfo;
        synchronized (devPollSocketInfo2) {
            this.sockRecords[n] = devPollSocketInfo;
            Object object = this.pollSetLock;
            synchronized (object) {
                try {
                    DevPollSocketMuxer.editPollSet(n, (byte)2);
                }
                catch (IOException iOException) {
                    throw new NestedError("Error adding FD to pollset " + (Object)((Object)devPollSocketInfo), (Throwable)iOException);
                }
            }
            if (debug) {
                DevPollSocketMuxer.p("Read ms=" + muxableSocket + " info=" + muxableSocket.getSocketInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSockets() {
        while (true) {
            int[][] nArray = null;
            Object object = this.pollLock;
            synchronized (object) {
                try {
                    if (debug) {
                        DevPollSocketMuxer.p("processSockets about to poll ........... ");
                    }
                    nArray = DevPollSocketMuxer.doPoll();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    SocketLogger.logUncaughtThrowable((Throwable)throwable);
                    continue;
                }
                if (debug) {
                    DevPollSocketMuxer.p("processSockets poll returned " + nArray);
                }
                if (nArray == null) {
                    continue;
                }
            }
            for (int i = 0; i < nArray[0].length; ++i) {
                int n = nArray[0][i];
                if (n == 0) continue;
                int n2 = nArray[1][i];
                DevPollSocketInfo devPollSocketInfo = this.sockRecords[n];
                if (devPollSocketInfo == null) {
                    SocketLogger.logSocketInfoNotFound((int)n, (int)n2);
                    continue;
                }
                MuxableSocket muxableSocket = devPollSocketInfo.getMuxableSocket();
                if (!this.completeIO(muxableSocket, devPollSocketInfo)) continue;
                if (n2 == 0) {
                    try {
                        if (debug) {
                            DevPollSocketMuxer.p("processSockets dispatching " + (Object)((Object)devPollSocketInfo));
                        }
                        this.readReadySocket(muxableSocket, devPollSocketInfo, 0L);
                    }
                    catch (Throwable throwable) {
                        if (debug) {
                            DevPollSocketMuxer.p("processSockets dispatching exception " + (Object)((Object)devPollSocketInfo));
                        }
                        this.deliverHasException(muxableSocket, throwable);
                    }
                    continue;
                }
                if (debug) {
                    DevPollSocketMuxer.p("processSockets exception " + (Object)((Object)devPollSocketInfo));
                }
                this.deliverHasException(muxableSocket, (Throwable)new SocketResetException("Error detected on fd " + devPollSocketInfo.fd + " revents=" + n2));
            }
            try {
                if (DELAYPOLLWAKEUP <= 0L) continue;
                Thread.sleep(DELAYPOLLWAKEUP);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    void cleanupSocket(MuxableSocket muxableSocket, SocketInfo socketInfo) {
        this.sockRecords[socketInfo.getFD()] = null;
        super.cleanupSocket(muxableSocket, socketInfo);
    }

    private static void p(String string) {
        SocketLogger.logDebug((String)(Thread.currentThread().getName() + " + + + + + " + string));
    }

    protected void cancelIo(MuxableSocket muxableSocket) {
        super.cancelIo(muxableSocket);
        this.cleanupSocket(muxableSocket, muxableSocket.getSocketInfo());
    }

    private static native int initDevPoll() throws IOException;

    private static native int[][] doPoll() throws IOException;

    static native void editPollSet(int var0, byte var1) throws IOException;

    private static native String getBuildTime();
}

