/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import jrockit.ext.epoll.EPoll;
import jrockit.ext.epoll.EPollEventBuffer;
import weblogic.kernel.Kernel;
import weblogic.socket.EPollSocketInfo;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NativeSocketInfo;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.utils.Debug;
import weblogic.utils.net.SocketResetException;

final class EPollSocketMuxer
extends ServerSocketMuxer {
    private static Object pollBufferLock = new String("PollBufferLock");
    private Object pollLock = new String("PollLock");
    private static int[] freeRecords;
    private static int firstFree;
    private static EPollSocketInfo[] sockRecords;
    private static int nRecords;
    private static EPoll epoll;
    private static final boolean debug = false;

    public EPollSocketMuxer() throws IOException {
        Debug.assertion((boolean)Kernel.isServer());
        int n = 100;
        epoll = new EPoll();
        this.initSocketReaderThreads(3, "weblogic.socket.Muxer", "weblogic.EPollSocketReaders");
        sockRecords = new EPollSocketInfo[n];
        freeRecords = new int[n];
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        EPollSocketInfo ePollSocketInfo = new EPollSocketInfo(muxableSocket);
        muxableSocket.setSocketInfo((SocketInfo)ePollSocketInfo);
        super.register(muxableSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(MuxableSocket muxableSocket) {
        EPollSocketInfo ePollSocketInfo;
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        if (!this.initiateIO(socketInfo)) {
            return;
        }
        EPollSocketInfo ePollSocketInfo2 = ePollSocketInfo = (EPollSocketInfo)socketInfo;
        synchronized (ePollSocketInfo2) {
            try {
                int n = ePollSocketInfo.getIndex();
                if (n == -1) {
                    n = EPollSocketMuxer.add(ePollSocketInfo);
                    epoll.epollAddOneshot(ePollSocketInfo.getFD(), n);
                } else {
                    epoll.epollEnableOneshot(ePollSocketInfo.getFD(), n);
                }
            }
            catch (IOException iOException) {
                this.deliverHasException(muxableSocket, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int add(EPollSocketInfo ePollSocketInfo) {
        int n;
        Object object = pollBufferLock;
        synchronized (object) {
            n = firstFree;
            if (n == -1) {
                if ((n = nRecords++) == sockRecords.length) {
                    int[] nArray = new int[freeRecords.length * 2];
                    EPollSocketInfo[] ePollSocketInfoArray = new EPollSocketInfo[sockRecords.length * 2];
                    System.arraycopy(sockRecords, 0, ePollSocketInfoArray, 0, sockRecords.length);
                    System.arraycopy(freeRecords, 0, nArray, 0, freeRecords.length);
                    freeRecords = nArray;
                    sockRecords = ePollSocketInfoArray;
                }
            } else {
                firstFree = freeRecords[n];
            }
            EPollSocketMuxer.sockRecords[n] = ePollSocketInfo;
            ePollSocketInfo.setIndex(n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(int n, int n2) {
        Object object = pollBufferLock;
        synchronized (object) {
            EPollSocketMuxer.freeRecords[n] = firstFree;
            EPollSocketMuxer.sockRecords[n] = null;
            firstFree = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSockets() {
        int n = 0;
        int n2 = 128;
        EPollEventBuffer ePollEventBuffer = EPollEventBuffer.allocEventBuffer((int)n2);
        while (true) {
            int n3;
            Object object = this.pollLock;
            synchronized (object) {
                try {
                    n3 = epoll.epollWait(ePollEventBuffer);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    SocketLogger.logUncaughtThrowable((Throwable)throwable);
                    continue;
                }
            }
            for (int i = 0; i < n3; ++i) {
                int n4 = ePollEventBuffer.getID(i);
                int n5 = ePollEventBuffer.getEvent(i);
                EPollSocketInfo ePollSocketInfo = sockRecords[n4];
                if (ePollSocketInfo == null) {
                    SocketLogger.logSocketInfoNotFound((int)n4, (int)n5);
                    continue;
                }
                this.dataReceived(n5, ePollSocketInfo);
            }
            if (n3 == ePollEventBuffer.getSize() && n2 < 2048) {
                if (++n > 8) {
                    n = 0;
                    n2 = ePollEventBuffer.getSize() * 2;
                    EPollEventBuffer.freeEventBuffer((EPollEventBuffer)ePollEventBuffer);
                    ePollEventBuffer = EPollEventBuffer.allocEventBuffer((int)n2);
                }
            } else {
                n = 0;
            }
            try {
                if (DELAYPOLLWAKEUP <= 0L) continue;
                Thread.sleep(DELAYPOLLWAKEUP);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    private void dataReceived(int n, EPollSocketInfo ePollSocketInfo) {
        MuxableSocket muxableSocket = ePollSocketInfo.getMuxableSocket();
        if (!this.completeIO(muxableSocket, ePollSocketInfo)) {
            return;
        }
        if (n == 1) {
            try {
                this.readReadySocket(muxableSocket, ePollSocketInfo, 0L);
            }
            catch (Throwable throwable) {
                this.deliverHasException(muxableSocket, throwable);
            }
        } else {
            this.deliverHasException(muxableSocket, (Throwable)new SocketResetException("Error detected on fd " + ePollSocketInfo.fd + " revents=" + n));
        }
    }

    private static void p(String string) {
        SocketLogger.logDebug((String)(Thread.currentThread().getName() + " + + + + + " + string));
    }

    protected void cancelIo(MuxableSocket muxableSocket) {
        try {
            epoll.epollRemove(((NativeSocketInfo)muxableSocket.getSocketInfo()).fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.cancelIo(muxableSocket);
        this.cleanupSocket(muxableSocket, muxableSocket.getSocketInfo());
    }

    static {
        firstFree = -1;
    }
}

