/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;

public class JSSEFilterImpl
implements MuxableSocket {
    private SSLEngine sslEngine;
    private ByteBuffer readNWDataInBuf;
    private ByteBuffer writeNWDataOutBuf;
    private ByteBuffer clearTextBuf;
    private boolean initialHSComplete;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private Socket sock;
    private MuxableSocket delegate;
    private SocketInfo sockInfo;
    private InputStream in;
    private OutputStream out;
    private Set<HandshakeListener> handshakeCompletedListeners = new HashSet<HandshakeListener>();
    private static final boolean BLOCKING_READ_ALLOWED = true;
    private static final boolean NO_BLOCKING_READ = false;
    private IOException cachedException = null;

    public JSSEFilterImpl(Socket socket, SSLEngine sSLEngine) throws IOException {
        this(socket, sSLEngine, false);
    }

    public JSSEFilterImpl(Socket socket, SSLEngine sSLEngine, boolean bl) throws IOException {
        this.sslEngine = sSLEngine;
        this.sock = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.sslEngine.setUseClientMode(bl);
        this.readNWDataInBuf = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize() + 50);
        this.writeNWDataOutBuf = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize() + 50);
        this.clearTextBuf = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize() + 50);
        this.handshakeStatus = bl ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    public synchronized boolean doHandshake() throws IOException {
        this.initialHSComplete = false;
        this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        return this.doHandshake(this, true);
    }

    private boolean doHandshake(MuxableSocket muxableSocket, boolean bl) throws IOException {
        return this.doHandshake(null, muxableSocket, bl);
    }

    private boolean doHandshake(ByteBuffer byteBuffer, MuxableSocket muxableSocket, boolean bl) throws IOException {
        SSLEngineResult sSLEngineResult = null;
        if (this.initialHSComplete) {
            return this.initialHSComplete;
        }
        while (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    sSLEngineResult = this.unwrapAndHandleResults(byteBuffer, muxableSocket, bl);
                    this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    if (bl || sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                    return false;
                }
                case NEED_WRAP: {
                    sSLEngineResult = this.wrapAndWrite(ByteBuffer.allocate(0), bl);
                    this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    break;
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.doTasks();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)this.handshakeStatus));
                }
            }
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) continue;
            return false;
        }
        this.initialHSComplete = true;
        this.notifyHandshakeComplete();
        return this.initialHSComplete;
    }

    private void notifyHandshakeComplete() {
        if (this.handshakeCompletedListeners.isEmpty()) {
            return;
        }
        for (HandshakeListener handshakeListener : this.handshakeCompletedListeners) {
            handshakeListener.handshakeDone(this.sslEngine.getSession());
        }
    }

    public ByteBuffer getClearTextBuf() {
        return this.clearTextBuf;
    }

    public void addHandshakeCompletedListener(HandshakeListener handshakeListener) {
        if (null == handshakeListener) {
            throw new IllegalArgumentException("Non-null HandshakeCompletedListener expected.");
        }
        this.handshakeCompletedListeners.add(handshakeListener);
        if (null == this.delegate || null == this.delegate.getSocket()) {
            SocketLogger.logDebug((String)("No SSLSocket when adding HandshakeCompletedListener: class=" + handshakeListener.getClass().getName() + ", instance=" + handshakeListener + ", on " + this + ". An associated SSLSocket is required."));
        }
        SocketLogger.logDebug((String)("Added HandshakeCompletedListener: class=" + handshakeListener.getClass().getName() + ", instance=" + handshakeListener + ", on " + this + " ."));
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (null == handshakeCompletedListener) {
            throw new IllegalArgumentException("Non-null HandshakeCompletedListener expected.");
        }
        if (!this.handshakeCompletedListeners.remove(handshakeCompletedListener)) {
            String string = SocketLogger.logUnregisteredHandshakeCompletedListener((String)handshakeCompletedListener.getClass().getName(), (String)handshakeCompletedListener.toString());
            throw new IllegalArgumentException(string);
        }
        SocketLogger.logDebug((String)("Removed HandshakeCompletedListener: class=" + handshakeCompletedListener.getClass().getName() + ", instance=" + handshakeCompletedListener + "."));
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public boolean closeSocketOnError() {
        return true;
    }

    public void dispatch() {
        this.delegate.dispatch();
    }

    public void endOfStream() {
        this.delegate.endOfStream();
    }

    public byte[] getBuffer() {
        return this.readNWDataInBuf.array();
    }

    public int getBufferOffset() {
        return this.readNWDataInBuf.position();
    }

    public int getCompleteMessageTimeoutMillis() {
        return this.delegate.getCompleteMessageTimeoutMillis();
    }

    public int getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    public Socket getSocket() {
        return this.sock;
    }

    public MuxableSocket getSocketFilter() {
        return this;
    }

    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    public InputStream getSocketInputStream() {
        return this.in;
    }

    public void hasException(Throwable throwable) {
        this.delegate.hasException(throwable);
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        this.readNWDataInBuf.position(this.readNWDataInBuf.position() + n);
    }

    public int getAvailableBytes() {
        return this.getClearTextBuf().position();
    }

    private boolean isRehandshakeNeeded(SSLEngineResult sSLEngineResult) throws IOException {
        return this.initialHSComplete && sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageComplete() {
        try {
            Object object = this;
            synchronized (object) {
                if (this.getAvailableBytes() > 0) {
                    ByteBuffer[] byteBufferArray = this.delegate.getAvailableBufferofSize(this.getAvailableBytes());
                    int n = this.fillAppBuf(byteBufferArray);
                    this.delegate.incrementBufferOffset(n);
                }
            }
            if (!this.initialHSComplete && !this.doHandshake(this.delegate, false)) {
                return false;
            }
            do {
                if (((SSLEngineResult)(object = this.unwrapAndHandleResults(this.delegate, false))).bytesProduced() <= 0) continue;
                this.delegate.incrementBufferOffset(((SSLEngineResult)object).bytesProduced());
            } while (this.readNWDataInBuf.position() > 0 && ((SSLEngineResult)object).getStatus() == SSLEngineResult.Status.OK);
            if (!this.initialHSComplete) {
                return false;
            }
            return this.delegate.isMessageComplete();
        }
        catch (Exception exception) {
            SocketLogger.logDebug((String)("Caught sslException: " + exception + " returning false for isMessageComplete"));
            this.delegate.hasException((Throwable)exception);
            return false;
        }
    }

    public boolean requestTimeout() {
        return this.delegate.requestTimeout();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.delegate.setSoTimeout(n);
    }

    public void setSocketFilter(MuxableSocket muxableSocket) {
        throw new UnsupportedOperationException("Re-register Muxer not allowed on JSSEFilterImpl");
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.sockInfo = socketInfo;
    }

    public boolean timeout() {
        return this.delegate.timeout();
    }

    public MuxableSocket getDelegate() {
        return this.delegate;
    }

    public void setDelegate(MuxableSocket muxableSocket) {
        this.delegate = muxableSocket;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.sslEngine.isInboundDone()) {
            this.checkCauseSSLEngineClosed();
        }
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        if (this.getAvailableBytes() > 0) {
            return this.fillAppBuf(new ByteBuffer[]{byteBuffer});
        }
        if (this.getAvailableBytes(this.readNWDataInBuf) == 0 && (n3 = this.readFromNetwork()) <= -1) {
            return n3;
        }
        this.unwrapAndHandleResults(byteBuffer, this, true);
        return byteBuffer.position() - n;
    }

    private void checkCauseSSLEngineClosed() throws IOException {
        if (this.cachedException != null) {
            throw this.cachedException;
        }
        throw new IOException("SSLEngine is closed");
    }

    private int getAvailableBytes(ByteBuffer byteBuffer) {
        return byteBuffer.position();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.sslEngine.isOutboundDone()) {
            this.checkCauseSSLEngineClosed();
        }
        if (!this.initialHSComplete) {
            this.doHandshake();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        while (byteBuffer.position() < byteBuffer.limit()) {
            this.wrapAndWrite(byteBuffer, true);
        }
    }

    private int readFromNetwork() throws IOException {
        int n = this.in.read(this.readNWDataInBuf.array(), this.readNWDataInBuf.position(), this.readNWDataInBuf.remaining());
        if (n > 0) {
            this.incrementBufferOffset(n);
        }
        return n;
    }

    private SSLEngineResult unwrapAndHandleResults(MuxableSocket muxableSocket, boolean bl) throws IOException {
        return this.unwrapAndHandleResults(null, muxableSocket, bl);
    }

    private SSLEngineResult unwrapAndHandleResults(ByteBuffer byteBuffer, MuxableSocket muxableSocket, boolean bl) throws IOException {
        int n;
        int n2 = n = this.sslEngine.getSession().getApplicationBufferSize();
        ByteBuffer[] byteBufferArray = this.createBuffers(byteBuffer, muxableSocket, n);
        SSLEngineResult sSLEngineResult = this.unwrap(byteBufferArray);
        while (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            byteBufferArray = this.createBuffers(byteBuffer, muxableSocket, n += n2);
            sSLEngineResult = this.unwrap(byteBufferArray);
        }
        this.handleUnwrapResults(sSLEngineResult, byteBuffer, muxableSocket, bl);
        return sSLEngineResult;
    }

    private ByteBuffer[] createBuffers(ByteBuffer byteBuffer, MuxableSocket muxableSocket, int n) throws IOException {
        ByteBuffer[] byteBufferArray = byteBuffer != null ? this.getBufferArray(byteBuffer, n) : muxableSocket.getAvailableBufferofSize(n);
        return byteBufferArray;
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        return this.getBufferArray(null, n);
    }

    private ByteBuffer growClearTextBuf(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.clearTextBuf = this.getClearTextBuf().position() == 0 ? byteBuffer : byteBuffer.put(this.getClearTextBuf());
        return this.clearTextBuf;
    }

    private ByteBuffer[] getBufferArray(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = this.getClearTextBuf();
        if (byteBuffer2.remaining() < n) {
            byteBuffer2 = this.growClearTextBuf(n);
        }
        if (byteBuffer != null) {
            return new ByteBuffer[]{byteBuffer, byteBuffer2};
        }
        return new ByteBuffer[]{byteBuffer2};
    }

    private SSLEngineResult unwrap(ByteBuffer[] byteBufferArray) throws IOException {
        SSLEngineResult sSLEngineResult;
        this.readNWDataInBuf.flip();
        try {
            try {
                sSLEngineResult = this.sslEngine.unwrap(this.readNWDataInBuf, byteBufferArray);
            }
            catch (SSLException sSLException) {
                this.cachedException = sSLException;
                this.cleanupSSLEngine();
                throw sSLException;
            }
            Object var5_3 = null;
            this.readNWDataInBuf.compact();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.readNWDataInBuf.compact();
            throw throwable;
        }
        return sSLEngineResult;
    }

    private void handleUnwrapResults(SSLEngineResult sSLEngineResult, ByteBuffer byteBuffer, MuxableSocket muxableSocket, boolean bl) throws IOException {
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            int n;
            if (bl && (n = this.readFromNetwork()) <= -1) {
                SocketLogger.logDebug((String)"read EOF on socket");
                this.cachedException = new IOException("Connection closed, EOF detected");
                if (!this.sslEngine.isInboundDone()) {
                    this.cleanupSSLEngine();
                }
                throw this.cachedException;
            }
        } else {
            this.handleResultsCommonly(sSLEngineResult, byteBuffer, muxableSocket, bl);
        }
    }

    private void cleanupSSLEngine() throws IOException {
        this.sslEngine.closeOutbound();
        this.writeToNetwork();
        this.writeNWDataOutBuf.clear();
        SSLEngineResult sSLEngineResult = null;
        while (!this.sslEngine.isOutboundDone()) {
            try {
                sSLEngineResult = this.sslEngine.wrap(ByteBuffer.allocate(0), this.writeNWDataOutBuf);
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                this.writeToNetwork();
            }
            catch (SSLException sSLException) {
                return;
            }
        }
        if (sSLEngineResult == null || sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.writeToNetwork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillAppBuf(ByteBuffer[] byteBufferArray) {
        int n = 0;
        ByteBuffer byteBuffer = this.getClearTextBuf();
        byteBuffer.flip();
        try {
            for (int i = 0; i < byteBufferArray.length; ++i) {
                if (byteBufferArray[i].remaining() == 0) continue;
                int n2 = byteBuffer.remaining();
                while (byteBuffer.remaining() > 0 && byteBufferArray[i].remaining() > 0) {
                    byteBufferArray[i].put(byteBuffer.get());
                }
                n += n2 - byteBuffer.remaining();
                if (byteBuffer.remaining() == 0) break;
            }
            Object var7_6 = null;
            byteBuffer.compact();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            byteBuffer.compact();
            throw throwable;
        }
        return n;
    }

    private SSLEngineResult wrapAndWrite(ByteBuffer byteBuffer, boolean bl) throws IOException {
        SSLEngineResult sSLEngineResult;
        try {
            sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.writeNWDataOutBuf);
        }
        catch (SSLException sSLException) {
            this.cachedException = sSLException;
            this.cleanupSSLEngine();
            throw sSLException;
        }
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new IOException("SSLException not enough data in the buffer: " + byteBuffer + " to encrypt!?! Results: " + sSLEngineResult);
        }
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && this.getAvailableBytes(this.writeNWDataOutBuf) == 0) {
            throw new IOException("SSLException, writeNWBuf: " + this.writeNWDataOutBuf + " is not large enough for SSLEngine.unwrapAndHandleResults, results: " + sSLEngineResult);
        }
        this.writeToNetwork();
        this.handleResultsCommonly(sSLEngineResult, null, this, bl);
        return sSLEngineResult;
    }

    private void handleResultsCommonly(SSLEngineResult sSLEngineResult, ByteBuffer byteBuffer, MuxableSocket muxableSocket, boolean bl) throws IOException {
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.cleanupSSLEngine();
        } else if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.isRehandshakeNeeded(sSLEngineResult)) {
            this.initialHSComplete = false;
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (!this.doHandshake(byteBuffer, muxableSocket, bl) && bl) {
                throw new IOException("Requested re-handshake failed: " + sSLEngineResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNetwork() throws IOException {
        this.writeNWDataOutBuf.flip();
        try {
            if (this.writeNWDataOutBuf.hasRemaining()) {
                this.out.write(this.writeNWDataOutBuf.array(), this.writeNWDataOutBuf.arrayOffset(), this.writeNWDataOutBuf.limit());
            }
            Object var2_1 = null;
            this.writeNWDataOutBuf.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeNWDataOutBuf.clear();
            throw throwable;
        }
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public long read(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsScatteredRead() {
        return false;
    }

    public String toString() {
        return super.toString() + " with delegate: " + this.delegate;
    }

    public static interface HandshakeListener {
        public void handshakeDone(SSLSession var1);
    }
}

