/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.socket.JSSEFilterImpl;
import weblogic.socket.WeblogicSSLSocket;

public class JSSESocket
extends WeblogicSSLSocket {
    private InputStream in;
    private OutputStream out;
    private JSSEFilterImpl filter;
    private SSLEngine sslEngine;

    public JSSESocket(Socket socket, JSSEFilterImpl jSSEFilterImpl) {
        super(socket);
        this.filter = jSSEFilterImpl;
        this.sslEngine = jSSEFilterImpl.getSSLEngine();
        if (this.sslEngine instanceof WeblogicSSLEngine) {
            ((WeblogicSSLEngine)this.sslEngine).setAssociatedSSLSocket(this);
        }
        this.in = new JSSEInputStream(jSSEFilterImpl);
        this.out = new JSSEOutputStream(jSSEFilterImpl);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public JSSEFilterImpl getFilter() {
        return this.filter;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.filter.addHandshakeCompletedListener(new HandshakeListenerImpl(handshakeCompletedListener));
    }

    public boolean getEnableSessionCreation() {
        return this.sslEngine.getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        return this.sslEngine.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.sslEngine.getEnabledProtocols();
    }

    public boolean getNeedClientAuth() {
        return this.sslEngine.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.sslEngine.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.sslEngine.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.sslEngine.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.sslEngine.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.sslEngine.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.filter.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sslEngine.setEnableSessionCreation(bl);
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.sslEngine.setEnabledCipherSuites(stringArray);
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.sslEngine.setEnabledProtocols(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.sslEngine.setNeedClientAuth(bl);
    }

    public void setUseClientMode(boolean bl) {
        this.sslEngine.setUseClientMode(bl);
    }

    public void setWantClientAuth(boolean bl) {
        this.sslEngine.setWantClientAuth(bl);
    }

    public void startHandshake() throws IOException {
        this.filter.doHandshake();
    }

    public class HandshakeListenerImpl
    implements JSSEFilterImpl.HandshakeListener {
        private HandshakeCompletedListener listener;

        public HandshakeListenerImpl(HandshakeCompletedListener handshakeCompletedListener) {
            this.listener = handshakeCompletedListener;
        }

        public void handshakeDone(SSLSession sSLSession) {
            HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(JSSESocket.this, sSLSession);
            this.listener.handshakeCompleted(handshakeCompletedEvent);
        }
    }

    private class JSSEOutputStream
    extends OutputStream {
        private JSSEFilterImpl filter;

        JSSEOutputStream(JSSEFilterImpl jSSEFilterImpl) {
            this.filter = jSSEFilterImpl;
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.filter.write(byArray, n, n2);
        }
    }

    private class JSSEInputStream
    extends InputStream {
        private JSSEFilterImpl filter;

        JSSEInputStream(JSSEFilterImpl jSSEFilterImpl) {
            this.filter = jSSEFilterImpl;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            return n == 1 ? byArray[0] : n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 == 0) {
                n3 = this.filter.read(byArray, n, n2);
            }
            return n3;
        }
    }
}

