/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.SSL.SSLEngineFactory;
import weblogic.security.SSL.WeblogicSSLEngine;
import weblogic.socket.JSSEFilterImpl;
import weblogic.socket.JSSESocket;
import weblogic.socket.SocketMuxer;

public class JSSESocketFactory
extends SSLSocketFactory {
    private static boolean isMuxerReady;
    private final SSLEngineFactory sslEngineFactory;

    public static JSSESocketFactory getSSLSocketFactory(SSLEngineFactory sSLEngineFactory) {
        return new JSSESocketFactory(sSLEngineFactory);
    }

    private JSSESocketFactory(SSLEngineFactory sSLEngineFactory) {
        this.sslEngineFactory = sSLEngineFactory;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        SSLEngine sSLEngine = this.getSSLEngine(socket);
        JSSEFilterImpl jSSEFilterImpl = new JSSEFilterImpl(socket, sSLEngine, true);
        JSSESocket jSSESocket = new JSSESocket(socket, jSSEFilterImpl);
        jSSESocket.setAutoClose(bl);
        return jSSESocket;
    }

    public String[] getDefaultCipherSuites() {
        return this.sslEngineFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.sslEngineFactory.getSupportedCipherSuites();
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.getConnectedSocket(InetAddress.getByName(string), n, 0);
        return this.createSocket(socket, string, n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.getConnectedSocket(inetAddress, n, 0);
        return this.createSocket(socket, inetAddress.getHostAddress(), n, true);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.getConnectedSocket(InetAddress.getByName(string), n, inetAddress, n2, 0);
        return this.createSocket(socket, string, n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.getConnectedSocket(inetAddress, n, inetAddress2, n2, 0);
        return this.createSocket(socket, inetAddress.getHostAddress(), n, true);
    }

    private Socket getConnectedSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket = null;
        if (!isMuxerReady) {
            isMuxerReady = SocketMuxer.isAvailable();
        }
        if (isMuxerReady) {
            socket = SocketMuxer.getMuxer().newSSLClientSocket(inetAddress, n, n2);
            if (socket == null) {
                socket = SocketMuxer.getMuxer().newSocket(inetAddress, n, n2);
            }
        } else {
            socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.connect(new InetSocketAddress(inetAddress, n), n2);
        }
        return socket;
    }

    private Socket getConnectedSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        Socket socket = null;
        if (!isMuxerReady) {
            isMuxerReady = SocketMuxer.isAvailable();
        }
        if (isMuxerReady) {
            socket = SocketMuxer.getMuxer().newSSLClientSocket(inetAddress, n, inetAddress2, n2, n3);
            if (socket == null) {
                socket = SocketMuxer.getMuxer().newSocket(inetAddress, n, inetAddress2, n2, n3);
            }
        } else {
            socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.bind(new InetSocketAddress(inetAddress2, n2));
            socket.connect(new InetSocketAddress(inetAddress, n), n3);
        }
        return socket;
    }

    private SSLEngine getSSLEngine(Socket socket) throws IOException {
        try {
            WeblogicSSLEngine weblogicSSLEngine = this.sslEngineFactory.createSSLEngine(socket.getInetAddress().getHostAddress(), socket.getPort());
            weblogicSSLEngine.setUseClientMode(true);
            return weblogicSSLEngine;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

