/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.rjvm.HeartbeatMonitor;
import weblogic.socket.ClientSSLFilterImpl;
import weblogic.socket.MuxableSocket;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.socket.SocketReaderRequest;
import weblogic.socket.internal.SocketEnvironment;
import weblogic.socket.utils.DynaQueue;
import weblogic.socket.utils.QueueFullException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.concurrent.Latch;
import weblogic.work.WorkManagerFactory;

final class JavaSocketMuxer
extends ServerSocketMuxer {
    private static final boolean ASSERT = false;
    private static final int QUEUE_BLOCK_SIZE = 25;
    private static final int SOCKET_WAIT_TIMEOUT = 2000;
    private static final String CLIENT_SOCKET_READERS_QUEUE_NAME = "weblogic.JavaSocketReaders";
    private final Latch warningLock = new Latch();
    private final DynaQueue sockQueue = new DynaQueue("SockMuxQ", 25);
    private int numSocketReaders = 0;
    private int maxSocketReaders = -1;
    private int curSoTimeoutMillis = config.getSocketReaderTimeoutMaxMillis();
    private ExecuteThreadManager socketReaderQueue = null;
    private ExecuteThreadManager clientExecuteQueue;
    private int numClientSocketReaders = 0;
    private static final int MIN_CLIENT_EXECUTE_THREAD_COUNT = 0;
    private static final int MAX_CLIENT_EXECUTE_THREAD_COUNT = 15;
    private static final boolean jsse = SocketEnvironment.getSocketEnvironment().isJSSE();
    private static final int MAX_SLEEP_SUM = 1000;
    private static final int SLEEP_MULTIPLE = 100;
    private int prevNum = 0;
    private int curNum = 1;

    protected JavaSocketMuxer() throws IOException {
        this.init();
    }

    private void init() {
        ExecuteThreadManager executeThreadManager = Kernel.getExecuteThreadManager("weblogic.socket.Muxer");
        if (executeThreadManager != null && executeThreadManager.getName().equalsIgnoreCase("weblogic.socket.Muxer")) {
            this.socketReaderQueue = executeThreadManager;
            this.maxSocketReaders = executeThreadManager.getExecuteThreadCount();
            SocketLogger.logAllocSocketReaders((int)this.maxSocketReaders);
            for (int i = 0; i < this.maxSocketReaders; ++i) {
                Kernel.execute((ExecuteRequest)new SocketReaderRequest(), "weblogic.socket.Muxer");
            }
        }
    }

    private int getMaxSocketReaders() {
        if (this.maxSocketReaders == -1) {
            int n = config.getThreadPoolPercentSocketReaders();
            int n2 = n * config.getThreadPoolSize() / 100;
            this.maxSocketReaders = Math.max(2, n2);
        }
        return this.maxSocketReaders;
    }

    public void read(MuxableSocket muxableSocket) {
        if (!this.initiateIO(muxableSocket.getSocketInfo())) {
            return;
        }
        this.internalRead(muxableSocket, false);
    }

    private void internalRead(MuxableSocket muxableSocket, Boolean bl) {
        try {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("internalRead for: " + muxableSocket.getSocketInfo()));
            }
            if (muxableSocket instanceof ClientSSLFilterImpl && jsse) {
                if (bl.booleanValue()) {
                    int n = this.calculateSleepTime() * 100;
                    try {
                        Thread.sleep(0L, n);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.resetSleepTime();
                }
            }
            this.sockQueue.put(muxableSocket);
        }
        catch (QueueFullException queueFullException) {
            SocketLogger.logSocketQueueFull((Exception)queueFullException);
            this.closeSocket(muxableSocket);
        }
    }

    private int calculateSleepTime() {
        if (this.curNum >= 1000) {
            return 1000;
        }
        this.curNum += this.prevNum;
        this.prevNum = this.curNum - this.prevNum;
        if (this.curNum >= 1000) {
            return 1000;
        }
        return this.curNum;
    }

    private void resetSleepTime() {
        this.prevNum = 0;
        this.curNum = 1;
    }

    protected void handleReadTimeout(MuxableSocket muxableSocket) {
        this.internalRead(muxableSocket, true);
    }

    protected void readCompleted(MuxableSocket muxableSocket) {
        this.completeIO(muxableSocket, muxableSocket.getSocketInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MuxableSocket muxableSocket) throws IOException {
        muxableSocket.setSocketInfo(new SocketInfo(muxableSocket));
        ConcurrentHashMap concurrentHashMap = this.sockets;
        synchronized (concurrentHashMap) {
            super.register(muxableSocket);
            if (this.socketReaderQueue != null) {
                return;
            }
            int n = this.getNumSockets();
            if (n > this.numSocketReaders + this.numClientSocketReaders) {
                if (this.numSocketReaders < this.getMaxSocketReaders()) {
                    WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new SocketReaderRequest()));
                    ++this.numSocketReaders;
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                        SocketLogger.logDebug((String)("Starting socket reader: '" + this.numSocketReaders + "', " + "sockets: '" + n + "'"));
                    }
                } else if (!Kernel.isServer() && this.createClientThread()) {
                    Kernel.execute((ExecuteRequest)new SocketReaderRequest(), CLIENT_SOCKET_READERS_QUEUE_NAME);
                } else if (this.warningLock.tryLock()) {
                    SocketLogger.logSocketConfig((int)n, (int)this.getMaxSocketReaders());
                }
            }
        }
    }

    private boolean createClientThread() {
        if (this.numClientSocketReaders == 15) {
            return false;
        }
        if (this.clientExecuteQueue == null) {
            this.createClientExecuteQueue();
        }
        if (++this.numClientSocketReaders > this.clientExecuteQueue.getExecuteThreadCount()) {
            this.clientExecuteQueue.setThreadCount(this.numClientSocketReaders);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug((String)("Created thread in extra client execute queue, total number of extra client threads: " + this.numClientSocketReaders));
            }
        }
        return true;
    }

    private void createClientExecuteQueue() {
        Kernel.addExecuteQueue(CLIENT_SOCKET_READERS_QUEUE_NAME, 0, 0, 15);
        this.clientExecuteQueue = Kernel.getExecuteThreadManager(CLIENT_SOCKET_READERS_QUEUE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBreakProcessSockets(boolean bl) {
        if (this.socketReaderQueue != null) {
            return false;
        }
        ConcurrentHashMap concurrentHashMap = this.sockets;
        synchronized (concurrentHashMap) {
            if (this.numSocketReaders + this.numClientSocketReaders > this.getNumSockets()) {
                if (bl) {
                    --this.numClientSocketReaders;
                } else {
                    --this.numSocketReaders;
                }
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebug((String)("Decrementing socket reader: " + this.numSocketReaders + ", client socket reader: " + this.numClientSocketReaders + ", sockets: " + this.getNumSockets()));
                }
                return true;
            }
        }
        return false;
    }

    private boolean isClientExecuteThread() {
        return !Kernel.isServer() && ((ExecuteThread)((Object)Thread.currentThread())).getExecuteThreadManager().getName().equalsIgnoreCase(CLIENT_SOCKET_READERS_QUEUE_NAME);
    }

    protected void processSockets() {
        boolean bl = this.isClientExecuteThread();
        while (!this.shouldBreakProcessSockets(bl)) {
            MuxableSocket muxableSocket = null;
            SocketInfo socketInfo = null;
            try {
                muxableSocket = (MuxableSocket)this.sockQueue.get();
                while (muxableSocket == null) {
                    if (this.shouldBreakProcessSockets(bl)) {
                        return;
                    }
                    muxableSocket = (MuxableSocket)this.sockQueue.getW(2000);
                }
                socketInfo = muxableSocket.getSocketInfo();
                muxableSocket.setSoTimeout(this.getSoTimeout());
                this.readReadySocket(muxableSocket, socketInfo, this.getSoTimeout());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (Kernel.isServer()) {
                    if (!Kernel.isIntentionalShutdown()) {
                        SocketLogger.logThreadDeath((ThreadDeath)threadDeath);
                    }
                    throw threadDeath;
                }
                if (muxableSocket == null || muxableSocket.getSocketInfo().markedClose) continue;
                this.internalRead(muxableSocket, false);
                continue;
            }
            catch (Throwable throwable) {
                this.deliverHasException(socketInfo.getMuxableSocket(), throwable);
                continue;
            }
            break;
        }
        return;
    }

    private int getSoTimeout() {
        return this.curSoTimeoutMillis;
    }

    private void updateSoTimeout() {
        int n = this.getNumSockets();
        int n2 = this.numSocketReaders;
        int n3 = config.getSocketReaderTimeoutMinMillis();
        int n4 = config.getSocketReaderTimeoutMaxMillis();
        if (n2 == 0 || n == 0) {
            this.curSoTimeoutMillis = n4;
        } else {
            int n5 = HeartbeatMonitor.periodLengthMillis();
            this.curSoTimeoutMillis = n5 * n2 / n;
            this.curSoTimeoutMillis = Math.min(this.curSoTimeoutMillis, n4);
            this.curSoTimeoutMillis = Math.max(this.curSoTimeoutMillis, n3);
        }
    }

    protected TimerListener createTimeoutTrigger() {
        return new JavaTimerListenerImpl();
    }

    protected class JavaTimerListenerImpl
    extends SocketMuxer.TimerListenerImpl {
        protected JavaTimerListenerImpl() {
        }

        public void timerExpired(Timer timer) {
            super.timerExpired(timer);
            JavaSocketMuxer.this.updateSoTimeout();
        }
    }
}

