/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLSocket;
import weblogic.logging.Loggable;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.security.SecurityService;
import weblogic.security.net.ConnectionEvent;
import weblogic.security.net.FilterException;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.server.channels.ServerConnectionRuntimeImpl;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.JSSEFilterImpl;
import weblogic.socket.JSSESocket;
import weblogic.socket.Login;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.socket.utils.JSSEUtils;

public final class MuxableSocketDiscriminator
extends AbstractMuxableSocket {
    private static final long serialVersionUID = -7142489085349898142L;
    private static final boolean DEBUG = false;
    private final ProtocolHandler[] handlers;
    private final ServerChannel[] channels;
    private int claimedIndex = -1;
    private int timeoutMillis;

    public MuxableSocketDiscriminator(Socket socket, ProtocolHandler[] protocolHandlerArray, ServerChannel[] serverChannelArray) throws IOException {
        super(serverChannelArray[0]);
        this.connect(socket);
        this.timeoutMillis = this.getSocket().getSoTimeout();
        this.setSoTimeout(this.timeoutMillis);
        this.handlers = protocolHandlerArray;
        this.channels = serverChannelArray;
    }

    public String toString() {
        return super.toString() + " - number of bytes read: '" + this.availBytes + "'";
    }

    private boolean isSecure() {
        return this.getSocket() instanceof SSLSocket;
    }

    public boolean isMessageComplete() {
        int n = 0;
        for (int i = 0; i < this.handlers.length; ++i) {
            ProtocolHandler protocolHandler = this.handlers[i];
            if (protocolHandler.claimSocket(this.head)) {
                this.claimedIndex = i;
                break;
            }
            n = Math.max(n, protocolHandler.getHeaderLength());
        }
        if (this.availBytes < n) {
            return false;
        }
        if (this.claimedIndex < 0) {
            SocketLogger.logConnectionRejected((String)this.channels[0].getChannelName());
            SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), new ProtocolException("Incoming socket: '" + this.getSocket() + "' has unhandled protocol prefix"));
            return false;
        }
        return true;
    }

    public void dispatch() {
        String string;
        if (this.claimedIndex < 0) {
            return;
        }
        try {
            string = ProtocolManager.getRealProtocol((Protocol)this.channels[this.claimedIndex].getProtocol()).getProtocolName();
            this.maybeFilter(string);
        }
        catch (FilterException filterException) {
            this.onFilterException(filterException);
            return;
        }
        try {
            Object object;
            string = this.handlers[this.claimedIndex].createSocket(this.head, this.getSocket(), this.channels[this.claimedIndex]);
            if (SecurityService.getConnectionLoggerEnabled()) {
                SocketLogger.logInfoAcceptConnection((boolean)SecurityService.getConnectionFilterEnabled(), (String)this.getSocket().getInetAddress().toString(), (int)this.getSocket().getPort(), (String)this.getSocket().getLocalAddress().toString(), (int)this.getSocket().getLocalPort(), (String)this.handlers[this.claimedIndex].getProtocol().getProtocolName());
            }
            if (this.isSecure()) {
                SSLSocket sSLSocket = (SSLSocket)this.getSocket();
                JSSESocket jSSESocket = JSSEUtils.getJSSESocket(sSLSocket);
                if (jSSESocket != null) {
                    JSSEFilterImpl jSSEFilterImpl = (JSSEFilterImpl)this.getSocketFilter();
                    string.setSocketFilter((MuxableSocket)jSSEFilterImpl);
                    jSSEFilterImpl.setDelegate((MuxableSocket)string);
                    object = jSSEFilterImpl;
                } else {
                    SSLIOContext sSLIOContext = SSLIOContextTable.findContext(sSLSocket);
                    if (sSLIOContext == null) {
                        throw new IOException("SSL transport layer closed the socket!");
                    }
                    SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
                    string.setSocketFilter((MuxableSocket)sSLFilter);
                    sSLFilter.setDelegate((MuxableSocket)string);
                    sSLFilter.activateNoRegister();
                    object = sSLFilter;
                }
            } else {
                SocketMuxer.getMuxer().reRegister(this.getSocketFilter(), (MuxableSocket)string);
                object = string;
            }
            this.setSocketFilter((MuxableSocket)object);
            if (object.isMessageComplete()) {
                object.dispatch();
            } else {
                SocketMuxer.getMuxer().read((MuxableSocket)object);
            }
        }
        catch (IOException iOException) {
            SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), iOException);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            SocketLogger.logThrowable((Throwable)throwable);
            IOException iOException = new IOException("Exception in protocol discrimination");
            iOException.initCause(throwable);
            SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), iOException);
        }
    }

    public int getIdleTimeoutMillis() {
        return this.timeoutMillis;
    }

    public int getCompleteMessageTimeoutMillis() {
        return this.timeoutMillis;
    }

    public boolean timeout() {
        SocketLogger.logSocketIdleTimeout((long)(this.timeoutMillis / 1000), (String)this.socket.getInetAddress().getHostAddress(), (int)this.socket.getPort());
        return super.timeout();
    }

    private void maybeFilter(String string) throws FilterException {
        if (SecurityService.getConnectionFilterEnabled()) {
            if (SecurityService.getCompatibilityConnectionFiltersEnabled()) {
                if ((string = string.toUpperCase(Locale.ENGLISH)).equals("IIOP")) {
                    string = "GIOP";
                } else if (string.equals("IIOPS")) {
                    string = "GIOPS";
                } else if (string.equals("COM")) {
                    string = "DCOM";
                }
            }
            ConnectionEvent connectionEvent = new ConnectionEvent(this.getSocket(), string);
            SecurityService.getConnectionFilter().accept(connectionEvent);
        }
    }

    private void onFilterException(FilterException filterException) {
        Loggable loggable;
        String string = filterException.getMessage();
        if (SecurityService.getConnectionLoggerEnabled()) {
            loggable = SocketLogger.logConnectionRejectedFilterExLoggable((String)this.socketInfo(), (Exception)filterException);
            loggable.log();
        }
        loggable = SocketLogger.logConnectionRejectedFilterExLoggable((String)"Socket", (Exception)filterException);
        string = loggable.getMessage();
        boolean bl = false;
        byte by = this.channels[this.claimedIndex].getProtocol().toByte();
        if (by == 1 || by == 3) {
            bl = true;
        }
        Login.rejectConnection((Socket)this.getSocket(), (int)1, (String)string, (boolean)bl);
        SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), filterException);
    }

    private String socketInfo() {
        Socket socket = this.getSocket();
        if (socket == null) {
            return "";
        }
        InetAddress inetAddress = socket.getInetAddress();
        return "Socket[" + (inetAddress != null ? "addr=" + inetAddress.getHostAddress() : "") + ",port=" + socket.getPort() + ",localport=" + socket.getLocalPort() + "]";
    }

    protected void registerForRuntimeMonitoring(ServerChannel serverChannel, ServerConnectionRuntimeImpl serverConnectionRuntimeImpl) {
    }

    protected static void p(String string) {
        System.err.println("<MuxableSocketDiscriminator:" + System.currentTimeMillis() + "> " + string);
    }
}

