/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.kernel.Kernel;
import weblogic.security.SSL.WLSSSLNioSocket;
import weblogic.server.channels.ServerThrottle;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.NIOSocketInfo;
import weblogic.socket.NetworkInterfaceInfo;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.WeblogicServerSocket;
import weblogic.socket.WeblogicSocket;
import weblogic.socket.WeblogicSocketImpl;
import weblogic.socket.utils.SDPSocketUtils;
import weblogic.utils.io.Chunk;

final class NIOSocketMuxer
extends ServerSocketMuxer {
    private static final int MULTIPLIER = 1540483477;
    private final Selector[] selectors = new Selector[rdrThreads];
    private final ArrayList<NIOSocketInfo>[] registerLists = new ArrayList[rdrThreads];
    private int nextId;

    public NIOSocketMuxer() throws IOException {
        int n = rdrThreads;
        while (--n >= 0) {
            this.selectors[n] = SelectorProvider.provider().openSelector();
            this.registerLists[n] = new ArrayList(1024);
        }
        this.startSocketReaderThreads("weblogic.socket.Muxer");
    }

    private static int selectorIndex(SocketChannel socketChannel) {
        int n;
        int n2 = n = socketChannel.hashCode();
        n2 *= 1540483477;
        n2 ^= n2 >> 24;
        n2 *= 1540483477;
        n2 ^= n2 >> 13;
        n2 *= 1540483477;
        n2 ^= n2 >> 15;
        int n3 = n2 % rdrThreads;
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug((String)("NIOSocketMuxer | hash start = " + n + " | hash result = " + n2 + " | index = " + n3));
        }
        return n3;
    }

    public boolean isAsyncMuxer() {
        return true;
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        SocketChannel socketChannel = muxableSocket.getSocket().getChannel();
        int n = 0;
        if (socketChannel != null && rdrThreads > 1) {
            n = NIOSocketMuxer.selectorIndex(socketChannel);
        }
        muxableSocket.setSocketInfo((SocketInfo)new NIOSocketInfo(muxableSocket, n));
        super.register(muxableSocket);
    }

    public void read(MuxableSocket muxableSocket) {
        this.internalRead(muxableSocket, (NIOSocketInfo)muxableSocket.getSocketInfo());
    }

    protected void cancelIo(MuxableSocket muxableSocket) {
        super.cancelIo(muxableSocket);
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("explicitly calling cleanupSocket for ms=" + muxableSocket));
        }
        this.cleanupSocket(muxableSocket, muxableSocket.getSocketInfo());
    }

    protected void closeSocket(Socket socket) {
        SocketChannel socketChannel;
        block10: {
            if (!socket.isOutputShutdown()) {
                try {
                    socket.shutdownOutput();
                }
                catch (Exception exception) {
                    if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block10;
                    SocketLogger.logDebugException((String)("shutdownOutput error for socket=" + socket), (Exception)exception);
                }
            }
        }
        if ((socketChannel = socket.getChannel()) != null) {
            block11: {
                if (socketChannel.isOpen()) {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                        SocketLogger.logDebug((String)("close socket=" + socket));
                    }
                    try {
                        socketChannel.close();
                    }
                    catch (Exception exception) {
                        if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block11;
                        SocketLogger.logDebugException((String)("close channel error for socket=" + socket), (Exception)exception);
                    }
                }
            }
            int n = NIOSocketMuxer.selectorIndex(socketChannel);
            this.selectors[n].wakeup();
        } else {
            for (int i = 0; i < this.selectors.length; ++i) {
                this.selectors[i].wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRead(MuxableSocket muxableSocket, NIOSocketInfo nIOSocketInfo) {
        if (!this.initiateIO(nIOSocketInfo)) {
            return;
        }
        try {
            SelectionKey selectionKey;
            SocketChannel socketChannel;
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("read: sockInfo=" + (Object)((Object)nIOSocketInfo)));
            }
            if ((socketChannel = nIOSocketInfo.getSocketChannel()) == null) {
                muxableSocket.hasException((Throwable)new IOException("SocketChannel not available"));
                return;
            }
            int n = nIOSocketInfo.getSelectorIndex();
            if (socketChannel.isBlocking()) {
                socketChannel.configureBlocking(false);
            }
            if ((selectionKey = nIOSocketInfo.getSelectionKey()) == null) {
                ArrayList<NIOSocketInfo> arrayList = this.registerLists[n];
                synchronized (arrayList) {
                    this.registerLists[n].add(nIOSocketInfo);
                }
            } else {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug((String)("set interest ops for: sockInfo=" + (Object)((Object)nIOSocketInfo)));
                }
                selectionKey.interestOps(1);
            }
            this.selectors[n].wakeup();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebugException((String)("register for Selection failed for ms=" + muxableSocket.getSocketInfo() + " with: "), (Exception)((Exception)throwable));
            }
            this.deliverHasException(muxableSocket, throwable);
        }
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        SocketChannel socketChannel = socket.getChannel();
        NetworkInterfaceInfo networkInterfaceInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(socket.getLocalAddress());
        return new NIOInputStream(socketChannel, networkInterfaceInfo);
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        SocketChannel socketChannel = socket.getChannel();
        NetworkInterfaceInfo networkInterfaceInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(socket.getLocalAddress());
        return new NIOOutputStream(socketChannel, networkInterfaceInfo);
    }

    public Socket newSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        NIOSocketMuxer.initSocket(socket);
        socket.connect(new InetSocketAddress(inetAddress, n), n2);
        return this.createWeblogicSocket(socket);
    }

    public Socket newSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        NIOSocketMuxer.initSocket(socket);
        socket.bind(new InetSocketAddress(inetAddress2, n2));
        socket.connect(new InetSocketAddress(inetAddress, n), n3);
        return this.createWeblogicSocket(socket);
    }

    public Socket newSDPSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        Socket socket = SDPSocketUtils.createSDPSocket();
        socket = this.initSocket(socket, inetAddress, n, inetAddress2, n2, n3);
        return this.createWeblogicSocket(socket);
    }

    public WeblogicSocket newWeblogicSocket(Socket socket) throws IOException {
        NIOSocketMuxer.initSocket(socket);
        if (ServerThrottle.getServerThrottle().isEnabled()) {
            return this.createWeblogicSocketImpl(socket);
        }
        return this.createWeblogicSocket(socket);
    }

    private WeblogicSocket createWeblogicSocketImpl(Socket socket) {
        final NetworkInterfaceInfo networkInterfaceInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(socket.getLocalAddress());
        return new WeblogicSocketImpl(socket){

            public InputStream getInputStream() throws IOException {
                return new NIOInputStream(this.getSocket().getChannel(), networkInterfaceInfo);
            }

            public OutputStream getOutputStream() throws IOException {
                return new NIOOutputStream(this.getSocket().getChannel(), networkInterfaceInfo);
            }
        };
    }

    private WeblogicSocket createWeblogicSocket(Socket socket) {
        final NetworkInterfaceInfo networkInterfaceInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(socket.getLocalAddress());
        return new WeblogicSocket(socket){

            public InputStream getInputStream() throws IOException {
                return new NIOInputStream(this.getSocket().getChannel(), networkInterfaceInfo);
            }

            public OutputStream getOutputStream() throws IOException {
                return new NIOOutputStream(this.getSocket().getChannel(), networkInterfaceInfo);
            }
        };
    }

    public ServerSocket newServerSocket(InetAddress inetAddress, int n, int n2, boolean bl) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        if (inetAddress == null) {
            serverSocketChannel.socket().bind(new InetSocketAddress(n), n2);
        } else {
            serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, n), n2);
        }
        return new WeblogicServerSocket(serverSocketChannel.socket(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSockets() {
        int n = 0;
        int n2 = 0;
        Object object = this;
        synchronized (object) {
            n = this.nextId++;
        }
        if (n > rdrThreads) {
            throw new IllegalStateException("index > THREAD_COUNT | " + n + " > " + rdrThreads);
        }
        while (true) {
            try {
                while (true) {
                    try {
                        n2 = this.selectors[n].select();
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        continue;
                    }
                    if (this.registerLists[n].size() > 0) {
                        this.registerNewSockets(n);
                    }
                    if (n2 != 0) break;
                }
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug((String)("select returns " + n2 + " keys"));
                }
                object = this.selectors[n].selectedKeys();
                Iterator iterator = object.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = (SelectionKey)iterator.next();
                    iterator.remove();
                    NIOSocketInfo nIOSocketInfo = (NIOSocketInfo)((Object)selectionKey.attachment());
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                        SocketLogger.logDebug((String)("clear interest ops for: sockInfo=" + (Object)((Object)nIOSocketInfo)));
                    }
                    try {
                        selectionKey.interestOps(selectionKey.interestOps() & ~selectionKey.readyOps());
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                    MuxableSocket muxableSocket = nIOSocketInfo.getMuxableSocket();
                    if (!this.completeIO(muxableSocket, nIOSocketInfo)) continue;
                    try {
                        this.readReadySocket(muxableSocket, nIOSocketInfo, 0L);
                    }
                    catch (Throwable throwable) {
                        this.deliverHasException(muxableSocket, throwable);
                    }
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                SocketLogger.logUncaughtThrowable((Throwable)throwable);
            }
            try {
                if (DELAYPOLLWAKEUP <= 0L) continue;
                Thread.sleep(DELAYPOLLWAKEUP);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewSockets(int n) throws ClosedChannelException {
        NIOSocketInfo[] nIOSocketInfoArray;
        ArrayList<NIOSocketInfo> arrayList = this.registerLists[n];
        synchronized (arrayList) {
            int n2 = this.registerLists[n].size();
            if (n2 == 0) {
                return;
            }
            nIOSocketInfoArray = this.registerLists[n].toArray(new NIOSocketInfo[n2]);
            this.registerLists[n].clear();
        }
        int n3 = nIOSocketInfoArray.length - 1;
        while (n3 >= 0) {
            Object object;
            NIOSocketInfo nIOSocketInfo;
            SelectionKey selectionKey;
            if ((selectionKey = (nIOSocketInfo = nIOSocketInfoArray[n3--]).getSelectionKey()) != null) continue;
            SocketChannel socketChannel = nIOSocketInfo.getSocketChannel();
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("SocketChannel.register: sockInfo=" + (Object)((Object)nIOSocketInfo)));
            }
            try {
                selectionKey = socketChannel.register(this.selectors[n], 1, (Object)nIOSocketInfo);
                nIOSocketInfo.setSelectionKey(selectionKey);
            }
            catch (CancelledKeyException cancelledKeyException) {
                object = this.registerLists[n];
                synchronized (object) {
                    this.registerLists[n].add(nIOSocketInfo);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                object = nIOSocketInfo.getMuxableSocket();
                this.deliverHasException((MuxableSocket)object, closedChannelException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readFromSocket(MuxableSocket muxableSocket) throws IOException {
        InputStream inputStream = muxableSocket.getSocketInputStream();
        Socket socket = muxableSocket.getSocket();
        synchronized (socket) {
            if (muxableSocket.supportsScatteredRead() && inputStream instanceof NIOConnection && ((NIOConnection)inputStream).supportsScatteredReads()) {
                int n = (int)muxableSocket.read((NIOConnection)inputStream);
                return n;
            }
            return super.readFromSocket(muxableSocket);
        }
    }

    protected void internalWrite(AsyncOutputStream asyncOutputStream) {
        OutputStream outputStream = asyncOutputStream.getOutputStream();
        Chunk chunk = asyncOutputStream.getOutputBuffer();
        if (chunk != null && chunk.next != null && asyncOutputStream.supportsGatheringWrite() && outputStream instanceof NIOConnection && ((NIOConnection)outputStream).supportsGatheredWrites()) {
            try {
                asyncOutputStream.write((NIOConnection)outputStream);
            }
            catch (IOException iOException) {
                asyncOutputStream.handleException(iOException);
                return;
            }
        } else {
            super.internalWrite(asyncOutputStream);
        }
    }

    static {
        NIOSocketMuxer.initThreadCount(3, "weblogic.socket.Muxer", "");
    }

    private class NIOOutputStream
    extends OutputStream
    implements GatheringByteChannel,
    NIOConnection {
        private static final int MAX_WRITE_RETRY = 10;
        private static final int SLEEP_BEFORE_RETRY = 2;
        private final GatheringByteChannel wc;
        private ByteBuffer lastByteBuffer;
        private byte[] lastByteArray;
        private NetworkInterfaceInfo nwInfo;

        private NIOOutputStream(SocketChannel socketChannel, NetworkInterfaceInfo networkInterfaceInfo) {
            Socket socket = socketChannel.socket();
            this.nwInfo = networkInterfaceInfo;
            if (socket instanceof WLSSSLNioSocket) {
                WritableByteChannel writableByteChannel = ((WLSSSLNioSocket)((Object)socket)).getWritableByteChannel();
                this.wc = writableByteChannel instanceof GatheringByteChannel ? (GatheringByteChannel)writableByteChannel : this.getGatheringByteChannel(writableByteChannel);
                SocketLogger.logDebug((String)("NIOOutputStream constructed with writableByteChannel: " + this.wc));
            } else {
                this.wc = socketChannel;
            }
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)"NIOOutputStream created");
            }
        }

        private GatheringByteChannel getGatheringByteChannel(final WritableByteChannel writableByteChannel) {
            return new GatheringByteChannel(){

                public boolean isOpen() {
                    return writableByteChannel.isOpen();
                }

                public void close() throws IOException {
                    writableByteChannel.close();
                }

                public int write(ByteBuffer byteBuffer) throws IOException {
                    return writableByteChannel.write(byteBuffer);
                }

                public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
                    long l = 0L;
                    int n3 = n + n2;
                    if (n3 > byteBufferArray.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    int n4 = n;
                    while (n4 < n3) {
                        l += (long)writableByteChannel.write(byteBufferArray[n4]);
                        if (byteBufferArray[n4].hasRemaining()) continue;
                        ++n4;
                    }
                    return l;
                }

                public long write(ByteBuffer[] byteBufferArray) throws IOException {
                    return this.write(byteBufferArray, 0, byteBufferArray.length);
                }
            };
        }

        private ByteBuffer getByteBuffer(byte[] byArray, int n, int n2) {
            if (byArray != this.lastByteArray) {
                this.lastByteArray = byArray;
                this.lastByteBuffer = ByteBuffer.wrap(byArray);
            }
            return (ByteBuffer)this.lastByteBuffer.position(n).limit(n + n2);
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            ByteBuffer byteBuffer = this.getByteBuffer(byArray, n, n2);
            while (byteBuffer.hasRemaining()) {
                n3 += this.wc.write(byteBuffer);
            }
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug((String)("NIOOutputStream.write: expected to write " + n2 + " bytes, actually write " + n3 + " bytes"));
            }
        }

        public long write(ByteBuffer[] byteBufferArray) throws IOException {
            return this.write(byteBufferArray, 0, byteBufferArray.length);
        }

        public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            long l = 0L;
            int n3 = n + n2;
            int n4 = n;
            int n5 = 0;
            while (n4 < n3) {
                long l2 = this.wc.write(byteBufferArray, n4, n2 - n4);
                n5 = this.backOffIfNeeded(l2, n5);
                l += l2;
                while (n4 < n3 && !byteBufferArray[n4].hasRemaining()) {
                    ++n4;
                }
            }
            return l;
        }

        private int backOffIfNeeded(long l, int n) {
            if (l > 0L) {
                return 0;
            }
            if (n == 10) {
                try {
                    n = 0;
                    Thread.sleep(2L);
                }
                catch (Exception exception) {}
            } else {
                ++n;
            }
            return n;
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.wc.write(byteBuffer);
        }

        public boolean isOpen() {
            return this.wc.isOpen();
        }

        public InetAddress getLocalInetAddress() {
            return this.nwInfo.getLocalInetAddress();
        }

        public int getMTU() {
            return this.nwInfo.getMTU();
        }

        public int getOptimalNumberOfBuffers() {
            return this.nwInfo.getOptimalNumberOfBuffers();
        }

        public boolean supportsGatheredWrites() {
            return this.nwInfo.supportsGatheredWrites();
        }

        public GatheringByteChannel getGatheringByteChannel() {
            return this;
        }

        public boolean supportsScatteredReads() {
            return false;
        }

        public ScatteringByteChannel getScatteringByteChannel() {
            throw new UnsupportedOperationException();
        }
    }

    private class NIOInputStream
    extends InputStream
    implements ScatteringByteChannel,
    NIOConnection {
        private final SocketChannel sc;
        private ByteBuffer lastByteBuffer;
        private byte[] lastByteArray;
        private NetworkInterfaceInfo nwInfo;
        private int index;

        private NIOInputStream(SocketChannel socketChannel, NetworkInterfaceInfo networkInterfaceInfo) {
            this.sc = socketChannel;
            this.nwInfo = networkInterfaceInfo;
            this.index = NIOSocketMuxer.selectorIndex(socketChannel);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)"NIOInputStream created");
            }
        }

        private ByteBuffer getByteBuffer(byte[] byArray, int n, int n2) {
            if (byArray != this.lastByteArray) {
                this.lastByteArray = byArray;
                this.lastByteBuffer = ByteBuffer.wrap(byArray);
            }
            return (ByteBuffer)this.lastByteBuffer.position(n).limit(n + n2);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            return n == 1 ? byArray[0] : n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = this.getByteBuffer(byArray, n, n2);
            int n3 = this.sc.read(byteBuffer);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("NIOInputStream.read: expected to read " + n2 + " bytes, actually read " + n3 + " bytes"));
            }
            if (n3 == 0) {
                this.configureBlockingChannel();
                n3 = this.sc.read(byteBuffer);
            }
            return n3;
        }

        public long read(ByteBuffer[] byteBufferArray) throws IOException {
            return this.read(byteBufferArray, 0, byteBufferArray.length);
        }

        public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            long l = this.sc.read(byteBufferArray, n, n2);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("NIOInputStream.read: " + l + " bytes"));
            }
            if (l == 0L) {
                this.configureBlockingChannel();
                l = this.sc.read(byteBufferArray, n, n2);
            }
            return l;
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
            return (int)this.read(byteBufferArray, 0, 1);
        }

        public boolean isOpen() {
            return this.sc.isOpen();
        }

        private void configureBlockingChannel() throws IOException {
            SelectionKey selectionKey = this.sc.keyFor(NIOSocketMuxer.this.selectors[this.index]);
            if (selectionKey != null) {
                NIOSocketInfo nIOSocketInfo = (NIOSocketInfo)((Object)selectionKey.attachment());
                selectionKey.cancel();
                nIOSocketInfo.setSelectionKey(null);
            }
            this.sc.configureBlocking(true);
        }

        public InetAddress getLocalInetAddress() {
            return this.nwInfo.getLocalInetAddress();
        }

        public int getMTU() {
            return this.nwInfo.getMTU();
        }

        public int getOptimalNumberOfBuffers() {
            return this.nwInfo.getOptimalNumberOfBuffers();
        }

        public boolean supportsScatteredReads() {
            return this.nwInfo.supportsScatteredReads();
        }

        public ScatteringByteChannel getScatteringByteChannel() {
            return this;
        }

        public boolean supportsGatheredWrites() {
            return false;
        }

        public GatheringByteChannel getGatheringByteChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

