/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import weblogic.kernel.Kernel;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NTSocketInfo;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.utils.AssertionError;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.Chunk;
import weblogic.utils.net.SocketResetException;

public final class NTSocketMuxer
extends ServerSocketMuxer {
    private static final int ARRAY_CHUNK_SIZE = 1024;
    private static ArrayList socketInfos = new ArrayList(1024);
    private static Stack freeIndexes = new Stack(1024);
    private static int nativeArrayCapacity = 1024;

    public NTSocketMuxer() throws IOException {
        System.loadLibrary("wlntio");
        NTSocketMuxer.initNative(10000, 1024, Chunk.CHUNK_SIZE);
        String string = NTSocketMuxer.getBuildTime();
        SocketLogger.logTimeStamp((String)string);
        this.init();
    }

    private void init() {
        NTSocketMuxer.setDebug(Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail());
        this.initSocketReaderThreads(2, "weblogic.socket.Muxer", "weblogic.NTSocketReaders");
        for (int i = 0; i < 1024; ++i) {
            socketInfos.add(null);
            freeIndexes.push((Object)new Integer(i));
        }
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        NTSocketInfo nTSocketInfo = null;
        try {
            nTSocketInfo = new NTSocketInfo(muxableSocket);
        }
        catch (IOException iOException) {
            SocketLogger.logRegisterSocketProblem((String)muxableSocket.toString(), (Exception)iOException);
            throw iOException;
        }
        muxableSocket.setSocketInfo((SocketInfo)nTSocketInfo);
        super.register(muxableSocket);
    }

    public void read(MuxableSocket muxableSocket) {
        this.internalRead(muxableSocket, muxableSocket.getSocketInfo());
    }

    private void internalRead(MuxableSocket muxableSocket, SocketInfo socketInfo) {
        if (!this.initiateIO(socketInfo)) {
            return;
        }
        try {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("initiateNativeIo for: " + socketInfo));
            }
            NTSocketMuxer.initiateNativeIo(((NTSocketInfo)socketInfo).nativeIndex);
        }
        catch (SocketException socketException) {
            SocketResetException socketResetException;
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerException()) {
                SocketLogger.logNTMuxerInitiateIOError((String)socketInfo.toString(), (Exception)socketException);
            }
            this.completeIO(muxableSocket, socketInfo);
            if (SocketResetException.isResetException((IOException)socketException)) {
                socketResetException = new SocketResetException((IOException)socketException);
            }
            this.deliverHasException(muxableSocket, (Throwable)socketResetException);
        }
    }

    public void processSockets() {
        IoCompletionData ioCompletionData = new IoCompletionData();
        while (true) {
            ioCompletionData.clear();
            MuxableSocket muxableSocket = null;
            try {
                boolean bl = NTSocketMuxer.getIoCompletionResult(ioCompletionData);
                int n = ioCompletionData.index;
                NTSocketInfo nTSocketInfo = (NTSocketInfo)((Object)socketInfos.get(n));
                if (nTSocketInfo == null) {
                    SocketLogger.logNTMuxerSocketInfoNotFound((String)("" + n), (boolean)bl);
                    continue;
                }
                muxableSocket = nTSocketInfo.getMuxableSocket();
                if (!this.completeIO(muxableSocket, nTSocketInfo)) continue;
                if (bl) {
                    if (ioCompletionData.numAvailableBytes <= 0) {
                        this.deliverEndOfStream(muxableSocket);
                        continue;
                    }
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                        SocketLogger.logDebug((String)("data ready for " + (Object)((Object)nTSocketInfo) + ": " + ioCompletionData));
                    }
                    if (!this.copyDataFromNativeBuffer(muxableSocket, ioCompletionData)) continue;
                    if (muxableSocket.isMessageComplete()) {
                        nTSocketInfo.messageCompleted();
                        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                            SocketLogger.logDebug((String)("dispatch: " + (Object)((Object)nTSocketInfo)));
                        }
                        muxableSocket.dispatch();
                        continue;
                    }
                    nTSocketInfo.messageInitiated();
                    this.internalRead(muxableSocket, nTSocketInfo);
                    continue;
                }
                this.deliverHasException(muxableSocket, (Throwable)new SocketResetException());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (!Kernel.isServer()) continue;
                if (!Kernel.isIntentionalShutdown()) {
                    SocketLogger.logThreadDeath((ThreadDeath)threadDeath);
                }
                throw threadDeath;
            }
            catch (Throwable throwable) {
                SocketLogger.logUncaughtThrowable((Throwable)throwable);
                if (muxableSocket == null) continue;
                this.deliverHasException(muxableSocket, throwable);
                continue;
            }
            break;
        }
    }

    private boolean copyDataFromNativeBuffer(MuxableSocket muxableSocket, IoCompletionData ioCompletionData) {
        NTSocketInfo nTSocketInfo = (NTSocketInfo)muxableSocket.getSocketInfo();
        int n = ioCompletionData.numAvailableBytes;
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = nTSocketInfo.nativeIndex;
        while (n > 0) {
            byArray = muxableSocket.getBuffer();
            int n5 = byArray.length - (n2 = muxableSocket.getBufferOffset());
            if (n5 < 0) {
                throw new AssertionError("Buffer offset > buffer length for socket ms=" + (Object)((Object)nTSocketInfo));
            }
            int n6 = Math.min(n5, n);
            NTSocketMuxer.copyData(byArray, n2, n6, n4, n3);
            n -= n6;
            try {
                muxableSocket.incrementBufferOffset(n6);
                n3 += n6;
            }
            catch (MaxMessageSizeExceededException maxMessageSizeExceededException) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebugException((String)("Exception while copying data for " + (Object)((Object)nTSocketInfo)), (Exception)((Object)maxMessageSizeExceededException));
                }
                this.deliverHasException(muxableSocket, maxMessageSizeExceededException);
                return false;
            }
        }
        return true;
    }

    static int add(NTSocketInfo nTSocketInfo) throws IOException {
        int n = NTSocketMuxer.getNewIoRecord(nTSocketInfo);
        try {
            NTSocketMuxer.initIoRecord(n, nTSocketInfo.fd);
        }
        catch (IOException iOException) {
            NTSocketMuxer.freeIoRecord(n);
            throw iOException;
        }
        return n;
    }

    static void remove(int n) {
        NTSocketMuxer.freeIoRecord(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNewIoRecord(NTSocketInfo nTSocketInfo) {
        ArrayList arrayList = socketInfos;
        synchronized (arrayList) {
            if (!freeIndexes.isEmpty()) {
                int n = (Integer)freeIndexes.pop();
                socketInfos.set(n, nTSocketInfo);
                return n;
            }
            int n = socketInfos.size();
            socketInfos.add(n, nTSocketInfo);
            if (n == nativeArrayCapacity) {
                NTSocketMuxer.addIoRecordArrayChunk();
                nativeArrayCapacity += 1024;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeIoRecord(int n) {
        ArrayList arrayList = socketInfos;
        synchronized (arrayList) {
            socketInfos.set(n, null);
            freeIndexes.push((Object)new Integer(n));
        }
    }

    private static native void initNative(int var0, int var1, int var2) throws IOException;

    private static native void addIoRecordArrayChunk();

    private static native void initIoRecord(int var0, int var1) throws IOException;

    private static native void initiateNativeIo(int var0) throws SocketException;

    private static native boolean getIoCompletionResult(IoCompletionData var0);

    private static native void copyData(byte[] var0, int var1, int var2, int var3, int var4);

    private static native String getBuildTime();

    private static native void setDebug(boolean var0);

    private static final class IoCompletionData {
        private int fd;
        private int index;
        private int numAvailableBytes;

        private IoCompletionData() {
        }

        private void clear() {
            this.fd = -1;
            this.index = -1;
            this.numAvailableBytes = 0;
        }

        public String toString() {
            return this.getClass().getName() + "[fd=" + this.fd + ", index=" + this.index + ", numAvailableBytes=" + this.numAvailableBytes + "]";
        }
    }
}

