/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.Socket;
import weblogic.kernel.Kernel;
import weblogic.platform.VM;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.WeblogicSocket;

class NativeSocketInfo
extends SocketInfo {
    private static VM vm;
    protected final int fd = this.initFD();

    public final int getFD() {
        return this.fd;
    }

    NativeSocketInfo(MuxableSocket muxableSocket) throws IOException {
        super(muxableSocket);
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("Obtained fd=" + this.fd + " for: sock=" + muxableSocket.getSocket()));
        }
    }

    protected String fieldsToString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.fieldsToString()).append(", ").append("fd = ").append(this.fd);
        return stringBuffer.toString();
    }

    private static synchronized void initVM() {
        if (vm != null) {
            return;
        }
        vm = VM.getVM();
    }

    protected int initFD() throws IOException {
        try {
            Socket socket = this.ms.getSocket();
            if (socket instanceof WeblogicSocket) {
                socket = ((WeblogicSocket)socket).getSocket();
            }
            if (vm == null) {
                NativeSocketInfo.initVM();
            }
            return vm.getFD(socket);
        }
        catch (IOException iOException) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug((String)iOException.getMessage());
            }
            throw iOException;
        }
    }
}

