/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.Kernel;
import weblogic.socket.Jdk6;
import weblogic.socket.SocketMuxer;
import weblogic.utils.io.Chunk;

public class NetworkInterfaceInfo {
    private static Map<InetAddress, NetworkInterfaceInfo> map = new ConcurrentHashMap<InetAddress, NetworkInterfaceInfo>(10);
    private boolean asyncMuxer;
    private InetAddress localAddress;
    private int mtuSize;
    private boolean supportsGatheredWrites;
    private boolean supportsScatteredReads;
    private int numBuffers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkInterfaceInfo getNetworkInterfaceInfo(InetAddress inetAddress) {
        NetworkInterfaceInfo networkInterfaceInfo = map.get(inetAddress);
        if (networkInterfaceInfo == null) {
            Map<InetAddress, NetworkInterfaceInfo> map = NetworkInterfaceInfo.map;
            synchronized (map) {
                networkInterfaceInfo = NetworkInterfaceInfo.map.get(inetAddress);
                if (networkInterfaceInfo == null) {
                    networkInterfaceInfo = NetworkInterfaceInfo.create(inetAddress);
                    NetworkInterfaceInfo.map.put(inetAddress, networkInterfaceInfo);
                }
            }
        }
        return networkInterfaceInfo;
    }

    private static NetworkInterfaceInfo create(InetAddress inetAddress) {
        Object object;
        int n = 1500;
        try {
            object = NetworkInterface.getByInetAddress(inetAddress);
            if (object != null) {
                n = Jdk6.getMTU((NetworkInterface)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new NetworkInterfaceInfo(inetAddress, SocketMuxer.getMuxer().isAsyncMuxer(), n);
        return object;
    }

    private NetworkInterfaceInfo(InetAddress inetAddress, boolean bl, int n) {
        this.localAddress = inetAddress;
        this.asyncMuxer = bl;
        this.mtuSize = n;
        this.supportsGatheredWrites = this.isGatheredWritesEnabled() && bl;
        this.supportsScatteredReads = this.isScatteredReadsEnabled() && bl;
        this.numBuffers = this.mtuSize / Chunk.CHUNK_SIZE;
        if (this.numBuffers == 0) {
            this.numBuffers = 16;
        }
    }

    public InetAddress getLocalInetAddress() {
        return this.localAddress;
    }

    public int getMTU() {
        return this.mtuSize;
    }

    public boolean supportsGatheredWrites() {
        return this.supportsGatheredWrites;
    }

    public boolean supportsScatteredReads() {
        return this.supportsScatteredReads;
    }

    public int getOptimalNumberOfBuffers() {
        return this.numBuffers;
    }

    private boolean isGatheredWritesEnabled() {
        return Kernel.getConfig().isGatheredWritesEnabled();
    }

    private boolean isScatteredReadsEnabled() {
        return Kernel.getConfig().isScatteredReadsEnabled();
    }
}

