/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.SocketException;
import weblogic.kernel.Kernel;
import weblogic.socket.IncompatibleVMException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.PosixSocketInfo;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.utils.NestedError;
import weblogic.utils.net.SocketResetException;

final class PosixSocketMuxer
extends ServerSocketMuxer {
    private final PosixSocketInfo.FdStruct[] fdStructs;
    private final int maxNumberOfFds;
    private int numberOfFds = 0;
    private final Object pollLock = new Object(){};

    public PosixSocketMuxer() throws IOException {
        try {
            System.loadLibrary("muxer");
            PosixSocketMuxer.initNative();
            PosixSocketMuxer.setDebug(Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail());
        }
        catch (IncompatibleVMException incompatibleVMException) {
            throw incompatibleVMException;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw unsatisfiedLinkError;
        }
        catch (Throwable throwable) {
            SocketLogger.logInitPerf();
            throw new NestedError("Could not initialize POSIX Performance Pack", throwable);
        }
        SocketLogger.logFdLimit((int)PosixSocketMuxer.getSoftFdLimit(), (int)PosixSocketMuxer.getHardFdLimit());
        this.maxNumberOfFds = PosixSocketMuxer.getCurrentFdLimit();
        SocketLogger.logFdCurrent((int)this.maxNumberOfFds);
        SocketLogger.logTimeStamp((String)PosixSocketMuxer.getBuildTime());
        this.initSocketReaderThreads(3, "weblogic.socket.Muxer", "weblogic.PosixSocketReaders");
        this.fdStructs = new PosixSocketInfo.FdStruct[this.maxNumberOfFds * 2];
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        muxableSocket.setSocketInfo((SocketInfo)new PosixSocketInfo(muxableSocket));
        super.register(muxableSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(MuxableSocket muxableSocket) {
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        if (!this.initiateIO(socketInfo)) {
            return;
        }
        PosixSocketInfo.FdStruct fdStruct = ((PosixSocketInfo)socketInfo).fdStruct;
        fdStruct.status = 0;
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug((String)("initiate read for: " + fdStruct));
        }
        PosixSocketInfo.FdStruct[] fdStructArray = this.fdStructs;
        synchronized (this.fdStructs) {
            if (this.numberOfFds == this.maxNumberOfFds * 2) {
                SocketLogger.logPosixMuxerMaxFdExceededError((int)this.maxNumberOfFds);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            this.fdStructs[this.numberOfFds++] = fdStruct;
            this.fdStructs.notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            PosixSocketMuxer.wakeupPoll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void processSockets() {
        PosixSocketInfo.FdStruct[] fdStructArray = new PosixSocketInfo.FdStruct[this.maxNumberOfFds * 2];
        int n = 0;
        while (true) {
            try {
                while (true) {
                    PosixSocketInfo.FdStruct fdStruct;
                    Object object = this.pollLock;
                    // MONITORENTER : object
                    Object object2 = this.fdStructs;
                    // MONITORENTER : this.fdStructs
                    while (this.numberOfFds == 0) {
                        this.fdStructs.wait();
                    }
                    int n2 = this.numberOfFds;
                    // MONITOREXIT : object2
                    if (!PosixSocketMuxer.poll(this.fdStructs, n2)) {
                        // MONITOREXIT : object
                        continue;
                    }
                    object2 = this.fdStructs;
                    // MONITORENTER : this.fdStructs
                    int n3 = 0;
                    while (n3 < n2) {
                        fdStruct = this.fdStructs[n3];
                        if (fdStruct.status == 0) {
                            if (++n3 != this.numberOfFds) continue;
                            break;
                        }
                        fdStructArray[n++] = fdStruct;
                        if (n3 == --this.numberOfFds) {
                            this.fdStructs[n3] = null;
                            break;
                        }
                        this.fdStructs[n3] = this.fdStructs[this.numberOfFds];
                        this.fdStructs[this.numberOfFds] = null;
                    }
                    // MONITOREXIT : object2
                    // MONITOREXIT : object
                    for (int i = 0; i < n; ++i) {
                        object2 = fdStructArray[i];
                        fdStructArray[i] = null;
                        PosixSocketInfo posixSocketInfo = object2.info;
                        fdStruct = posixSocketInfo.getMuxableSocket();
                        if (!this.completeIO((MuxableSocket)fdStruct, posixSocketInfo)) continue;
                        if (object2.status == 1) {
                            try {
                                this.readReadySocket((MuxableSocket)fdStruct, posixSocketInfo, 0L);
                            }
                            catch (Throwable throwable) {
                                this.deliverHasException(posixSocketInfo.getMuxableSocket(), throwable);
                            }
                            continue;
                        }
                        if (object2.status == 2) {
                            this.deliverHasException((MuxableSocket)fdStruct, new SocketException("Error in poll for fd=" + posixSocketInfo.fd + ", revents=" + object2.revents));
                            continue;
                        }
                        if (object2.status != 3) continue;
                        this.deliverHasException((MuxableSocket)fdStruct, (Throwable)new SocketResetException("Error in poll for fd=" + posixSocketInfo.fd + ", revents=" + object2.revents));
                    }
                    n = 0;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                SocketLogger.logUncaughtThrowable((Throwable)throwable);
                continue;
            }
            break;
        }
    }

    private static native void initNative() throws IncompatibleVMException;

    private static native boolean poll(PosixSocketInfo.FdStruct[] var0, int var1) throws IOException;

    private static native void wakeupPoll();

    private static native int getSoftFdLimit();

    private static native int getHardFdLimit();

    private static native int getCurrentFdLimit();

    private static native String getBuildTime();

    private static native void setDebug(boolean var0);
}

