/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.utils.AssertionError;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

public final class SSLFilterImpl
implements SSLFilter {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private boolean activated = false;
    private final InputStream in;
    private Chunk head;
    private Chunk tail;
    private int pos;
    private int availBytes;
    private MuxableSocket delegate;
    private final SSLSocket sslSocket;
    private InputStream clearText;
    private SocketInfo sockInfo;
    private ChunkedInputStream cis = null;

    public SSLFilterImpl(InputStream inputStream, SSLSocket sSLSocket) throws IOException {
        this.in = inputStream;
        this.sslSocket = sSLSocket;
        this.head = this.tail = Chunk.getChunk();
        SSLSetupLogging.info("Filtering JSSE SSLSocket");
    }

    public String toString() {
        return "SSLFilterImpl[" + this.getDelegate() + "]";
    }

    public MuxableSocket getDelegate() {
        return this.delegate;
    }

    public void setDelegate(MuxableSocket muxableSocket) {
        this.delegate = muxableSocket;
    }

    public void asyncOn() {
        this.activated = true;
    }

    public void asyncOff() {
        this.activated = false;
    }

    public boolean isActivated() {
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkedInputStream getInputStream() throws IOException {
        if (this.cis == null) {
            SSLFilterImpl sSLFilterImpl = this;
            synchronized (sSLFilterImpl) {
                if (this.cis == null) {
                    this.cis = new ChunkedInputStream(this.head, 0, this.in);
                }
                ChunkedInputStream chunkedInputStream = this.cis;
                synchronized (chunkedInputStream) {
                }
            }
        }
        return this.cis;
    }

    public int available() throws IOException {
        if (!this.activated) {
            return this.in.available();
        }
        return this.availBytes;
    }

    public void activate() throws IOException {
        SSLSetupLogging.info("SSLFilteriImpl.activate()");
        this.activateNoRegister();
        if (this.delegate.isMessageComplete()) {
            SocketMuxer.getMuxer().register(this);
            this.delegate.dispatch();
        } else {
            SocketMuxer.getMuxer().register(this);
            SocketMuxer.getMuxer().read(this);
        }
    }

    public void activateNoRegister() throws IOException {
        SSLSetupLogging.info("activateNoRegister()");
        this.clearText = this.sslSocket.getInputStream();
        try {
            int n = 0;
            for (int i = 0; i > 0; i -= n) {
                SSLSetupLogging.info("clearTextAvail = " + i);
                byte[] byArray = this.delegate.getBuffer();
                int n2 = this.delegate.getBufferOffset();
                n = this.clearText.read(byArray, n2, Math.min(byArray.length - n2, i));
                this.delegate.incrementBufferOffset(n);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        this.activated = true;
        SSLSetupLogging.info("SSLFilterImpl.activate(): activated: " + this.in.hashCode() + " " + this.clearText.hashCode());
    }

    public int getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    public byte[] getBuffer() {
        if (this.tail.end == this.tail.buf.length) {
            this.tail = this.tail.next = Chunk.getChunk();
        }
        return this.tail.buf;
    }

    public int getBufferOffset() {
        return this.tail.end;
    }

    private static void p(String string) {
        System.out.println("SSLFilterImpl: " + string);
    }

    public void incrementBufferOffset(int n) throws MaxMessageSizeExceededException {
        this.availBytes += n;
        this.tail.end += n;
    }

    public boolean isMessageComplete() {
        while (true) {
            byte[] byArray = this.delegate.getBuffer();
            int n = this.delegate.getBufferOffset();
            try {
                int n2 = this.clearText.read(byArray, n, byArray.length - n);
                if (n2 == -1) {
                    try {
                        SocketMuxer.getMuxer().deliverEndOfStream(this);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof SocketException) break;
                        SocketLogger.logDebugException((String)"isMessageComplete", (Exception)((Exception)throwable));
                    }
                    break;
                }
                this.delegate.incrementBufferOffset(n2);
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (MaxMessageSizeExceededException maxMessageSizeExceededException) {
                SocketMuxer.getMuxer().deliverHasException(this, maxMessageSizeExceededException);
            }
            catch (IOException iOException) {
                if (!(iOException instanceof SocketException)) {
                    SocketLogger.logDebugException((String)"isMessageComplete", (Exception)iOException);
                }
                SocketMuxer.getMuxer().deliverHasException(this, iOException);
                continue;
            }
            catch (Throwable throwable) {
                SocketLogger.logDebugException((String)"isMessageComplete", (Exception)((Exception)throwable));
                SocketMuxer.getMuxer().deliverHasException(this, throwable);
                continue;
            }
            break;
        }
        boolean bl = this.delegate.isMessageComplete();
        return bl;
    }

    public void dispatch() {
        this.delegate.dispatch();
    }

    public InputStream getSocketInputStream() {
        return this.in;
    }

    public void setSoTimeout(int n) throws SocketException {
        this.delegate.setSoTimeout(n);
    }

    public Socket getSocket() {
        return this.sslSocket;
    }

    public boolean closeSocketOnError() {
        return true;
    }

    public void hasException(Throwable throwable) {
        if (!(throwable instanceof SocketException)) {
            SSLSetupLogging.debug(3, throwable, "hasException");
        }
        this.delegate.hasException(throwable);
    }

    public void endOfStream() {
        this.delegate.endOfStream();
    }

    public boolean timeout() {
        return this.delegate.timeout();
    }

    public boolean requestTimeout() {
        return this.delegate.requestTimeout();
    }

    public int getCompleteMessageTimeoutMillis() {
        return this.delegate.getCompleteMessageTimeoutMillis();
    }

    public void setSocketFilter(MuxableSocket muxableSocket) {
        throw new AssertionError("Re-register Muxer not allowed on SSLFilterImpl");
    }

    public MuxableSocket getSocketFilter() {
        return this;
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.sockInfo = socketInfo;
    }

    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    public void ensureForceClose() {
        try {
            this.sslSocket.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean supportsScatteredRead() {
        return false;
    }

    public long read(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        throw new UnsupportedOperationException();
    }
}

