/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicServerSocket;
import weblogic.socket.utils.SDPSocketUtils;

public abstract class ServerSocketMuxer
extends SocketMuxer {
    protected ServerSocketMuxer() throws IOException {
    }

    public static ServerSocketMuxer getMuxer() {
        return (ServerSocketMuxer)SocketMuxer.SingletonMaker.singleton;
    }

    public ServerSocket newServerSocket(InetAddress inetAddress, int n, int n2, boolean bl) throws IOException {
        ServerSocket serverSocket = null;
        if (enableSocketChannels && !bl) {
            serverSocket = ServerSocketChannel.open().socket();
            serverSocket.getChannel().configureBlocking(true);
        } else {
            serverSocket = new ServerSocket();
        }
        if (inetAddress == null) {
            serverSocket.bind(new InetSocketAddress(n), n2);
        } else {
            serverSocket.bind(new InetSocketAddress(inetAddress, n), n2);
        }
        return new WeblogicServerSocket(serverSocket, false);
    }

    public ServerSocket newSDPServerSocket(InetAddress inetAddress, int n, int n2, boolean bl) throws IOException {
        ServerSocket serverSocket = null;
        if (enableSocketChannels) {
            throw new AssertionError((Object)"SDP server sockets not supported with socket channels");
        }
        serverSocket = SDPSocketUtils.createSDPServerSocket();
        if (inetAddress == null) {
            serverSocket.bind(new InetSocketAddress(n), n2);
        } else {
            serverSocket.bind(new InetSocketAddress(inetAddress, n), n2);
        }
        return new WeblogicServerSocket(serverSocket, false);
    }
}

