/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.KernelMBean;
import weblogic.platform.VM;
import weblogic.server.ServiceFailureException;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.JavaSocketMuxer;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketOptionException;
import weblogic.socket.SocketReaderRequest;
import weblogic.socket.internal.SocketEnvironment;
import weblogic.socket.utils.ProxyUtils;
import weblogic.socket.utils.SDPSocketUtils;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.net.SocketResetException;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketMuxer {
    private static final String TIMER_MANAGER_NAME = "MuxerTimerManager";
    private static final int TIMER_MANAGER_INTERVAL = 5000;
    private static final String SOCKET_CHANNEL_ENABLE_PROP = "weblogic.server.enablesocketchannels";
    private static final String DELAYPOLLWAKEUPPROP = "weblogic.socket.SocketMuxer.DELAY_POLL_WAKEUP";
    protected static final long DELAYPOLLWAKEUP = SocketMuxer.initMuxerDelayPollProp();
    private static final int EOS = -1;
    private static final String sockCreateTimeoutProp = "weblogic.client.socket.ConnectTimeout";
    private static final int sockCreateTimeout = SocketMuxer.initSockCreateTimeoutProp();
    protected static final String SOCKET_READERS_QUEUE_NAME = "weblogic.socket.Muxer";
    protected static final boolean enableSocketChannels = KernelStatus.isServer() && Boolean.getBoolean("weblogic.server.enablesocketchannels");
    protected final ConcurrentHashMap<MuxableSocket, Object> sockets = new ConcurrentHashMap(4096);
    private static final Object ISPRESENT = new Object();
    private static boolean isAvailable = false;
    protected static KernelMBean config = Kernel.getConfig();
    private static final String osName = SocketMuxer.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);
    private static final boolean isAix = "aix".equals(osName);
    private static final boolean isJrve = "jrve".equalsIgnoreCase(osName);
    protected static int rdrThreads = -1;

    private static int initSockCreateTimeoutProp() {
        if (!KernelStatus.isServer()) {
            try {
                return Integer.getInteger(sockCreateTimeoutProp, 0) * 1000;
            }
            catch (SecurityException securityException) {
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    private static long initMuxerDelayPollProp() {
        if (KernelStatus.isServer()) {
            return Long.getLong(DELAYPOLLWAKEUPPROP, 0L);
        }
        return 0L;
    }

    private static String initOSNameProp() {
        String string = "UNKNOWN";
        try {
            string = System.getProperty("os.name", "UNKNOWN").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    public static SocketMuxer getMuxer() {
        return SingletonMaker.singleton;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    static SocketMuxer initSocketMuxerOnServer() throws ServiceFailureException {
        if (enableSocketChannels && !VM.getVM().supportsNIOSocketChannels()) {
            String string = SocketLogger.logNoSocketChannelSupportForVM();
            throw new ServiceFailureException(string);
        }
        return SingletonMaker.singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SocketMuxer makeTheMuxer() {
        JavaSocketMuxer javaSocketMuxer;
        block27: {
            SocketMuxer socketMuxer;
            block25: {
                try {
                    block26: {
                        if (!KernelStatus.isServer()) {
                            JavaSocketMuxer javaSocketMuxer2;
                            try {
                                javaSocketMuxer2 = new JavaSocketMuxer();
                            }
                            catch (IOException iOException) {
                                SocketLogger.logJavaMuxerCreationError2();
                                if (KernelStatus.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                                    SocketLogger.logDebugException((String)"Java muxer creation failed", (Exception)iOException);
                                }
                                SocketMuxer socketMuxer2 = null;
                                Object var4_4 = null;
                                isAvailable = true;
                                return socketMuxer2;
                            }
                            Object var4_3 = null;
                            isAvailable = true;
                            return javaSocketMuxer2;
                        }
                        String string = SocketMuxer.getNativeMuxerClassName();
                        try {
                            SocketMuxer socketMuxer3 = (SocketMuxer)Class.forName(string).newInstance();
                            if (string != null && string.indexOf("Java") == -1) {
                                SocketLogger.logNativeIOEnabled();
                            } else {
                                SocketLogger.logNativeIODisabled();
                            }
                            socketMuxer = socketMuxer3;
                            break block25;
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            SocketLogger.logMuxerUnsatisfiedLinkError((String)SocketMuxer.getLinkError(string));
                            if (KernelStatus.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                                SocketLogger.logDebugException((String)"Muxer creation failed", (Exception)((Exception)((Object)unsatisfiedLinkError)));
                            }
                        }
                        catch (Throwable throwable) {
                            if (string.equals("weblogic.socket.DevPollSocketMuxer") || string.equals("weblogic.socket.EPollSocketMuxer")) {
                                SocketMuxer socketMuxer4;
                                if (string.equals("weblogic.socket.DevPollSocketMuxer")) {
                                    SocketLogger.logNativeDevPollMuxerError((Throwable)throwable);
                                } else if (KernelStatus.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                                    SocketLogger.logNativeDevPollMuxerError((Throwable)throwable);
                                }
                                try {
                                    socketMuxer4 = (SocketMuxer)Class.forName("weblogic.socket.PosixSocketMuxer").newInstance();
                                }
                                catch (ThreadDeath threadDeath) {
                                    throw threadDeath;
                                }
                                catch (Throwable throwable2) {
                                    SocketLogger.logNativeMuxerError((Throwable)throwable2);
                                    break block26;
                                }
                                Object var4_6 = null;
                                isAvailable = true;
                                return socketMuxer4;
                            }
                            SocketLogger.logNativeMuxerError((Throwable)throwable);
                        }
                    }
                    SocketLogger.logNativeIODisabled();
                    try {
                        javaSocketMuxer = new JavaSocketMuxer();
                        break block27;
                    }
                    catch (IOException iOException) {
                        SocketLogger.logJavaMuxerCreationError2();
                        if (KernelStatus.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                            SocketLogger.logDebugException((String)"Java muxer creation failed", (Exception)iOException);
                        }
                        SocketMuxer socketMuxer5 = null;
                        Object var4_8 = null;
                        isAvailable = true;
                        return socketMuxer5;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    isAvailable = true;
                    throw throwable;
                }
            }
            Object var4_5 = null;
            isAvailable = true;
            return socketMuxer;
        }
        Object var4_7 = null;
        isAvailable = true;
        return javaSocketMuxer;
    }

    private static String getNativeMuxerClassName() {
        try {
            String string = Kernel.getConfig().getMuxerClass();
            if (string != null) {
                return string;
            }
            if (!VM.getVM().isNativeThreads()) {
                return "weblogic.socket.JavaSocketMuxer";
            }
            if (!Kernel.getConfig().isNativeIOEnabled()) {
                return "weblogic.socket.JavaSocketMuxer";
            }
            if (osName.startsWith("windows")) {
                return "weblogic.socket.NTSocketMuxer";
            }
            if (Kernel.getConfig().isDevPollDisabled()) {
                return "weblogic.socket.PosixSocketMuxer";
            }
            if (osName.equals("hp-ux") || osName.equals("sunos")) {
                return "weblogic.socket.DevPollSocketMuxer";
            }
            if (isLinux) {
                try {
                    Class.forName("jrockit.ext.epoll.EPoll");
                    return "weblogic.socket.EPollSocketMuxer";
                }
                catch (Throwable throwable) {
                    return "weblogic.socket.PosixSocketMuxer";
                }
            }
            if (isJrve) {
                return "weblogic.socket.EPollSocketMuxer";
            }
            return "weblogic.socket.PosixSocketMuxer";
        }
        catch (SecurityException securityException) {
            return "weblogic.socket.JavaSocketMuxer";
        }
    }

    private static String getLinkError(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty("java.library.path", "java.library.path");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if ("weblogic.socket.NTSocketMuxer".equals(string)) {
            return "Please ensure that wlntio.dll is in: '" + string2 + "'";
        }
        if ("weblogic.socket.PosixSocketMuxer".equals(string)) {
            return "Please ensure that libmuxer library is in :'" + string2 + "'";
        }
        return "Please ensure that a native performance library is in: '" + string2 + "'";
    }

    protected void initSocketReaderThreads(int n, String string, String string2) {
        SocketMuxer.initThreadCount(n, string, string2);
        this.startSocketReaderThreads(string);
    }

    protected static void initThreadCount(int n, String string, String string2) {
        int n2;
        ExecuteThreadManager executeThreadManager = Kernel.getExecuteThreadManager(string);
        if (executeThreadManager != null && executeThreadManager.getName().equalsIgnoreCase(string)) {
            n2 = executeThreadManager.getExecuteThreadCount();
        } else {
            n2 = config.getSocketReaders();
            if (n2 <= 0 && (n2 = Integer.getInteger(string2, -1).intValue()) <= 0) {
                int n3 = Runtime.getRuntime().availableProcessors();
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebug((String)("Number of CPUs=" + n3));
                }
                if ((n2 = n3 > 0 ? n3 + 1 : n) > 4) {
                    n2 = 4;
                }
            }
            Kernel.addExecuteQueue(string, n2);
        }
        rdrThreads = n2;
    }

    protected void startSocketReaderThreads(String string) {
        if (rdrThreads == -1) {
            throw new IllegalStateException("Socket Reader threads not initialized");
        }
        SocketLogger.logAllocSocketReaders((int)rdrThreads);
        for (int i = 0; i < rdrThreads; ++i) {
            Kernel.execute((ExecuteRequest)new SocketReaderRequest(), string);
        }
    }

    public boolean isAsyncMuxer() {
        return false;
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    public Socket newSocket(InetAddress inetAddress, int n) throws IOException {
        return this.newSocket(inetAddress, n, sockCreateTimeout);
    }

    public Socket newSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket = new Socket();
        SocketMuxer.initSocket(socket);
        socket.connect(new InetSocketAddress(inetAddress, n), n2);
        return socket;
    }

    public Socket newClientSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        if (ProxyUtils.canProxy(inetAddress, false)) {
            return ProxyUtils.getClientProxy(inetAddress.getHostAddress(), n, n2);
        }
        return this.newSocket(inetAddress, n, n2);
    }

    public Socket newClientSocket(InetAddress inetAddress, int n) throws IOException {
        return this.newClientSocket(inetAddress, n, 0);
    }

    public Socket newSSLClientSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        if (ProxyUtils.canProxy(inetAddress, true)) {
            return ProxyUtils.getSSLClientProxy(inetAddress.getHostAddress(), n, n2);
        }
        return null;
    }

    public Socket newSSLClientSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        if (ProxyUtils.canProxy(inetAddress, true)) {
            return ProxyUtils.getSSLClientProxy(inetAddress.getHostAddress(), n, inetAddress2.getHostAddress(), n2, n3);
        }
        return null;
    }

    public Socket newSSLClientSocket(InetAddress inetAddress, int n) throws IOException {
        return this.newSSLClientSocket(inetAddress, n, 0);
    }

    public Socket newSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        Socket socket = new Socket();
        return this.initSocket(socket, inetAddress, n, inetAddress2, n2, n3);
    }

    public Socket newSDPSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        Socket socket = SDPSocketUtils.createSDPSocket();
        return this.initSocket(socket, inetAddress, n, inetAddress2, n2, n3);
    }

    protected Socket initSocket(Socket socket, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, int n3) throws IOException {
        SocketMuxer.initSocket(socket);
        socket.bind(new InetSocketAddress(inetAddress2, n2));
        socket.connect(new InetSocketAddress(inetAddress, n), n3);
        return socket;
    }

    public Socket newProxySocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, InetAddress inetAddress3, int n3, int n4) throws IOException {
        Socket socket = this.newSocket(inetAddress3, n3, inetAddress2, n2, n4);
        return ProxyUtils.getProxySocket(socket, inetAddress.getHostName(), n, inetAddress3.getHostName(), n3);
    }

    public Socket newWeblogicSocket(Socket socket) throws IOException {
        SocketMuxer.initSocket(socket);
        if (SocketEnvironment.getSocketEnvironment().serverThrottleEnabled()) {
            return SocketEnvironment.getSocketEnvironment().getWeblogicSocket(socket);
        }
        return socket;
    }

    static void initSocket(Socket socket) throws SocketOptionException {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SocketOptionException(socketException.getMessage());
        }
    }

    protected void closeSocket(Socket socket) {
        this.closeSocket(socket, true);
    }

    private void closeSocket(Socket socket, boolean bl) {
        try {
            if (isLinux || isAix || isJrve) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerConnection()) {
                    SocketLogger.logDebug((String)("Closing input and output of socket " + socket));
                }
                try {
                    socket.shutdownInput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bl) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerConnection()) {
                    SocketLogger.logDebug((String)("Closing raw socket " + socket));
                }
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SocketMuxer() throws IOException {
        TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER_NAME, WorkManagerFactory.getInstance().getSystem());
        timerManager.scheduleAtFixedRate((TimerListener)new TimerListenerImpl(), 0L, 5000L);
    }

    public void register(MuxableSocket muxableSocket) throws IOException {
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("register: sockInfo=" + muxableSocket.getSocketInfo()));
        }
        this.sockets.put(muxableSocket, ISPRESENT);
    }

    public void reRegister(MuxableSocket muxableSocket, MuxableSocket muxableSocket2) {
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("reRegister: oldSockInfo=" + muxableSocket.getSocketInfo() + ", newSock=" + muxableSocket2));
        }
        this.sockets.remove(muxableSocket);
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        muxableSocket.setSocketInfo(null);
        socketInfo.setMuxableSocket(muxableSocket2);
        muxableSocket2.setSocketInfo(socketInfo);
        this.sockets.put(muxableSocket2, ISPRESENT);
    }

    public abstract void read(MuxableSocket var1);

    public final void closeSocket(MuxableSocket muxableSocket) {
        this.deliverEndOfStream(muxableSocket);
    }

    protected abstract void processSockets();

    public final int getNumSockets() {
        return this.sockets.size();
    }

    public final Iterator<MuxableSocket> getSocketsIterator() {
        return this.sockets.keySet().iterator();
    }

    public final MuxableSocket[] getSockets() {
        Set set = this.sockets.keySet();
        MuxableSocket[] muxableSocketArray = new MuxableSocket[set.size()];
        return set.toArray(muxableSocketArray);
    }

    final boolean initiateIO(SocketInfo socketInfo) {
        return socketInfo.ioInitiated();
    }

    final boolean completeIO(MuxableSocket muxableSocket, SocketInfo socketInfo) {
        int n = socketInfo.ioCompleted();
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug((String)("completeIO: " + n + ", info=" + socketInfo));
        }
        if (n == 1) {
            return false;
        }
        if ((n & 2) != 0) {
            if ((n & 8) == 0) {
                this.cleanupSocket(muxableSocket, socketInfo);
            }
            return false;
        }
        return true;
    }

    public final void finishExceptionHandling(MuxableSocket muxableSocket) {
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        int n = socketInfo.exceptionHandlingCompleted();
        if (n == 0) {
            this.cleanupSocket(muxableSocket, socketInfo);
        } else if (n == 4) {
            this.cancelIo(muxableSocket);
        }
    }

    public final void deliverEndOfStream(MuxableSocket muxableSocket) {
        this.deliverExceptionAndCleanup(muxableSocket, null);
    }

    public final void deliverHasException(MuxableSocket muxableSocket, Throwable throwable) {
        this.deliverExceptionAndCleanup(muxableSocket, throwable);
    }

    private void deliverExceptionAndCleanup(MuxableSocket muxableSocket, Throwable throwable) {
        MuxableSocket muxableSocket2;
        if (muxableSocket == null) {
            throw new AssertionError(throwable);
        }
        SocketInfo socketInfo = muxableSocket.getSocketInfo();
        if (socketInfo == null && (muxableSocket2 = muxableSocket.getSocketFilter()) != null) {
            socketInfo = muxableSocket2.getSocketInfo();
        }
        if (socketInfo == null) {
            if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerConnection())) {
                SocketLogger.logDebug((String)("Unable to find internal data record for socket " + muxableSocket));
            }
            return;
        }
        int n = socketInfo.close();
        if (n == 1) {
            return;
        }
        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerConnection())) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("deliver");
            if (throwable == null) {
                stringBuffer.append("EndOfStream");
            } else {
                stringBuffer.append("HasException");
            }
            stringBuffer.append(": sockInfo=").append(muxableSocket.getSocketInfo()).append("\n");
            if (throwable == null) {
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)new Exception()));
            } else {
                stringBuffer.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            SocketLogger.logDebug((String)stringBuffer.toString());
        }
        if (throwable == null) {
            muxableSocket.endOfStream();
        } else {
            muxableSocket.hasException(throwable);
        }
        n = socketInfo.exceptionHandlingCompleted();
        if (n == 0) {
            this.cleanupSocket(muxableSocket, socketInfo);
            return;
        }
        if (n == 4) {
            this.cancelIo(muxableSocket);
            return;
        }
        throw new AssertionError("Socket ms=" + socketInfo + " in unexpected state: " + n);
    }

    protected void cancelIo(MuxableSocket muxableSocket) {
        if (isAix) {
            this.closeSocket(muxableSocket.getSocket(), false);
        } else {
            this.closeSocket(muxableSocket.getSocket());
        }
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("cancelIo: ms=" + muxableSocket + ", sockInfo=" + muxableSocket.getSocketInfo()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupSocket(MuxableSocket muxableSocket, SocketInfo socketInfo) {
        if (this.sockets.remove(muxableSocket) == null) {
            return;
        }
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug((String)("cleanupSocket: sockInfo=" + muxableSocket.getSocketInfo()));
        }
        try {
            socketInfo.cleanup();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (muxableSocket.closeSocketOnError()) {
                this.closeSocket(muxableSocket.getSocket());
            }
            throw throwable;
        }
        if (muxableSocket.closeSocketOnError()) {
            this.closeSocket(muxableSocket.getSocket());
        }
    }

    final void readReadySocket(MuxableSocket muxableSocket, SocketInfo socketInfo, long l) {
        if (l > 0L) {
            long l2 = System.currentTimeMillis() + l;
            while (this.readReadySocketOnce(muxableSocket, socketInfo)) {
                if (System.currentTimeMillis() > l2) {
                    this.read(muxableSocket);
                    break;
                }
                this.initiateIO(socketInfo);
            }
        } else if (this.readReadySocketOnce(muxableSocket, socketInfo)) {
            this.read(muxableSocket);
        }
    }

    private final boolean readReadySocketOnce(MuxableSocket muxableSocket, SocketInfo socketInfo) {
        int n;
        block14: {
            Socket socket = null;
            n = 0;
            try {
                socket = muxableSocket.getSocket();
                InputStream inputStream = muxableSocket.getSocketInputStream();
                if (inputStream == null) {
                    this.readCompleted(muxableSocket);
                    return false;
                }
                n = this.readFromSocket(muxableSocket);
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug((String)("read " + n + " bytes"));
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.handleReadTimeout(muxableSocket);
                return false;
            }
            catch (IOException iOException) {
                SocketResetException socketResetException;
                this.readCompleted(muxableSocket);
                if (SocketResetException.isResetException((IOException)iOException)) {
                    socketResetException = new SocketResetException(iOException);
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                        SocketLogger.logDebugException((String)("Connection reset on socket: '" + muxableSocket + "'"), (Exception)socketResetException);
                    }
                } else {
                    SocketLogger.logIOException((String)socket.toString(), (Exception)iOException);
                }
                this.deliverHasException(muxableSocket, (Throwable)socketResetException);
            }
            catch (Throwable throwable) {
                if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block14;
                throwable.printStackTrace();
            }
        }
        this.readCompleted(muxableSocket);
        if (n == -1) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug((String)("EOF on socket: " + muxableSocket.getSocketInfo()));
            }
            this.deliverEndOfStream(muxableSocket);
            return false;
        }
        if (muxableSocket.isMessageComplete()) {
            socketInfo.messageCompleted();
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug((String)("dispatch " + socketInfo));
            }
        } else {
            socketInfo.messageInitiated();
            return true;
        }
        muxableSocket.dispatch();
        return false;
    }

    protected int readFromSocket(MuxableSocket muxableSocket) throws IOException {
        byte[] byArray = muxableSocket.getBuffer();
        int n = muxableSocket.getBufferOffset();
        int n2 = byArray.length - n;
        int n3 = 0;
        InputStream inputStream = muxableSocket.getSocketInputStream();
        if (inputStream == null) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug((String)("Socket has been closed and cleanedup: " + muxableSocket + " will return EOS from read"));
            }
            return -1;
        }
        n3 = inputStream.read(byArray, n, n2);
        if (n3 > 0) {
            muxableSocket.incrementBufferOffset(n3);
        }
        return n3;
    }

    protected void handleReadTimeout(MuxableSocket muxableSocket) {
        this.read(muxableSocket);
    }

    protected void readCompleted(MuxableSocket muxableSocket) {
    }

    public final void write(AsyncOutputStream asyncOutputStream) {
        this.internalWrite(asyncOutputStream);
    }

    protected void internalWrite(AsyncOutputStream asyncOutputStream) {
        OutputStream outputStream = asyncOutputStream.getOutputStream();
        Chunk chunk = null;
        while (outputStream != null && (chunk = asyncOutputStream.getOutputBuffer()) != null) {
            try {
                outputStream.write(chunk.buf, 0, chunk.end);
                asyncOutputStream.handleWrite(chunk);
            }
            catch (IOException iOException) {
                asyncOutputStream.handleException(iOException);
                return;
            }
        }
    }

    protected TimerListener createTimeoutTrigger() {
        return new TimerListenerImpl();
    }

    static /* synthetic */ SocketMuxer access$000() {
        return SocketMuxer.makeTheMuxer();
    }

    protected class TimerListenerImpl
    implements TimerListener {
        protected TimerListenerImpl() {
        }

        public void timerExpired(Timer timer) {
            Iterator<MuxableSocket> iterator = SocketMuxer.this.getSocketsIterator();
            block6: while (iterator.hasNext()) {
                int n;
                MuxableSocket muxableSocket = iterator.next();
                SocketInfo socketInfo = muxableSocket.getSocketInfo();
                if (socketInfo == null) continue;
                long l = muxableSocket.getIdleTimeoutMillis();
                long l2 = muxableSocket.getCompleteMessageTimeoutMillis();
                switch (socketInfo.checkTimeout(l, l2)) {
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        if (!muxableSocket.getSocket().isClosed()) continue block6;
                        SocketMuxer.this.cleanupSocket(muxableSocket, socketInfo);
                        continue block6;
                    }
                    case 16: {
                        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerTimeout())) {
                            SocketLogger.logDebug((String)("Timeout on socket: '" + muxableSocket + "', sockInfo: " + muxableSocket.getSocketInfo() + ", timeout of: '" + l / 1000L + " s"));
                        }
                        if (muxableSocket.timeout()) break;
                        continue block6;
                    }
                    case 32: {
                        if (!Kernel.isServer()) continue block6;
                        String string = "A complete message could not be read on socket: '" + muxableSocket + "', in the configured timeout period of '" + l2 / 1000L + "' secs";
                        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerTimeout())) {
                            SocketLogger.logDebug((String)(string + ", sockInfo=" + muxableSocket.getSocketInfo()));
                        }
                        muxableSocket.hasException((Throwable)new IOException(string));
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                if ((n = socketInfo.exceptionHandlingCompleted()) == 0) {
                    SocketMuxer.this.cleanupSocket(muxableSocket, socketInfo);
                    continue;
                }
                if (n != 4) continue;
                SocketMuxer.this.cancelIo(muxableSocket);
            }
        }
    }

    protected static final class SingletonMaker {
        protected static final SocketMuxer singleton = SocketMuxer.access$000();

        protected SingletonMaker() {
        }
    }
}

