/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import weblogic.socket.SocketMuxer;

public final class WeblogicServerSocket
extends ServerSocket {
    private final ServerSocket serverSocket;
    private final boolean nio;

    public WeblogicServerSocket(ServerSocket serverSocket, boolean bl) throws IOException {
        this.serverSocket = serverSocket;
        this.nio = bl;
    }

    public Socket accept() throws IOException {
        Socket socket;
        if (this.nio) {
            SocketChannel socketChannel = this.serverSocket.getChannel().accept();
            socketChannel.configureBlocking(false);
            socket = socketChannel.socket();
        } else {
            ServerSocketChannel serverSocketChannel = this.serverSocket.getChannel();
            socket = serverSocketChannel != null ? serverSocketChannel.accept().socket() : this.serverSocket.accept();
        }
        return SocketMuxer.getMuxer().newWeblogicSocket(socket);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.serverSocket.bind(socketAddress);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.serverSocket.bind(socketAddress, n);
    }

    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }

    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.serverSocket.setSoTimeout(n);
    }

    public int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.serverSocket.setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    public String toString() {
        return this.serverSocket.toString();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.serverSocket.setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }
}

