/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import weblogic.socket.utils.QueueDef;
import weblogic.socket.utils.QueueFullException;

public final class DynaQueue
implements QueueDef {
    private static final boolean DEBUG = false;
    private boolean verbose = false;
    private Object[] q;
    private int count = 0;
    private int getPos = 0;
    private int putPos = 0;
    private Object[] qput;
    private Object[] qlast;
    private int blockCount = 0;
    private int maxBlockCount = 0;
    private int blockSize = 256;
    private boolean cancelled = false;
    private String name = "(unknown)";
    private int departures = 0;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String toString() {
        return this.name;
    }

    public DynaQueue(String string, int n) {
        this.q = new Object[n + 1];
        this.name = string;
        this.blockSize = n;
        this.qlast = this.q;
        this.qput = this.q;
        this.q[n] = this.q;
        this.blockCount = 1;
        this.resize(1);
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.maxBlockCount == 0 ? Integer.MAX_VALUE : this.maxBlockCount * this.blockSize;
    }

    public int departures() {
        return this.departures;
    }

    public synchronized void put(Object object) throws QueueFullException {
        if (this.putPos == this.blockSize) {
            if (this.qput == this.qlast) {
                if (this.blockCount == this.maxBlockCount) {
                    throw new QueueFullException();
                }
                this.resize(1);
            }
            this.qput = (Object[])this.qput[this.blockSize];
            this.putPos = 0;
        }
        ++this.count;
        this.qput[this.putPos++] = object;
        this.notify();
    }

    private final boolean full() {
        return this.blockCount == this.maxBlockCount && this.putPos == this.blockSize;
    }

    public synchronized void putW(Object object) {
        while (this.full() && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.full()) {
            try {
                this.put(object);
            }
            catch (QueueFullException queueFullException) {
                // empty catch block
            }
            return;
        }
        if (this.cancelled) {
            if (!this.full()) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
            return;
        }
        throw new AssertionError((Object)("Queue invariant failed count=" + this.count + "; cancel = " + this.cancelled));
    }

    public synchronized void cancelWait() {
        this.cancelled = true;
        this.notifyAll();
    }

    public void resetCancel() {
        this.cancelled = false;
    }

    public synchronized boolean empty() {
        return this.count == 0;
    }

    public Object peek() {
        if (this.count <= 0) {
            return null;
        }
        return this.q[this.getPos];
    }

    public synchronized Object get() {
        Object object = null;
        if (this.count <= 0) {
            return null;
        }
        --this.count;
        object = this.q[this.getPos];
        this.q[this.getPos] = null;
        if (++this.getPos == this.blockSize) {
            if (this.qput == this.q) {
                this.qput = (Object[])this.q[this.blockSize];
                this.putPos = 0;
            }
            if (this.count >= (this.blockCount - 2) * this.blockSize) {
                this.qlast = this.q;
                this.q = (Object[])this.q[this.blockSize];
            } else {
                --this.blockCount;
                Object[] objectArray = this.q;
                this.q = (Object[])objectArray[this.blockSize];
                objectArray[this.blockSize] = null;
                this.qlast[this.blockSize] = this.q;
            }
            this.getPos = 0;
        }
        ++this.departures;
        return object;
    }

    public synchronized Object getW() {
        while (this.count <= 0 && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.count > 0) {
            return this.get();
        }
        if (this.cancelled) {
            if (this.count != 0) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
            return null;
        }
        throw new AssertionError((Object)("Queue invarient failed count=" + this.count + "; cancel = " + this.cancelled));
    }

    public synchronized Object getW(int n) {
        long l;
        long l2 = System.currentTimeMillis();
        long l3 = n;
        while (this.count <= 0 && !this.cancelled && (l3 -= (l = System.currentTimeMillis()) - l2) > 0L) {
            l2 = l;
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.count > 0) {
            return this.get();
        }
        if (this.cancelled) {
            if (this.count != 0) {
                System.out.println(this + "******!!!!!!!!!! QUEUE2 " + this.cancelled + " count = " + this.count);
            }
            this.cancelled = false;
        }
        return null;
    }

    public synchronized void resize(int n) {
        Object[] objectArray;
        this.blockCount += n;
        while (n > 0) {
            this.qlast[this.blockSize] = objectArray = new Object[this.blockSize + 1];
            objectArray[this.blockSize] = this.q;
            this.qlast = objectArray;
            --n;
        }
        while (n < 0) {
            objectArray = (Object[])this.qput[this.blockSize];
            this.qput[this.blockSize] = objectArray[this.blockSize];
            objectArray[this.blockSize] = null;
            ++n;
        }
    }
}

