/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import weblogic.socket.JSSEFilterImpl;
import weblogic.socket.JSSESocket;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketMuxer;

public final class JSSEUtils {
    public static JSSESocket getJSSESocket(SSLSocket sSLSocket) {
        if (sSLSocket instanceof JSSESocket) {
            return (JSSESocket)sSLSocket;
        }
        return null;
    }

    public static void registerJSSEFilter(JSSESocket jSSESocket, MuxableSocket muxableSocket) throws IOException {
        JSSEFilterImpl jSSEFilterImpl = jSSESocket.getFilter();
        muxableSocket.setSocketFilter((MuxableSocket)jSSEFilterImpl);
        jSSEFilterImpl.setDelegate(muxableSocket);
        SocketMuxer.getMuxer().register(jSSEFilterImpl);
    }

    public static void activate(JSSESocket jSSESocket, MuxableSocket muxableSocket) throws IOException {
        try {
            jSSESocket.startHandshake();
        }
        catch (IOException iOException) {
            if (!jSSESocket.isClosed()) {
                try {
                    jSSESocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
        if (muxableSocket.isMessageComplete()) {
            muxableSocket.dispatch();
        } else {
            SocketMuxer.getMuxer().read(jSSESocket.getFilter());
        }
    }
}

