/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.StringTokenizer;
import weblogic.common.ProxyAuthenticator;
import weblogic.kernel.KernelStatus;
import weblogic.socket.SocketMuxer;
import weblogic.socket.utils.RegexpPool;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Encoder;

public final class ProxyUtils {
    private static final int MAX_TRIES = 3;
    private static String proxyHost = null;
    private static int proxyPort = -1;
    private static String SSLProxyHost = null;
    private static int SSLProxyPort = -1;
    private static String proxyAuthStr = null;
    private static String proxyAuthClassName;
    private static RegexpPool sslDontProxy;
    private static RegexpPool dontProxy;

    public static InetAddress getProxyHost() throws UnknownHostException {
        return InetAddress.getByName(proxyHost);
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static InetAddress getSSLProxyHost() throws UnknownHostException {
        return InetAddress.getByName(SSLProxyHost);
    }

    public static int getSSLProxyPort() {
        return SSLProxyPort;
    }

    public static String getProxyAuthStr() {
        return proxyAuthStr;
    }

    public static String getProxyAuthClassName() {
        return proxyAuthClassName;
    }

    public static RegexpPool getSSLDontProxy() {
        return sslDontProxy;
    }

    public static RegexpPool getDontProxy() {
        return dontProxy;
    }

    public static void resetSSLProperties() {
        try {
            String string;
            try {
                string = System.getProperty("https.proxyPort");
                if (string == null) {
                    string = System.getProperty("ssl.proxyPort");
                }
                if (string == null) {
                    return;
                }
                SSLProxyPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            SSLProxyHost = System.getProperty("https.proxyHost");
            if (SSLProxyHost == null) {
                SSLProxyHost = System.getProperty("ssl.proxyHost");
            }
            if ((string = System.getProperty("https.nonProxyHosts")) != null) {
                sslDontProxy = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    if (sslDontProxy.add(stringTokenizer.nextToken().toLowerCase(Locale.ENGLISH))) continue;
                }
            }
        }
        catch (SecurityException securityException) {
            SSLProxyPort = -1;
            SSLProxyHost = null;
        }
    }

    public static synchronized void resetProperties() {
        try {
            String string;
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = Integer.getInteger("http.proxyPort", 80);
            if (proxyHost == null) {
                proxyHost = System.getProperty("proxyHost");
                proxyPort = Integer.getInteger("proxyPort", 80);
            }
            if (proxyHost != null && proxyHost.length() == 0) {
                proxyHost = null;
            }
            if ((string = System.getProperty("http.nonProxyHosts")) == null) {
                string = System.getProperty("nonProxyHosts");
            }
            if (string != null) {
                dontProxy = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    if (dontProxy.add(stringTokenizer.nextToken().toLowerCase())) continue;
                }
            }
        }
        catch (SecurityException securityException) {
            proxyHost = null;
            proxyPort = 80;
        }
    }

    public static Socket getProxySocket(Socket socket, String string, int n, String string2, int n2) throws IOException {
        String string3;
        int n3 = 0;
        while (true) {
            String string4;
            socket.setTcpNoDelay(true);
            String string5 = null;
            string5 = proxyAuthStr == null ? "CONNECT " + string + ':' + n + " HTTP/1.0\r\n\r\n" : "CONNECT " + string + ':' + n + " HTTP/1.0\r\n" + proxyAuthStr + "\r\n\r\n";
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(string5.getBytes());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            string3 = dataInputStream.readLine();
            if (string3 == null) {
                socket.close();
                throw new ProtocolException("Empty or no response from proxy");
            }
            String[] stringArray = StringUtils.splitCompletely((String)string3);
            if (stringArray.length < 2 || !stringArray[0].equals("HTTP/1.0") && !stringArray[0].equals("HTTP/1.1")) continue;
            if (stringArray[1].equals("200")) {
                while ((string3 = dataInputStream.readLine()) != null && string3.length() > 0) {
                }
                return socket;
            }
            if (!stringArray[1].equals("407")) break;
            if (n3 > 3) {
                throw new ProtocolException("Server redirected too many times (" + n3 + ")");
            }
            while ((string4 = dataInputStream.readLine()) != null && string4.length() > 0) {
                String[] stringArray2 = StringUtils.split((String)string4, (char)':');
                if (!stringArray2[0].equalsIgnoreCase("Proxy-Authenticate")) continue;
                proxyAuthStr = ProxyUtils.getAuthInfo(string2, n2, stringArray2[1]);
                if (proxyAuthStr == null) {
                    throw new ProtocolException("Proxy Authentication required (407)");
                }
                proxyAuthStr = "Proxy-Authorization: " + proxyAuthStr;
            }
            ++n3;
        }
        socket.close();
        throw new ProtocolException("unrecognized response from proxy: '" + string3 + "'");
    }

    public static Socket getClientProxy(String string, int n, int n2) throws IOException {
        Socket socket = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(proxyHost), proxyPort, n2);
        return ProxyUtils.getProxySocket(socket, string, n, proxyHost, proxyPort);
    }

    public static Socket getSSLClientProxy(String string, int n, int n2) throws IOException {
        Socket socket = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(SSLProxyHost), SSLProxyPort, n2);
        return ProxyUtils.getProxySocket(socket, string, n, SSLProxyHost, SSLProxyPort);
    }

    public static Socket getSSLClientProxy(String string, int n, String string2, int n2, int n3) throws IOException {
        Socket socket = SocketMuxer.getMuxer().newSocket(InetAddress.getByName(SSLProxyHost), SSLProxyPort, InetAddress.getByName(string2), n2, n3);
        return ProxyUtils.getProxySocket(socket, string, n, SSLProxyHost, SSLProxyPort);
    }

    public static boolean canProxy(InetAddress inetAddress, boolean bl) {
        String string = inetAddress.getHostName().toLowerCase();
        if (bl) {
            if (SSLProxyHost == null) {
                return false;
            }
            if (SSLProxyHost.equals(string) || SSLProxyHost.equals(inetAddress.getHostAddress())) {
                return false;
            }
            if (sslDontProxy == null) {
                return true;
            }
            return !sslDontProxy.match(string);
        }
        if (proxyHost == null) {
            return false;
        }
        if (proxyHost.equals(string) || proxyHost.equals(inetAddress.getHostAddress())) {
            return false;
        }
        if (dontProxy == null) {
            return true;
        }
        return !dontProxy.match(string);
    }

    public static String getAuthInfo(String string, int n, String string2) throws IOException {
        if (proxyAuthClassName == null || string2 == null) {
            throw new ProtocolException("Proxy or Server Authentication Required");
        }
        ProxyAuthenticator proxyAuthenticator = null;
        String string3 = null;
        String string4 = null;
        String string5 = string2.trim();
        int n2 = string5.indexOf(32);
        if (n2 == -1) {
            string3 = string5;
            string4 = "Login to Proxy";
        } else {
            string3 = string5.substring(0, n2);
            string4 = string5.substring(n2 + 1);
            if ((n2 = string4.indexOf(61)) != -1) {
                string4 = string4.substring(n2 + 1);
            }
        }
        try {
            proxyAuthenticator = (ProxyAuthenticator)Class.forName(proxyAuthClassName).newInstance();
        }
        catch (Exception exception) {
            throw new ProtocolException("Proxy authenticator " + proxyAuthClassName + " failed: " + exception);
        }
        proxyAuthenticator.init(string, n, string3, string4);
        String[] stringArray = proxyAuthenticator.getLoginAndPassword();
        if (stringArray == null || stringArray.length != 2) {
            throw new ProtocolException("Proxy authentication failed");
        }
        String string6 = stringArray[0] + ':' + stringArray[1];
        byte[] byArray = string6.getBytes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string7 = "Basic " + bASE64Encoder.encodeBuffer(byArray);
        return string7;
    }

    static {
        if (!KernelStatus.isApplet()) {
            ProxyUtils.resetSSLProperties();
            ProxyUtils.resetProperties();
            proxyAuthClassName = System.getProperty("weblogic.net.proxyAuthenticatorClassName");
        }
    }
}

