/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.util.ArrayList;
import java.util.HashMap;

public class RegexpPool {
    private static final String STAR = "*";
    private boolean matchAll = false;
    private ArrayList prefixes = null;
    private ArrayList suffixes = null;
    private HashMap strings = null;

    public boolean add(String string) {
        if (string == null) {
            throw new NullPointerException("null expression string");
        }
        boolean bl = false;
        if (string.equals(STAR)) {
            bl = this.matchAll;
            this.matchAll = true;
        } else if (string.startsWith(STAR)) {
            String string2 = string.substring(1);
            if (this.suffixes == null) {
                this.suffixes = new ArrayList();
            } else {
                bl = this.suffixes.contains(string2);
            }
            if (!bl) {
                this.suffixes.add(string2);
            }
        } else if (string.endsWith(STAR)) {
            String string3 = string.substring(0, string.length() - 1);
            if (this.prefixes == null) {
                this.prefixes = new ArrayList();
            } else {
                bl = this.prefixes.contains(string3);
            }
            if (!bl) {
                this.prefixes.add(string3);
            }
        } else {
            if (this.strings == null) {
                this.strings = new HashMap();
            }
            bl = this.strings.put(string, string) != null;
        }
        return !bl;
    }

    public boolean remove(String string) {
        if (string == null) {
            throw new NullPointerException("null expression string");
        }
        if (string.equals(STAR)) {
            boolean bl = this.matchAll;
            this.matchAll = false;
            return bl;
        }
        if (string.startsWith(STAR)) {
            return this.suffixes != null && this.suffixes.remove(string.substring(1));
        }
        if (string.endsWith(STAR)) {
            return this.prefixes != null && this.prefixes.remove(string.substring(0, string.length() - 1));
        }
        return this.strings.remove(string) != null;
    }

    public boolean match(String string) {
        int n;
        int n2;
        if (this.matchAll) {
            return true;
        }
        if (this.strings != null && this.strings.containsKey(string)) {
            return true;
        }
        if (this.suffixes != null) {
            n2 = this.suffixes.size();
            for (n = 0; n < n2; ++n) {
                if (!string.endsWith((String)this.suffixes.get(n))) continue;
                return true;
            }
        }
        if (this.prefixes != null) {
            n2 = this.prefixes.size();
            for (n = 0; n < n2; ++n) {
                if (!string.startsWith((String)this.prefixes.get(n))) continue;
                return true;
            }
        }
        return false;
    }
}

