/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket.utils;

import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class SDPSocketUtils {
    private static volatile Method sdpServerSocketMethod;
    private static volatile Method sdpSocketMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getSDPServerSocketChannelMethod() throws Exception {
        Class<?> clazz;
        if (sdpServerSocketMethod != null) {
            return sdpServerSocketMethod;
        }
        Class<?> clazz2 = clazz = Class.forName("com.oracle.net.Sdp");
        synchronized (clazz2) {
            if (sdpServerSocketMethod == null) {
                SDPSocketUtils.ensureEnvironment();
                sdpServerSocketMethod = clazz.getDeclaredMethod("openServerSocketChannel", null);
            }
        }
        return sdpServerSocketMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getSDPSocketChannelMethod() throws Exception {
        Class<?> clazz;
        if (sdpSocketMethod != null) {
            return sdpSocketMethod;
        }
        Class<?> clazz2 = clazz = Class.forName("com.oracle.net.Sdp");
        synchronized (clazz2) {
            if (sdpSocketMethod == null) {
                SDPSocketUtils.ensureEnvironment();
                sdpSocketMethod = clazz.getDeclaredMethod("openSocketChannel", null);
            }
        }
        return sdpSocketMethod;
    }

    public static Socket createSDPSocket() {
        try {
            Method method = SDPSocketUtils.getSDPSocketChannelMethod();
            SocketChannel socketChannel = (SocketChannel)method.invoke(null, null);
            return socketChannel.socket();
        }
        catch (Exception exception) {
            AssertionError assertionError = new AssertionError((Object)"Failed to create SDP Server Socket");
            ((Throwable)((Object)assertionError)).initCause(exception);
            throw assertionError;
        }
    }

    public static ServerSocket createSDPServerSocket() {
        try {
            Method method = SDPSocketUtils.getSDPServerSocketChannelMethod();
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)method.invoke(null, null);
            return serverSocketChannel.socket();
        }
        catch (Exception exception) {
            AssertionError assertionError = new AssertionError((Object)"Failed to create SDP Server Socket");
            ((Throwable)((Object)assertionError)).initCause(exception);
            throw assertionError;
        }
    }

    public static void ensureEnvironment() {
        if (!Boolean.getBoolean("java.net.preferIPv4Stack")) {
            throw new AssertionError((Object)"SDP protocol requires system property java.net.preferIPv4Stack to be set to true");
        }
    }
}

