/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import java.util.HashMap;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.management.runtime.SpringApplicationContextRuntimeMBean;
import weblogic.spring.SpringLogger;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;
import weblogic.spring.monitoring.utils.AbstractApplicationContextDelegator;

public class SpringApplicationContextRuntimeMBeanImpl
extends SpringBaseRuntimeMBeanImpl
implements SpringApplicationContextRuntimeMBean {
    private AbstractApplicationContextDelegator appCtxDelegator;
    private String parentContext;
    private long startupDate;
    private Object beanFactory;
    private long numberOfPrototypeBeansCreated;
    private double elapsedTimesPrototypeBeanCreation;
    private long numberOfSingletonBeansCreated;
    private double elapsedTimesSingletonBeanCreation;
    private long refreshCount;
    private long refreshFailedCount;
    private double elapsedTimesRefresh;
    private double elapsedTimesGetBean;
    private long getBeanExecutions;
    private long getBeanFailedExecutions;
    private double elapsedTimesGetBeansOfType;
    private long getBeansOfTypeExecutions;
    private long getBeansOfTypeFailedExecutions;
    private double elapsedTimesGetBeanNamesForType;
    private long getBeanNamesForTypeExecutions;
    private long getBeanNamesForTypeFailedExecutions;
    private HashMap<String, CustomScopeInfo> customScopes;

    public SpringApplicationContextRuntimeMBeanImpl(String string, Object object) throws ManagementException {
        super(object, object, string, false);
        this.appCtxDelegator = new AbstractApplicationContextDelegator(object);
        this.parentContext = this.appCtxDelegator.getParentContext();
        this.startupDate = this.appCtxDelegator.getStartupDate();
        this.beanFactory = this.appCtxDelegator.getBeanFactory();
        this.customScopes = new HashMap();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl(" + string + ")");
        }
    }

    public String getDisplayName() {
        return this.getApplicationContextDisplayName();
    }

    public String getParentContext() {
        return this.parentContext;
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public Object getBeanFactory() {
        return this.beanFactory;
    }

    public synchronized double getAveragePrototypeBeanCreationTime() {
        return this.numberOfPrototypeBeansCreated == 0L ? 0.0 : this.elapsedTimesPrototypeBeanCreation / 1000000.0 / (double)this.numberOfPrototypeBeansCreated;
    }

    public synchronized long getPrototypeBeansCreatedCount() {
        return this.numberOfPrototypeBeansCreated;
    }

    public synchronized double getAverageSingletonBeanCreationTime() {
        return this.numberOfSingletonBeansCreated == 0L ? 0.0 : this.elapsedTimesSingletonBeanCreation / 1000000.0 / (double)this.numberOfSingletonBeansCreated;
    }

    public synchronized long getSingletonBeansCreatedCount() {
        return this.numberOfSingletonBeansCreated;
    }

    public String[] getCustomScopeNames() {
        if (this.customScopes == null || this.customScopes.isEmpty()) {
            return null;
        }
        Set<String> set = this.customScopes.keySet();
        return set.toArray(new String[set.size()]);
    }

    public double getAverageCustomScopeBeanCreationTime(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(SpringLogger.getUnregisteredScopeName((String)string));
        }
        CustomScopeInfo customScopeInfo = this.customScopes.get(string);
        if (customScopeInfo != null) {
            return customScopeInfo.numberOfCustomScopeBeansCreated == 0L ? 0.0 : customScopeInfo.elapsedTimesCustomScopeBeanCreation / 1000000.0 / (double)customScopeInfo.numberOfCustomScopeBeansCreated;
        }
        throw new IllegalArgumentException(SpringLogger.getUnregisteredScopeName((String)string));
    }

    public long getCustomScopeBeansCreatedCount(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(SpringLogger.getUnregisteredScopeName((String)string));
        }
        CustomScopeInfo customScopeInfo = this.customScopes.get(string);
        if (customScopeInfo != null) {
            return customScopeInfo.numberOfCustomScopeBeansCreated;
        }
        throw new IllegalArgumentException(SpringLogger.getUnregisteredScopeName((String)string));
    }

    public synchronized double getAverageRefreshTime() {
        return this.refreshCount == 0L ? 0.0 : this.elapsedTimesRefresh / 1000000.0 / (double)this.refreshCount;
    }

    public synchronized long getRefreshCount() {
        return this.refreshCount;
    }

    public synchronized long getRefreshFailedCount() {
        return this.refreshFailedCount;
    }

    public synchronized double getAverageGetBeanTime() {
        return this.getBeanExecutions == 0L ? 0.0 : this.elapsedTimesGetBean / 1000000.0 / (double)this.getBeanExecutions;
    }

    public synchronized long getGetBeanCount() {
        return this.getBeanExecutions;
    }

    public synchronized long getGetBeanFailedCount() {
        return this.getBeanFailedExecutions;
    }

    public synchronized double getAverageGetBeansOfTypeTime() {
        return this.getBeansOfTypeExecutions == 0L ? 0.0 : this.elapsedTimesGetBeansOfType / 1000000.0 / (double)this.getBeansOfTypeExecutions;
    }

    public synchronized long getGetBeansOfTypeCount() {
        return this.getBeansOfTypeExecutions;
    }

    public synchronized long getGetBeansOfTypeFailedCount() {
        return this.getBeansOfTypeFailedExecutions;
    }

    public synchronized double getAverageGetBeanNamesForTypeTime() {
        return this.getBeanNamesForTypeExecutions == 0L ? 0.0 : this.elapsedTimesGetBeanNamesForType / 1000000.0 / (double)this.getBeanNamesForTypeExecutions;
    }

    public synchronized long getGetBeanNamesForTypeCount() {
        return this.getBeanNamesForTypeExecutions;
    }

    public synchronized long getGetBeanNamesForTypeFailedCount() {
        return this.getBeanNamesForTypeFailedExecutions;
    }

    public synchronized void addPrototypeBeanCreation(long l) {
        ++this.numberOfPrototypeBeansCreated;
        this.elapsedTimesPrototypeBeanCreation += (double)l;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addPrototypeBeanCreation() : " + this.name);
        }
    }

    public synchronized void addSingletonBeanCreation(long l) {
        ++this.numberOfSingletonBeansCreated;
        this.elapsedTimesSingletonBeanCreation += (double)l;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addSingletonBeanCreation() : " + this.name);
        }
    }

    public synchronized void addCustomScope(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addCustomScope(" + string + ") : " + this.name);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        CustomScopeInfo customScopeInfo = this.customScopes.get(string);
        if (customScopeInfo == null) {
            customScopeInfo = new CustomScopeInfo();
            this.customScopes.put(string, customScopeInfo);
        }
    }

    public synchronized void addCustomScopeBeanCreation(String string, long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addCustomScopeBeanCreation(" + string + ") : " + this.name);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        CustomScopeInfo customScopeInfo = this.customScopes.get(string);
        if (customScopeInfo == null) {
            customScopeInfo = new CustomScopeInfo();
            this.customScopes.put(string, customScopeInfo);
        }
        ++customScopeInfo.numberOfCustomScopeBeansCreated;
        customScopeInfo.elapsedTimesCustomScopeBeanCreation += (double)l;
    }

    public synchronized void addRefresh(boolean bl, long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addRefresh() : " + this.name);
        }
        ++this.refreshCount;
        if (!bl) {
            ++this.refreshFailedCount;
        }
        this.elapsedTimesRefresh += (double)l;
    }

    public synchronized void addGetBeanExecution(boolean bl, long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addGetBeanExecution() : " + this.name);
        }
        ++this.getBeanExecutions;
        if (!bl) {
            ++this.getBeanFailedExecutions;
        }
        this.elapsedTimesGetBean += (double)l;
    }

    public synchronized void addGetBeansOfTypeExecution(boolean bl, long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addGetBeansOfTypeExecution() : " + this.name);
        }
        ++this.getBeansOfTypeExecutions;
        if (!bl) {
            ++this.getBeansOfTypeFailedExecutions;
        }
        this.elapsedTimesGetBeansOfType += (double)l;
    }

    public synchronized void addGetBeanNamesForTypeExecution(boolean bl, long l) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.addGetBeanNamesForTypeExecution() : " + this.name);
        }
        ++this.getBeanNamesForTypeExecutions;
        if (!bl) {
            ++this.getBeanNamesForTypeFailedExecutions;
        }
        this.elapsedTimesGetBeanNamesForType += (double)l;
    }

    public synchronized void updateBeanFactory() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringApplicationContextRuntimeMBeanImpl.resetBeanFactoryStats() : " + this.name);
        }
        this.beanFactory = this.appCtxDelegator.getBeanFactory();
        this.numberOfPrototypeBeansCreated = 0L;
        this.elapsedTimesPrototypeBeanCreation = 0.0;
        this.numberOfSingletonBeansCreated = 0L;
        this.elapsedTimesSingletonBeanCreation = 0.0;
        this.elapsedTimesGetBean = 0.0;
        this.getBeanExecutions = 0L;
        this.getBeanFailedExecutions = 0L;
        this.elapsedTimesGetBeansOfType = 0.0;
        this.getBeansOfTypeExecutions = 0L;
        this.getBeansOfTypeFailedExecutions = 0L;
        this.elapsedTimesGetBeanNamesForType = 0.0;
        this.getBeanNamesForTypeExecutions = 0L;
        this.getBeanNamesForTypeFailedExecutions = 0L;
        if (this.customScopes != null) {
            this.customScopes.clear();
            this.customScopes = null;
        }
    }

    private static class CustomScopeInfo {
        public long numberOfCustomScopeBeansCreated;
        public double elapsedTimesCustomScopeBeanCreation;

        private CustomScopeInfo() {
        }
    }
}

