/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SpringApplicationContextRuntimeMBean;
import weblogic.management.runtime.SpringBeanDefinitionRuntimeMBean;
import weblogic.management.runtime.SpringRuntimeMBean;
import weblogic.management.runtime.SpringTransactionManagerRuntimeMBean;
import weblogic.management.runtime.SpringTransactionTemplateRuntimeMBean;
import weblogic.management.runtime.SpringViewResolverRuntimeMBean;
import weblogic.management.runtime.SpringViewRuntimeMBean;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;

public class SpringRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements SpringRuntimeMBean {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugSpringStatistics");
    private String version;
    private SpringBeanDefinitionRuntimeMBean[] springBeanDefinitionRuntiemMBeans;
    private ArrayList<SpringApplicationContextRuntimeMBean> springApplicationContextRuntimeMBeans;
    private ArrayList<SpringTransactionManagerRuntimeMBean> springTransactionManagerRuntimeMBeans;
    private ArrayList<SpringTransactionTemplateRuntimeMBean> springTransactionTemplateRuntimeMBeans;
    private ArrayList<SpringViewRuntimeMBean> springViewRuntimeMBeans;
    private ArrayList<SpringViewResolverRuntimeMBean> springViewResolverRuntimeMBeans;

    public SpringRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean);
    }

    public void setSpringVersion(String string) {
        this.version = string;
    }

    public String getSpringVersion() {
        return this.version;
    }

    public void setSpringBeanDefinitionRuntimeMBeans(SpringBeanDefinitionRuntimeMBean[] springBeanDefinitionRuntimeMBeanArray) {
        this.springBeanDefinitionRuntiemMBeans = springBeanDefinitionRuntimeMBeanArray;
    }

    public SpringBeanDefinitionRuntimeMBean[] getSpringBeanDefinitionRuntimeMBeans() {
        return this.springBeanDefinitionRuntiemMBeans;
    }

    public void unregister() throws ManagementException {
        super.unregister();
    }

    public SpringApplicationContextRuntimeMBean[] getSpringApplicationContextRuntimeMBeans() {
        return this.springApplicationContextRuntimeMBeans == null ? null : this.springApplicationContextRuntimeMBeans.toArray(new SpringApplicationContextRuntimeMBean[this.springApplicationContextRuntimeMBeans.size()]);
    }

    public SpringTransactionManagerRuntimeMBean[] getSpringTransactionManagerRuntimeMBeans() {
        return this.springTransactionManagerRuntimeMBeans == null ? null : this.springTransactionManagerRuntimeMBeans.toArray(new SpringTransactionManagerRuntimeMBean[this.springTransactionManagerRuntimeMBeans.size()]);
    }

    public SpringTransactionTemplateRuntimeMBean[] getSpringTransactionTemplateRuntimeMBeans() {
        return this.springTransactionTemplateRuntimeMBeans == null ? null : this.springTransactionTemplateRuntimeMBeans.toArray(new SpringTransactionTemplateRuntimeMBean[this.springTransactionTemplateRuntimeMBeans.size()]);
    }

    public SpringViewResolverRuntimeMBean[] getSpringViewResolverRuntimeMBeans() {
        return this.springViewResolverRuntimeMBeans == null ? null : this.springViewResolverRuntimeMBeans.toArray(new SpringViewResolverRuntimeMBean[this.springViewResolverRuntimeMBeans.size()]);
    }

    public SpringViewRuntimeMBean[] getSpringViewRuntimeMBeans() {
        return this.springViewRuntimeMBeans == null ? null : this.springViewRuntimeMBeans.toArray(new SpringViewRuntimeMBean[this.springViewRuntimeMBeans.size()]);
    }

    public void addSpringApplicationContextRuntimeMBean(SpringApplicationContextRuntimeMBean springApplicationContextRuntimeMBean) {
        if (this.springApplicationContextRuntimeMBeans == null) {
            this.springApplicationContextRuntimeMBeans = new ArrayList();
        }
        this.springApplicationContextRuntimeMBeans.add(springApplicationContextRuntimeMBean);
    }

    public void addSpringTransactionManagerRuntimeMBean(SpringTransactionManagerRuntimeMBean springTransactionManagerRuntimeMBean) {
        if (this.springTransactionManagerRuntimeMBeans == null) {
            this.springTransactionManagerRuntimeMBeans = new ArrayList();
        }
        this.springTransactionManagerRuntimeMBeans.add(springTransactionManagerRuntimeMBean);
    }

    public void addSpringTransactionTemplateRuntimeMBean(SpringTransactionTemplateRuntimeMBean springTransactionTemplateRuntimeMBean) {
        if (this.springTransactionTemplateRuntimeMBeans == null) {
            this.springTransactionTemplateRuntimeMBeans = new ArrayList();
        }
        this.springTransactionTemplateRuntimeMBeans.add(springTransactionTemplateRuntimeMBean);
    }

    public void addSpringViewResolverRuntimeMBean(SpringViewResolverRuntimeMBean springViewResolverRuntimeMBean) {
        if (this.springViewResolverRuntimeMBeans == null) {
            this.springViewResolverRuntimeMBeans = new ArrayList();
        }
        this.springViewResolverRuntimeMBeans.add(springViewResolverRuntimeMBean);
    }

    public void addSpringViewRuntimeMBean(SpringViewRuntimeMBean springViewRuntimeMBean) {
        if (this.springViewRuntimeMBeans == null) {
            this.springViewRuntimeMBeans = new ArrayList();
        }
        this.springViewRuntimeMBeans.add(springViewRuntimeMBean);
    }

    public void removeSpringApplicationContextRuntimeMBean(SpringApplicationContextRuntimeMBean springApplicationContextRuntimeMBean) {
        if (this.springApplicationContextRuntimeMBeans != null) {
            this.springApplicationContextRuntimeMBeans.remove(springApplicationContextRuntimeMBean);
        }
    }

    public void removeSpringTransactionManagerRuntimeMBean(SpringTransactionManagerRuntimeMBean springTransactionManagerRuntimeMBean) {
        if (this.springTransactionManagerRuntimeMBeans != null) {
            this.springTransactionManagerRuntimeMBeans.remove(springTransactionManagerRuntimeMBean);
        }
    }

    public void removeSpringTransactionTemplateRuntimeMBean(SpringTransactionTemplateRuntimeMBean springTransactionTemplateRuntimeMBean) {
        if (this.springTransactionTemplateRuntimeMBeans != null) {
            this.springTransactionTemplateRuntimeMBeans.remove(springTransactionTemplateRuntimeMBean);
        }
    }

    public void removeSpringViewResolverRuntimeMBean(SpringViewResolverRuntimeMBean springViewResolverRuntimeMBean) {
        if (this.springViewResolverRuntimeMBeans != null) {
            this.springViewResolverRuntimeMBeans.remove(springViewResolverRuntimeMBean);
        }
    }

    public void removeSpringViewRuntimeMBean(SpringViewRuntimeMBean springViewRuntimeMBean) {
        if (this.springViewRuntimeMBeans != null) {
            this.springViewRuntimeMBeans.remove(springViewRuntimeMBean);
        }
    }

    public void removeRegisteredApplicationContextRuntimeMBeans(Object object) {
        this.removeRegisteredMBeans(object, this.springApplicationContextRuntimeMBeans);
    }

    public void removeRegisteredTransactionTemplateRuntimeMBeans(Object object) {
        this.removeRegisteredMBeans(object, this.springTransactionTemplateRuntimeMBeans);
    }

    public void removeRegisteredViewRuntimeMBeans(Object object) {
        this.removeRegisteredMBeans(object, this.springViewRuntimeMBeans);
    }

    public void removeRegisteredViewResolverRuntimeMBeans(Object object) {
        this.removeRegisteredMBeans(object, this.springViewResolverRuntimeMBeans);
    }

    public void removeRegisteredTransactionManagerRuntimeMBeans(Object object) {
        this.removeRegisteredMBeans(object, this.springTransactionManagerRuntimeMBeans);
    }

    private void removeRegisteredMBeans(Object object, ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            block6: {
                SpringBaseRuntimeMBeanImpl springBaseRuntimeMBeanImpl = (SpringBaseRuntimeMBeanImpl)iterator.next();
                if (object != null && (springBaseRuntimeMBeanImpl.getApplicationContext() == null || springBaseRuntimeMBeanImpl.getApplicationContext() != object)) {
                    if (!debugLogger.isDebugEnabled()) continue;
                    debugLogger.debug("SpringRuntimeMBeanImpl skip unregister for: " + springBaseRuntimeMBeanImpl.getName());
                    continue;
                }
                if (!springBaseRuntimeMBeanImpl.isRegistered()) continue;
                try {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("SpringRuntimeMBeanImpl unregister: " + springBaseRuntimeMBeanImpl.getName());
                    }
                    springBaseRuntimeMBeanImpl.unregister();
                }
                catch (ManagementException managementException) {
                    if (!debugLogger.isDebugEnabled()) break block6;
                    debugLogger.debug("removeRegisteredMBeans ignoring", (Throwable)managementException);
                }
            }
            iterator.remove();
        }
    }
}

