/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import weblogic.management.ManagementException;
import weblogic.management.runtime.SpringTransactionManagerRuntimeMBean;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;

public class SpringTransactionManagerRuntimeMBeanImpl
extends SpringBaseRuntimeMBeanImpl
implements SpringTransactionManagerRuntimeMBean {
    private long rollbackCount;
    private long commitCount;
    private long resumeCount;
    private long suspendCount;
    private long failedRollbacks;
    private long failedCommits;
    private long failedResumes;
    private long failedSuspends;

    public SpringTransactionManagerRuntimeMBeanImpl(Object object, String string, Object object2) throws ManagementException {
        super(object, object2, string, false);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionManagerRuntimeMBeanImpl(" + string + ")");
        }
    }

    public synchronized long getRollbackCount() {
        return this.rollbackCount;
    }

    public synchronized long getCommitCount() {
        return this.commitCount;
    }

    public synchronized long getResumeCount() {
        return this.resumeCount;
    }

    public synchronized long getSuspendCount() {
        return this.suspendCount;
    }

    public synchronized long getRollbackFailedCount() {
        return this.failedRollbacks;
    }

    public synchronized long getCommitFailedCount() {
        return this.failedCommits;
    }

    public synchronized long getResumeFailedCount() {
        return this.failedResumes;
    }

    public synchronized long getSuspendFailedCount() {
        return this.failedSuspends;
    }

    public synchronized void addRollback(boolean bl) {
        ++this.rollbackCount;
        if (!bl) {
            ++this.failedRollbacks;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionManagerRuntimeMBeanImpl.addRollback() : " + this.name);
        }
    }

    public synchronized void addCommit(boolean bl) {
        ++this.commitCount;
        if (!bl) {
            ++this.failedCommits;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionManagerRuntimeMBeanImpl.addCommit() : " + this.name);
        }
    }

    public synchronized void addResume(boolean bl) {
        ++this.resumeCount;
        if (!bl) {
            ++this.failedResumes;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionManagerRuntimeMBeanImpl.addResume() : " + this.name);
        }
    }

    public synchronized void addSuspend(boolean bl) {
        ++this.suspendCount;
        if (!bl) {
            ++this.failedSuspends;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionManagerRuntimeMBeanImpl.addSuspend() : " + this.name);
        }
    }
}

