/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import weblogic.management.ManagementException;
import weblogic.management.runtime.SpringTransactionTemplateRuntimeMBean;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;

public class SpringTransactionTemplateRuntimeMBeanImpl
extends SpringBaseRuntimeMBeanImpl
implements SpringTransactionTemplateRuntimeMBean {
    private long executions;
    private long failedExecutions;
    private double elapsedTimes;

    public SpringTransactionTemplateRuntimeMBeanImpl(Object object, String string, Object object2) throws ManagementException {
        super(object, object2, string, false);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionTemplateRuntimeMBeanImpl(" + string + ")");
        }
    }

    public synchronized long getExecuteCount() {
        return this.executions;
    }

    public synchronized long getExecuteFailedCount() {
        return this.failedExecutions;
    }

    public synchronized double getAverageExecuteTime() {
        return this.executions == 0L ? 0.0 : this.elapsedTimes / 1000000.0 / (double)this.executions;
    }

    public synchronized void addExecute(boolean bl, long l) {
        ++this.executions;
        if (!bl) {
            ++this.failedExecutions;
        }
        this.elapsedTimes += (double)l;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringTransactionTemplateRuntimeMBeanImpl.addExecute() : " + this.name);
        }
    }
}

