/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import weblogic.management.ManagementException;
import weblogic.management.runtime.SpringViewResolverRuntimeMBean;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;

public class SpringViewResolverRuntimeMBeanImpl
extends SpringBaseRuntimeMBeanImpl
implements SpringViewResolverRuntimeMBean {
    private long viewResolveCount;
    private long failedViewResolves;
    private double elapsedTimes;

    public SpringViewResolverRuntimeMBeanImpl(Object object, String string, Object object2) throws ManagementException {
        super(object, object2, string, false);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringViewResolverRuntimeMBeanImpl(" + string + ")");
        }
    }

    public synchronized long getResolveViewNameCount() {
        return this.viewResolveCount;
    }

    public synchronized long getResolveViewNameFailedCount() {
        return this.failedViewResolves;
    }

    public synchronized double getAverageResolveViewNameTime() {
        return this.viewResolveCount == 0L ? 0.0 : this.elapsedTimes / 1000000.0 / (double)this.viewResolveCount;
    }

    public synchronized void addViewResolved(boolean bl, long l) {
        ++this.viewResolveCount;
        if (!bl) {
            ++this.failedViewResolves;
        }
        this.elapsedTimes += (double)l;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringViewResolverRuntimeMBeanImpl.addViewResolved() : " + this.name);
        }
    }
}

