/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring;

import weblogic.management.ManagementException;
import weblogic.management.runtime.SpringViewRuntimeMBean;
import weblogic.spring.monitoring.SpringBaseRuntimeMBeanImpl;

public class SpringViewRuntimeMBeanImpl
extends SpringBaseRuntimeMBeanImpl
implements SpringViewRuntimeMBean {
    private long viewRenderCount;
    private long failedViewRenders;
    private double elapsedTimes;

    public SpringViewRuntimeMBeanImpl(Object object, String string, Object object2) throws ManagementException {
        super(object, object2, string, false);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringViewRuntimeMBeanImpl(" + string + ")");
        }
    }

    public synchronized long getRenderCount() {
        return this.viewRenderCount;
    }

    public synchronized long getRenderFailedCount() {
        return this.failedViewRenders;
    }

    public synchronized double getAverageRenderTime() {
        return this.viewRenderCount == 0L ? 0.0 : this.elapsedTimes / 1000000.0 / (double)this.viewRenderCount;
    }

    public synchronized void addRender(boolean bl, long l) {
        ++this.viewRenderCount;
        if (!bl) {
            ++this.failedViewRenders;
        }
        this.elapsedTimes += (double)l;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SpringViewRuntimeMBeanImpl.addRender() : " + this.name);
        }
    }
}

