/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring.actions;

import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.spring.monitoring.SpringApplicationContextRuntimeMBeanImpl;
import weblogic.spring.monitoring.SpringRuntimeStatisticsHolder;
import weblogic.spring.monitoring.actions.BaseElapsedTimeAction;
import weblogic.spring.monitoring.actions.CreateBeanElapsedTimeActionState;

public class AbstractBeanFactoryCreateBeanAction
extends BaseElapsedTimeAction {
    private static final long serialVersionUID = 1L;

    public AbstractBeanFactoryCreateBeanAction() {
        super("SpringAbstractBeanFactoryCreateBeanAction");
    }

    public DiagnosticActionState createState() {
        return new CreateBeanElapsedTimeActionState();
    }

    protected void setArguments(Object[] objectArray, DiagnosticActionState diagnosticActionState) {
        super.setArguments(objectArray, diagnosticActionState);
        if (objectArray == null || objectArray.length < 3) {
            return;
        }
        CreateBeanElapsedTimeActionState createBeanElapsedTimeActionState = (CreateBeanElapsedTimeActionState)diagnosticActionState;
        createBeanElapsedTimeActionState.setAbstractBeanDefinition(objectArray[2]);
    }

    protected void updateRuntimeMBean(DiagnosticActionState diagnosticActionState) {
        CreateBeanElapsedTimeActionState createBeanElapsedTimeActionState = (CreateBeanElapsedTimeActionState)diagnosticActionState;
        SpringApplicationContextRuntimeMBeanImpl springApplicationContextRuntimeMBeanImpl = SpringRuntimeStatisticsHolder.getGlobalSpringApplicationContextRuntimeMBeanImpl(createBeanElapsedTimeActionState.getSpringBean());
        if (springApplicationContextRuntimeMBeanImpl != null) {
            if (createBeanElapsedTimeActionState.isSingleton()) {
                springApplicationContextRuntimeMBeanImpl.addSingletonBeanCreation(createBeanElapsedTimeActionState.getElapsedTime());
            } else if (createBeanElapsedTimeActionState.isPrototype()) {
                springApplicationContextRuntimeMBeanImpl.addPrototypeBeanCreation(createBeanElapsedTimeActionState.getElapsedTime());
            } else {
                String string = createBeanElapsedTimeActionState.getScopeName();
                if (string != null) {
                    springApplicationContextRuntimeMBeanImpl.addCustomScopeBeanCreation(string, createBeanElapsedTimeActionState.getElapsedTime());
                }
            }
        }
    }
}

