/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring.actions;

import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.spring.monitoring.SpringApplicationContextRuntimeMBeanImpl;
import weblogic.spring.monitoring.SpringRuntimeStatisticsHolder;
import weblogic.spring.monitoring.actions.ScopeArgActionState;

public class AbstractBeanFactoryRegisterScopeAction
extends AbstractDiagnosticAction
implements AroundDiagnosticAction {
    private static final long serialVersionUID = 1L;

    public AbstractBeanFactoryRegisterScopeAction() {
        this.setType("SpringAbstractBeanFactoryRegisterScopeAction");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public DiagnosticActionState createState() {
        return new ScopeArgActionState();
    }

    public boolean requiresArgumentsCapture() {
        return true;
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        this.setArguments(((DynamicJoinPoint)joinPoint).getArguments(), diagnosticActionState);
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        this.updateRuntimeMBean(diagnosticActionState);
    }

    private void setArguments(Object[] objectArray, DiagnosticActionState diagnosticActionState) {
        ScopeArgActionState scopeArgActionState = (ScopeArgActionState)diagnosticActionState;
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        scopeArgActionState.setSpringBean(objectArray[0]);
        if (objectArray.length >= 1) {
            scopeArgActionState.setScopeName((String)objectArray[1]);
        }
    }

    private void updateRuntimeMBean(DiagnosticActionState diagnosticActionState) {
        SpringApplicationContextRuntimeMBeanImpl springApplicationContextRuntimeMBeanImpl;
        ScopeArgActionState scopeArgActionState = (ScopeArgActionState)diagnosticActionState;
        if (scopeArgActionState.getSucceeded() && (springApplicationContextRuntimeMBeanImpl = SpringRuntimeStatisticsHolder.getGlobalSpringApplicationContextRuntimeMBeanImpl(scopeArgActionState.getSpringBean())) != null) {
            springApplicationContextRuntimeMBeanImpl.addCustomScope(scopeArgActionState.getScopeName());
        }
    }
}

