/*
 * Decompiled with CFR 0.152.
 */
package weblogic.spring.monitoring.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DynamicJoinPointImpl;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.spring.monitoring.actions.BaseElapsedTimeAction;
import weblogic.spring.monitoring.actions.ElapsedTimeActionState;

public class ApplicationContextObtainFreshBeanFactoryAction
extends BaseElapsedTimeAction {
    private static final long serialVersionUID = 1L;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugSpringStatistics");

    public ApplicationContextObtainFreshBeanFactoryAction() {
        super("SpringApplicationContextObtainFreshBeanFactoryAction");
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        super.postProcess(joinPoint, diagnosticActionState);
        if (!(joinPoint instanceof DynamicJoinPointImpl)) {
            return;
        }
        DynamicJoinPointImpl dynamicJoinPointImpl = (DynamicJoinPointImpl)joinPoint;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.springframework.context.ApplicationContext");
            Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass("org.springframework.beans.factory.BeanFactory");
            Class<?> clazz3 = Thread.currentThread().getContextClassLoader().loadClass("weblogic.spring.beans.SpringServerApplicationContextUtils");
            Method method = clazz3.getMethod("setParentBeanFactoryIfNecessary", clazz, clazz2);
            method.invoke(null, ((ElapsedTimeActionState)diagnosticActionState).getSpringBean(), dynamicJoinPointImpl.getReturnValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateRuntimeMBean(DiagnosticActionState diagnosticActionState) {
        ElapsedTimeActionState elapsedTimeActionState = (ElapsedTimeActionState)diagnosticActionState;
        this.updateBeanFactory(elapsedTimeActionState.getSpringBean());
    }

    private void updateBeanFactory(Object object) {
        block14: {
            Method method;
            if (object == null) {
                return;
            }
            try {
                Class<?> clazz = Class.forName("weblogic.spring.monitoring.SpringRuntimeStatisticsMBeanManager", true, object.getClass().getClassLoader());
                method = clazz.getDeclaredMethod("updateBeanFactory", Object.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to find class", (Throwable)classNotFoundException);
                }
                return;
            }
            catch (SecurityException securityException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to find method", (Throwable)securityException);
                }
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to find method", (Throwable)noSuchMethodException);
                }
                return;
            }
            try {
                method.invoke(null, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to invoke", (Throwable)illegalArgumentException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to invoke", (Throwable)illegalAccessException);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!debugLogger.isDebugEnabled()) break block14;
                debugLogger.debug("ApplicationContextObtainFreshBeanFactoryAction.updateBeanFactory failed to invoke", (Throwable)invocationTargetException);
            }
        }
    }
}

