/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.util.HashMap;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.management.utils.GenericBeanListener;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.StoreLogger;
import weblogic.store.common.StoreDebug;
import weblogic.store.xa.PersistentStoreXA;

public abstract class AdminHandler
implements GenericAdminHandler {
    public static final String DEFAULT_STORE_NAME_PREFIX = "_WLS_";
    protected PersistentStoreXA store;
    protected HashMap config;
    protected String name;
    protected String logicalName;
    protected String overrideResourceName;
    protected MigratableTargetMBean migratableTarget;
    protected boolean handlerOpened;
    protected boolean storeOpened;
    protected boolean defaultStore;
    private GenericBeanListener listener;
    private static final HashMap changeableAttributes = new HashMap();

    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
        this.name = deploymentMBean.getName();
        this.defaultStore = false;
        PersistentStoreMBean persistentStoreMBean = (PersistentStoreMBean)deploymentMBean;
        this.logicalName = persistentStoreMBean.getLogicalName();
        this.overrideResourceName = persistentStoreMBean.getXAResourceName();
        if (AdminHandler.isEmptyString(this.overrideResourceName)) {
            this.overrideResourceName = null;
        }
        this.listener = new GenericBeanListener(deploymentMBean, this, changeableAttributes);
        if (this.name.startsWith(DEFAULT_STORE_NAME_PREFIX)) {
            throw new DeploymentException("Invalid store name: " + this.name);
        }
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Preparing PersistentStore \"" + this.name + "\" from MBean \"" + deploymentMBean + "\"");
        }
        if (PersistentStoreManager.getManager().storeExists(this.name)) {
            throw new DeploymentException("The persistent store " + this.name + " already exists");
        }
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray != null) {
            if (targetMBeanArray.length != 1) {
                throw new DeploymentException("The store may only have one target");
            }
            if (targetMBeanArray[0] instanceof ClusterMBean) {
                throw new DeploymentException("Store may not be targetted to the cluster");
            }
        }
    }

    String getName() {
        return this.name;
    }

    public PersistentStoreXA getStore() {
        return this.store;
    }

    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Opening the persistent store " + this.name);
        }
        try {
            this.store.open(this.config);
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreLogger.logStoreDeploymentFailed((String)this.name, (String)persistentStoreException.toString(), (Throwable)persistentStoreException);
            throw new DeploymentException(persistentStoreException);
        }
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        if (this.defaultStore) {
            if (persistentStoreManager.getDefaultStore() != null) {
                throw new AssertionError((Object)"Multiple default stores configured");
            }
            persistentStoreManager.setDefaultStore((PersistentStore)this.store);
        } else {
            persistentStoreManager.addStore(this.name, (PersistentStore)this.store);
            if (this.logicalName != null) {
                persistentStoreManager.addStoreByLogicalName(this.logicalName, (PersistentStore)this.store);
            }
        }
    }

    public void deactivate(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Closing the persistent store " + this.name);
        }
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        if (this.defaultStore) {
            persistentStoreManager.setDefaultStore(null);
        } else {
            persistentStoreManager.removeStore(this.name);
            if (this.logicalName != null) {
                persistentStoreManager.removeStoreByLogicalName(this.logicalName);
            }
        }
        try {
            this.store.close();
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreLogger.logStoreShutdownFailed((String)this.name, (String)persistentStoreException.toString(), (Throwable)persistentStoreException);
            throw new UndeploymentException(persistentStoreException);
        }
    }

    public void unprepare(DeploymentMBean deploymentMBean) {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
    }

    public void setLogicalName(String string) {
        PersistentStoreManager persistentStoreManager = PersistentStoreManager.getManager();
        if (this.logicalName != null) {
            persistentStoreManager.removeStoreByLogicalName(this.logicalName);
        }
        this.logicalName = string;
        if (this.logicalName != null && this.store != null) {
            persistentStoreManager.addStoreByLogicalName(this.logicalName, (PersistentStore)this.store);
        }
    }

    protected static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    protected static boolean isEmptyBytes(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    static {
        changeableAttributes.put("LogicalName", String.class);
    }
}

