/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import weblogic.kernel.KernelStatus;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DefaultFileStoreMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.GenericFileStoreMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreException;
import weblogic.store.RuntimeHandler;
import weblogic.store.StoreLogger;
import weblogic.store.StoreWritePolicy;
import weblogic.store.admin.AdminHandler;
import weblogic.store.admin.RuntimeHandlerImpl;
import weblogic.store.common.StoreDebug;
import weblogic.store.io.file.StoreDir;
import weblogic.store.xa.PersistentStoreManagerXA;

public class FileAdminHandler
extends AdminHandler {
    private GenericBeanListener listener;
    private String directoryName;
    private boolean autoCreateDirectory;
    private static final HashMap changeableAttributes;
    private static final AuthenticatedSubject kernelId;

    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
        super.prepare(deploymentMBean);
        FileStoreMBean fileStoreMBean = (FileStoreMBean)deploymentMBean;
        this.autoCreateDirectory = !ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
        this.directoryName = fileStoreMBean.getDirectory();
        this.directoryName = this.directoryName == null || this.directoryName.length() == 0 ? DomainDir.getPathRelativeServersStoreDataDir((String)string, (String)fileStoreMBean.getName()) : FileAdminHandler.canonicalizeDirectoryName(this.directoryName);
        this.prepareCommon(fileStoreMBean);
    }

    public void prepareDefaultStore(ServerMBean serverMBean, boolean bl) throws DeploymentException {
        this.defaultStore = true;
        this.name = "_WLS_" + serverMBean.getName();
        this.autoCreateDirectory = bl;
        DefaultFileStoreMBean defaultFileStoreMBean = serverMBean.getDefaultFileStore();
        this.directoryName = defaultFileStoreMBean.getDirectory();
        this.directoryName = this.directoryName == null || this.directoryName.length() == 0 ? DomainDir.getPathRelativeServersStoreDataDir((String)serverMBean.getName(), (String)"default") : FileAdminHandler.canonicalizeDirectoryName(this.directoryName);
        this.prepareCommon(defaultFileStoreMBean);
    }

    private void prepareCommon(GenericFileStoreMBean genericFileStoreMBean) throws DeploymentException {
        this.config = new HashMap();
        try {
            this.config.put("BlockSize", genericFileStoreMBean.getBlockSize());
            this.config.put("CacheDirectory", FileAdminHandler.canonicalizeDirectoryName(genericFileStoreMBean.getCacheDirectory()));
            this.config.put("InitialSize", genericFileStoreMBean.getInitialSize());
            this.config.put("IoBufferSize", genericFileStoreMBean.getIoBufferSize());
            this.config.put("MaxFileSize", genericFileStoreMBean.getMaxFileSize());
            this.config.put("MaxWindowBufferSize", genericFileStoreMBean.getMaxWindowBufferSize());
            this.config.put("MinWindowBufferSize", genericFileStoreMBean.getMinWindowBufferSize());
            this.config.put("SynchronousWritePolicy", StoreWritePolicy.getPolicy((String)genericFileStoreMBean.getSynchronousWritePolicy()));
            this.config.put("FileLockingEnabled", genericFileStoreMBean.isFileLockingEnabled());
            if (KernelStatus.isInitialized() && KernelStatus.isServer()) {
                this.config.put("DomainName", ManagementService.getRuntimeAccess(kernelId).getDomainName());
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreLogger.logStoreDeploymentFailed((String)this.name, (String)persistentStoreException.toString(), (Throwable)persistentStoreException);
            throw new DeploymentException(persistentStoreException);
        }
        try {
            StoreDir.createDirectory((File)new File(this.directoryName), (boolean)this.autoCreateDirectory);
        }
        catch (IOException iOException) {
            StoreLogger.logStoreDeploymentFailed((String)this.name, (String)iOException.toString(), (Throwable)iOException);
            throw new DeploymentException(iOException);
        }
        this.listener = new GenericBeanListener(genericFileStoreMBean, this, changeableAttributes);
    }

    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        try {
            RuntimeHandlerImpl runtimeHandlerImpl = null;
            if (KernelStatus.isServer()) {
                runtimeHandlerImpl = new RuntimeHandlerImpl();
            }
            this.store = PersistentStoreManagerXA.makeXAStore((String)this.name, (String)this.directoryName, (String)this.overrideResourceName, (boolean)this.autoCreateDirectory, (RuntimeHandler)runtimeHandlerImpl);
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreLogger.logStoreDeploymentFailed((String)this.name, (String)persistentStoreException.toString(), (Throwable)persistentStoreException);
            throw new DeploymentException(persistentStoreException);
        }
        if (deploymentMBean != null) {
            if (this.listener != null) {
                this.listener.close();
            }
            this.listener = new GenericBeanListener(deploymentMBean, this, changeableAttributes);
        }
        super.activate(deploymentMBean);
    }

    public void createMigratedDefaultStore(ServerMBean serverMBean, boolean bl) throws DeploymentException {
        this.prepareDefaultStore(serverMBean, bl);
        this.defaultStore = false;
        this.activate(null);
    }

    public void unprepare(DeploymentMBean deploymentMBean) {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
        super.unprepare(deploymentMBean);
    }

    public static String canonicalizeDirectoryName(String string) {
        if (FileAdminHandler.isEmptyString(string)) {
            return null;
        }
        File file = new File(string);
        if (!file.isAbsolute() && !file.getPath().startsWith(File.separator)) {
            string = DomainDir.getPathRelativeRootDir((String)string);
        }
        return string;
    }

    public void setSynchronousWritePolicy(String string) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's write policy to " + string);
        }
        try {
            this.store.setConfigValue((Object)"SynchronousWritePolicy", (Object)StoreWritePolicy.getPolicy((String)string));
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setMinWindowBufferSize(int n) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's MinWindowBufferSize to " + n);
        }
        try {
            this.store.setConfigValue((Object)"MinWindowBufferSize", (Object)n);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setMaxWindowBufferSize(int n) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's MaxWindowBufferSize to " + n);
        }
        try {
            this.store.setConfigValue((Object)"MaxWindowBufferSize", (Object)n);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setIoBufferSize(int n) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's IOBufferSize to " + n);
        }
        try {
            this.store.setConfigValue((Object)"IoBufferSize", (Object)n);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setMaxFileSize(long l) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's MaxFileSize to " + l);
        }
        try {
            this.store.setConfigValue((Object)"MaxFileSize", (Object)l);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setFileLockingEnabled(boolean bl) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's FileLockingEnabled to " + bl);
        }
        try {
            this.store.setConfigValue((Object)"FileLockingEnabled", (Object)bl);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setBlockSize(int n) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's BlockSize to " + n);
        }
        try {
            this.store.setConfigValue((Object)"BlockSize", (Object)n);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setInitialSize(long l) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's InitialSize to " + l);
        }
        try {
            this.store.setConfigValue((Object)"InitialSize", (Object)l);
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    public void setCacheDirectory(String string) {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("Changing the store's CacheDirectory to " + string);
        }
        try {
            this.store.setConfigValue((Object)"CacheDirectory", (Object)FileAdminHandler.canonicalizeDirectoryName(string));
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.log();
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        changeableAttributes = new HashMap();
        changeableAttributes.put("SynchronousWritePolicy", String.class);
        changeableAttributes.put("CacheDirectory", String.class);
        changeableAttributes.put("MinWindowBufferSize", Integer.TYPE);
        changeableAttributes.put("MaxWindowBufferSize", Integer.TYPE);
        changeableAttributes.put("IoBufferSize", Integer.TYPE);
        changeableAttributes.put("MaxFileSize", Long.TYPE);
        changeableAttributes.put("BlockSize", Integer.TYPE);
        changeableAttributes.put("InitialSize", Long.TYPE);
        changeableAttributes.put("FileLockingEnabled", Boolean.TYPE);
    }
}

