/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.jdbc.utils.BasicDataSource;
import weblogic.kernel.KernelStatus;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.store.PersistentStoreException;
import weblogic.store.RuntimeHandler;
import weblogic.store.StoreLogger;
import weblogic.store.admin.AdminHandler;
import weblogic.store.admin.RuntimeHandlerImpl;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.jdbc.JDBCStoreIO;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.store.xa.internal.PersistentStoreXAImpl;

public class JDBCAdminHandler
extends AdminHandler {
    public static final String TABLE_NAME = "WLStore";

    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        try {
            this.store = JDBCAdminHandler.makeStore(this.name, this.overrideResourceName, (JDBCStoreMBean)deploymentMBean, null, new RuntimeHandlerImpl());
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreLogger.logStoreDeploymentFailed((String)this.name, (String)persistentStoreException.toString(), (Throwable)persistentStoreException);
            throw new DeploymentException(persistentStoreException);
        }
        this.prepareConfig((JDBCStoreMBean)deploymentMBean);
        super.activate(deploymentMBean);
    }

    public static DataSource createDataSource(JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService) throws PersistentStoreException {
        return JDBCAdminHandler.createDataSource(jDBCStoreMBean, clearOrEncryptedService, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataSource createDataSource(JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService, boolean bl) throws PersistentStoreException {
        try {
            if (jDBCStoreMBean.getDataSource() == null) {
                throw new PersistentStoreException("The JDBC store " + jDBCStoreMBean.getName() + " has no data source");
            }
            JDBCDataSourceBean jDBCDataSourceBean = jDBCStoreMBean.getDataSource().getJDBCResource();
            if (jDBCDataSourceBean == null) throw new PersistentStoreException("The data source for JDBC store " + jDBCStoreMBean.getName() + " does not exist");
            if (jDBCDataSourceBean.getJDBCDataSourceParams() == null) {
                throw new PersistentStoreException("The data source for JDBC store " + jDBCStoreMBean.getName() + " does not exist");
            }
            if (bl && KernelStatus.isServer() && JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean) == 0) {
                String string = JDBCAdminHandler.parseJNDIName(jDBCDataSourceBean.getJDBCDataSourceParams().getJNDINames());
                try {
                    InitialContext initialContext = new InitialContext();
                    try {
                        DataSource dataSource = (DataSource)initialContext.lookup(string);
                        return dataSource;
                    }
                    finally {
                        initialContext.close();
                    }
                }
                catch (NamingException namingException) {
                    throw new PersistentStoreException("Can't find JDBC DataSource " + string + ": " + namingException, (Throwable)namingException);
                }
            }
            JDBCDriverParamsBean jDBCDriverParamsBean = jDBCDataSourceBean.getJDBCDriverParams();
            if (jDBCDriverParamsBean == null) {
                throw new PersistentStoreException("Can't connect using JDBC DataSource because there is no jdbc-driver-params element and no JNDI name");
            }
            if (KernelStatus.isServer()) {
                try {
                    BasicDataSource basicDataSource = new BasicDataSource("jdbc:weblogic:pool:" + jDBCDataSourceBean.getName(), "weblogic.jdbc.pool.Driver", null, null);
                    Connection connection = basicDataSource.getConnection();
                    connection.close();
                    return basicDataSource;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string = jDBCDriverParamsBean.getPassword();
            if (clearOrEncryptedService == null) return new BasicDataSource(jDBCDataSourceBean, string);
            if (!JDBCAdminHandler.isEmptyString(string)) return new BasicDataSource(jDBCDataSourceBean, string);
            if (JDBCAdminHandler.isEmptyBytes(jDBCDriverParamsBean.getPasswordEncrypted())) return new BasicDataSource(jDBCDataSourceBean, string);
            byte[] byArray = clearOrEncryptedService.decryptBytes(jDBCDriverParamsBean.getPasswordEncrypted());
            try {
                string = new String(byArray, "UTF-8");
                return new BasicDataSource(jDBCDataSourceBean, string);
            }
            catch (IOException iOException) {
                throw new PersistentStoreException((Throwable)iOException);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistentStoreException((Throwable)sQLException);
        }
    }

    public static PersistentStoreXA makeStore(String string, String string2, JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService, RuntimeHandler runtimeHandler) throws PersistentStoreException {
        return JDBCAdminHandler.makeStore(string, string2, jDBCStoreMBean, clearOrEncryptedService, runtimeHandler, true);
    }

    public static PersistentStoreXA makeStore(String string, String string2, JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService, RuntimeHandler runtimeHandler, boolean bl) throws PersistentStoreException {
        JDBCStoreIO jDBCStoreIO = JDBCAdminHandler.makeStoreIO(string, jDBCStoreMBean, clearOrEncryptedService, bl);
        return new PersistentStoreXAImpl(string, (PersistentStoreIO)jDBCStoreIO, string2, runtimeHandler);
    }

    private static JDBCStoreIO makeStoreIO(String string, JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService) throws PersistentStoreException {
        return JDBCAdminHandler.makeStoreIO(string, jDBCStoreMBean, clearOrEncryptedService, true);
    }

    private static JDBCStoreIO makeStoreIO(String string, JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService, boolean bl) throws PersistentStoreException {
        String string2 = jDBCStoreMBean.getPrefixName();
        if (string2 != null) {
            string2 = string2.trim();
        }
        String string3 = string2 == null ? TABLE_NAME : string2 + TABLE_NAME;
        DataSource dataSource = JDBCAdminHandler.createDataSource(jDBCStoreMBean, clearOrEncryptedService, bl);
        if (dataSource instanceof BasicDataSource && ((BasicDataSource)dataSource).isXADataSource()) {
            throw new PersistentStoreException("XA data sources are not supported for the JDBC store");
        }
        int n = 20;
        int n2 = 20;
        int n3 = 20;
        n = jDBCStoreMBean.getDeletesPerBatchMaximum();
        n2 = jDBCStoreMBean.getInsertsPerBatchMaximum();
        n3 = jDBCStoreMBean.getDeletesPerStatementMaximum();
        return new JDBCStoreIO(string, dataSource, string3, jDBCStoreMBean.getCreateTableDDLFile(), n, n2, n3);
    }

    public static void deleteStore(String string, JDBCStoreMBean jDBCStoreMBean, ClearOrEncryptedService clearOrEncryptedService) throws PersistentStoreException {
        JDBCAdminHandler.makeStoreIO(string, jDBCStoreMBean, clearOrEncryptedService).destroy();
    }

    private static String parseJNDIName(String[] stringArray) {
        assert (stringArray != null && stringArray.length > 0);
        assert (!JDBCAdminHandler.isEmptyString(stringArray[0]));
        return stringArray[0];
    }

    private void prepareConfig(JDBCStoreMBean jDBCStoreMBean) {
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.config.put("ThreeStepThreshold", jDBCStoreMBean.getThreeStepThreshold());
        this.config.put("WorkerCount", jDBCStoreMBean.getWorkerCount());
        this.config.put("WorkerPreferredBatchSize", jDBCStoreMBean.getWorkerPreferredBatchSize());
    }
}

