/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.management.ManagementException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.admin.PersistentStoreConnectionRuntimeMBeanImpl;
import weblogic.store.admin.PersistentStoreRuntimeMBeanImpl;
import weblogic.store.internal.PersistentStoreImpl;

public class JMXUtils {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static PersistentStoreRuntimeMBeanImpl createStoreMBean(final PersistentStoreImpl persistentStoreImpl) throws PersistentStoreException {
        try {
            return (PersistentStoreRuntimeMBeanImpl)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    return new PersistentStoreRuntimeMBeanImpl((PersistentStore)persistentStoreImpl);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ManagementException) {
                throw new PersistentStoreException((Throwable)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    static void unregisterStoreMBean(final PersistentStoreRuntimeMBeanImpl persistentStoreRuntimeMBeanImpl) throws PersistentStoreException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    persistentStoreRuntimeMBeanImpl.unregister();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ManagementException) {
                throw new PersistentStoreException((Throwable)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    static void registerConnectionMBean(final PersistentStoreRuntimeMBeanImpl persistentStoreRuntimeMBeanImpl, final PersistentStoreConnection persistentStoreConnection) throws PersistentStoreException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    persistentStoreRuntimeMBeanImpl.addConnection(new PersistentStoreConnectionRuntimeMBeanImpl(persistentStoreConnection, persistentStoreRuntimeMBeanImpl));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ManagementException) {
                throw new PersistentStoreException((Throwable)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    static void unregisterConnectionMBean(final PersistentStoreRuntimeMBeanImpl persistentStoreRuntimeMBeanImpl, final PersistentStoreConnection persistentStoreConnection) throws PersistentStoreException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException {
                    persistentStoreRuntimeMBeanImpl.removeConnection(persistentStoreConnection);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ManagementException) {
                throw new PersistentStoreException((Throwable)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }
}

