/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.store.PersistentStoreManager;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public class PersistentStoreImageSource
implements ImageSource {
    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        try {
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter((Writer)new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8")), 2);
            xMLPrettyPrinter.writeStartDocument();
            PersistentStoreManager.getManager().dump((XMLStreamWriter)xMLPrettyPrinter);
            xMLPrettyPrinter.writeEndDocument();
            xMLPrettyPrinter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            this.dumpError(outputStream, xMLStreamException);
            throw new ImageSourceCreationException("PersistentStore image  creation failed.", (Throwable)xMLStreamException);
        }
        catch (IOException iOException) {
            this.dumpError(outputStream, iOException);
            throw new ImageSourceCreationException("PersistentStore image  creation failed.", (Throwable)iOException);
        }
    }

    private void dumpError(OutputStream outputStream, Exception exception) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("Diagnostic image creation failed");
        exception.printStackTrace(printStream);
    }

    public void timeoutImageCreation() {
    }
}

