/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.PersistentStoreConnectionRuntimeMBean;
import weblogic.management.runtime.PersistentStoreRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.RuntimeUpdater;
import weblogic.store.StoreStatistics;
import weblogic.store.admin.PersistentStoreConnectionRuntimeMBeanImpl;
import weblogic.work.WorkManagerFactory;

public class PersistentStoreRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements PersistentStoreRuntimeMBean,
RuntimeUpdater {
    private final PersistentStore store;
    private final StoreStatistics statistics;
    private final ArrayList connections = new ArrayList();
    private static final HealthState OK_STATE = new HealthState(0);
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String HEALTH_NAME_PREFIX = "PersistentStore.";

    public PersistentStoreRuntimeMBeanImpl(PersistentStore persistentStore) throws ManagementException {
        super(persistentStore.getName());
        this.store = persistentStore;
        this.statistics = persistentStore.getStatistics();
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        serverRuntimeMBean.addPersistentStoreRuntime(this);
        HealthMonitorService.register(HEALTH_NAME_PREFIX + this.getName(), this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() throws ManagementException {
        Object object = this.connections;
        synchronized (object) {
            for (PersistentStoreConnectionRuntimeMBeanImpl persistentStoreConnectionRuntimeMBeanImpl : this.connections) {
                persistentStoreConnectionRuntimeMBeanImpl.unregister();
            }
        }
        HealthMonitorService.unregister(HEALTH_NAME_PREFIX + this.getName());
        object = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        object.removePersistentStoreRuntime(this);
        super.unregister();
    }

    public long getAllocatedWindowBufferBytes() {
        return this.statistics.getMappedBufferBytes();
    }

    public long getAllocatedIoBufferBytes() {
        return this.statistics.getIOBufferBytes();
    }

    public long getCreateCount() {
        return this.statistics.getCreateCount();
    }

    public long getReadCount() {
        return this.statistics.getReadCount();
    }

    public long getUpdateCount() {
        return this.statistics.getUpdateCount();
    }

    public long getDeleteCount() {
        return this.statistics.getDeleteCount();
    }

    public long getObjectCount() {
        return this.statistics.getObjectCount();
    }

    public long getPhysicalWriteCount() {
        return this.statistics.getPhysicalWriteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStoreConnectionRuntimeMBean[] getConnections() {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            PersistentStoreConnectionRuntimeMBean[] persistentStoreConnectionRuntimeMBeanArray = new PersistentStoreConnectionRuntimeMBean[this.connections.size()];
            this.connections.toArray(persistentStoreConnectionRuntimeMBeanArray);
            return persistentStoreConnectionRuntimeMBeanArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(PersistentStoreConnectionRuntimeMBean persistentStoreConnectionRuntimeMBean) {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.add(persistentStoreConnectionRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(PersistentStoreConnection persistentStoreConnection) throws ManagementException {
        String string = persistentStoreConnection.getName();
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                PersistentStoreConnectionRuntimeMBeanImpl persistentStoreConnectionRuntimeMBeanImpl = (PersistentStoreConnectionRuntimeMBeanImpl)iterator.next();
                if (!persistentStoreConnectionRuntimeMBeanImpl.getName().equals(string)) continue;
                iterator.remove();
                persistentStoreConnectionRuntimeMBeanImpl.unregister();
            }
        }
    }

    public HealthState getHealthState() {
        PersistentStoreException persistentStoreException = this.store.getFatalException();
        if (persistentStoreException != null) {
            return new HealthState(3, persistentStoreException.toString());
        }
        return OK_STATE;
    }

    public void setHealthFailed(PersistentStoreException persistentStoreException) {
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new HealthSetter(persistentStoreException));
    }

    private boolean isMigratableStore(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        PersistentStoreMBean persistentStoreMBean = domainMBean.lookupFileStore(string);
        if (persistentStoreMBean == null) {
            persistentStoreMBean = domainMBean.lookupJDBCStore(string);
        }
        if (persistentStoreMBean == null) {
            System.err.println("No matching store mbean found for =" + string + ", must be a default store.");
            return false;
        }
        TargetMBean[] targetMBeanArray = persistentStoreMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 1) {
            // empty if block
        }
        return targetMBeanArray[0] instanceof MigratableTargetMBean;
    }

    private final class HealthSetter
    implements Runnable {
        private PersistentStoreException exception;

        HealthSetter(PersistentStoreException persistentStoreException) {
            this.exception = persistentStoreException;
        }

        public void run() {
            if (PersistentStoreRuntimeMBeanImpl.this.isMigratableStore(PersistentStoreRuntimeMBeanImpl.this.store.getName())) {
                HealthMonitorService.subsystemFailedNonFatal(PersistentStoreRuntimeMBeanImpl.HEALTH_NAME_PREFIX + PersistentStoreRuntimeMBeanImpl.this.getName(), this.exception.toString());
            } else {
                HealthMonitorService.subsystemFailed(PersistentStoreRuntimeMBeanImpl.HEALTH_NAME_PREFIX + PersistentStoreRuntimeMBeanImpl.this.getName(), this.exception.toString());
            }
        }
    }
}

