/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.security.AccessController;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.RuntimeHandler;
import weblogic.store.RuntimeUpdater;
import weblogic.store.admin.JMXUtils;
import weblogic.store.admin.PersistentStoreRuntimeMBeanImpl;
import weblogic.store.internal.PersistentStoreImpl;

public class RuntimeHandlerImpl
implements RuntimeHandler {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public RuntimeUpdater createStoreMBean(PersistentStoreImpl persistentStoreImpl) throws PersistentStoreException {
        return JMXUtils.createStoreMBean(persistentStoreImpl);
    }

    public void registerConnectionMBean(RuntimeUpdater runtimeUpdater, PersistentStoreConnection persistentStoreConnection) throws PersistentStoreException {
        JMXUtils.registerConnectionMBean((PersistentStoreRuntimeMBeanImpl)runtimeUpdater, persistentStoreConnection);
    }

    public void unregisterConnectionMBean(RuntimeUpdater runtimeUpdater, PersistentStoreConnection persistentStoreConnection) throws PersistentStoreException {
        JMXUtils.unregisterConnectionMBean((PersistentStoreRuntimeMBeanImpl)runtimeUpdater, persistentStoreConnection);
    }

    public void unregisterStoreMBean(RuntimeUpdater runtimeUpdater) throws PersistentStoreException {
        JMXUtils.unregisterStoreMBean((PersistentStoreRuntimeMBeanImpl)runtimeUpdater);
    }

    public long getJTAAbandonTimeoutMillis() {
        long l = 0L;
        if (KernelStatus.isServer()) {
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            l = (long)domainMBean.getJTA().getAbandonTimeoutSeconds() * 1000L;
            l += 86400000L;
            l = Math.max(345600000L, l);
        } else {
            l = 86400000L;
        }
        return l;
    }

    public String getDomainName() {
        String string = ManagementService.getRuntimeAccess(kernelId).getDomain().getName();
        if (string == null) {
            return "";
        }
        return string;
    }
}

