/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.admin;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.management.InvalidAttributeValueException;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JMSFileStoreMBean;
import weblogic.management.configuration.JMSJDBCStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSStoreMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeans.custom.JMSFileStore;
import weblogic.management.mbeans.custom.JMSJDBCStore;
import weblogic.management.provider.AccessCallback;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.store.common.StoreDebug;
import weblogic.utils.ArrayUtils;

public class StoreCompatibilityUpgrader
implements ConfigurationProcessor,
PropertyChangeListener,
ArrayUtils.DiffHandler,
AccessCallback {
    private DomainMBean domainBean;

    public void shutdown() {
        this.domainBean.removePropertyChangeListener(this);
    }

    public void accessed(DomainMBean domainMBean) {
        this.domainBean = domainMBean;
        this.updateConfiguration(domainMBean);
        domainMBean.addPropertyChangeListener(this);
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (int i = 0; jMSServerMBeanArray != null && i < jMSServerMBeanArray.length; ++i) {
            jMSServerMBeanArray[i].addPropertyChangeListener(new ServerListener(jMSServerMBeanArray[i]));
        }
    }

    public void updateConfiguration(DomainMBean domainMBean) {
        int n;
        FileStoreMBean[] fileStoreMBeanArray = domainMBean.getFileStores();
        for (n = 0; fileStoreMBeanArray != null && n < fileStoreMBeanArray.length; ++n) {
            StoreCompatibilityUpgrader.createJMSFileStoreDelegate(domainMBean, fileStoreMBeanArray[n]);
        }
        JDBCStoreMBean[] jDBCStoreMBeanArray = domainMBean.getJDBCStores();
        for (n = 0; jDBCStoreMBeanArray != null && n < jDBCStoreMBeanArray.length; ++n) {
            StoreCompatibilityUpgrader.createJMSJDBCStoreDelegate(domainMBean, jDBCStoreMBeanArray[n]);
        }
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (n = 0; jMSServerMBeanArray != null && n < jMSServerMBeanArray.length; ++n) {
            StoreCompatibilityUpgrader.setPersistentStoreAttribute(domainMBean, jMSServerMBeanArray[n], jMSServerMBeanArray[n].getPersistentStore());
            StoreCompatibilityUpgrader.setPagingDirectoryAttribute(domainMBean, jMSServerMBeanArray[n], jMSServerMBeanArray[n].getPagingDirectory());
        }
    }

    private static void createJMSFileStoreDelegate(DomainMBean domainMBean, FileStoreMBean fileStoreMBean) {
        if (domainMBean.lookupJMSFileStore(fileStoreMBean.getName()) == null) {
            JMSFileStoreMBean jMSFileStoreMBean = domainMBean.createJMSFileStore(fileStoreMBean.getName());
            jMSFileStoreMBean.setDelegatedBean(fileStoreMBean);
            if (StoreDebug.storeAdmin.isDebugEnabled()) {
                StoreDebug.storeAdmin.debug("Created a new JMSFileStoreMBean named " + fileStoreMBean.getName());
            }
        }
    }

    private static void createJMSJDBCStoreDelegate(DomainMBean domainMBean, JDBCStoreMBean jDBCStoreMBean) {
        if (domainMBean.lookupJMSJDBCStore(jDBCStoreMBean.getName()) == null) {
            JMSJDBCStoreMBean jMSJDBCStoreMBean = domainMBean.createJMSJDBCStore(jDBCStoreMBean.getName());
            jMSJDBCStoreMBean.setDelegatedBean(jDBCStoreMBean);
            if (StoreDebug.storeAdmin.isDebugEnabled()) {
                StoreDebug.storeAdmin.debug("Created a new JMSJDBCStoreMBean named " + jDBCStoreMBean.getName());
            }
        }
    }

    private static void createFileStoreDelegate(DomainMBean domainMBean, JMSFileStoreMBean jMSFileStoreMBean) {
        if (domainMBean.lookupFileStore(jMSFileStoreMBean.getName()) == null) {
            FileStoreMBean fileStoreMBean = domainMBean.createFileStore(jMSFileStoreMBean.getName());
            JMSFileStore.copy(jMSFileStoreMBean, fileStoreMBean);
            jMSFileStoreMBean.setDelegatedBean(fileStoreMBean);
            if (StoreDebug.storeAdmin.isDebugEnabled()) {
                StoreDebug.storeAdmin.debug("Created a new FileStoreMBean named " + jMSFileStoreMBean.getName());
            }
        }
    }

    private static void createJDBCStoreDelegate(DomainMBean domainMBean, JMSJDBCStoreMBean jMSJDBCStoreMBean) {
        if (domainMBean.lookupJDBCStore(jMSJDBCStoreMBean.getName()) == null) {
            JDBCStoreMBean jDBCStoreMBean = domainMBean.createJDBCStore(jMSJDBCStoreMBean.getName());
            JMSJDBCStore.copy(jMSJDBCStoreMBean, jDBCStoreMBean);
            jMSJDBCStoreMBean.setDelegatedBean(jDBCStoreMBean);
            if (StoreDebug.storeAdmin.isDebugEnabled()) {
                StoreDebug.storeAdmin.debug("Created a new JDBCStoreMBean named " + jMSJDBCStoreMBean.getName());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("JDBCStores") || string.equals("FileStores") || string.equals("JMSJDBCStores") || string.equals("JMSFileStores") || string.equals("JMSServers")) {
            ArrayUtils.computeDiff((Object[])((Object[])propertyChangeEvent.getOldValue()), (Object[])((Object[])propertyChangeEvent.getNewValue()), (ArrayUtils.DiffHandler)this);
        }
    }

    public void addObject(Object object) {
        if (object instanceof JMSFileStoreMBean) {
            StoreCompatibilityUpgrader.createFileStoreDelegate(this.domainBean, (JMSFileStoreMBean)object);
        } else if (object instanceof JMSJDBCStoreMBean) {
            StoreCompatibilityUpgrader.createJDBCStoreDelegate(this.domainBean, (JMSJDBCStoreMBean)object);
        } else if (object instanceof FileStoreMBean) {
            StoreCompatibilityUpgrader.createJMSFileStoreDelegate(this.domainBean, (FileStoreMBean)object);
        } else if (object instanceof JDBCStoreMBean) {
            StoreCompatibilityUpgrader.createJMSJDBCStoreDelegate(this.domainBean, (JDBCStoreMBean)object);
        } else if (object instanceof JMSServerMBean) {
            JMSServerMBean jMSServerMBean = (JMSServerMBean)object;
            jMSServerMBean.addPropertyChangeListener(new ServerListener(jMSServerMBean));
        }
    }

    public void removeObject(Object object) {
        JMSJDBCStoreMBean jMSJDBCStoreMBean;
        if (object instanceof JMSFileStoreMBean) {
            FileStoreMBean fileStoreMBean = this.domainBean.lookupFileStore(((JMSFileStoreMBean)object).getName());
            if (fileStoreMBean != null) {
                this.domainBean.destroyFileStore(fileStoreMBean);
            }
        } else if (object instanceof JMSJDBCStoreMBean) {
            JDBCStoreMBean jDBCStoreMBean = this.domainBean.lookupJDBCStore(((JMSJDBCStoreMBean)object).getName());
            if (jDBCStoreMBean != null) {
                this.domainBean.destroyJDBCStore(jDBCStoreMBean);
            }
        } else if (object instanceof FileStoreMBean) {
            JMSFileStoreMBean jMSFileStoreMBean = this.domainBean.lookupJMSFileStore(((FileStoreMBean)object).getName());
            if (jMSFileStoreMBean != null) {
                this.domainBean.destroyJMSFileStore(jMSFileStoreMBean);
            }
        } else if (object instanceof JDBCStoreMBean && (jMSJDBCStoreMBean = this.domainBean.lookupJMSJDBCStore(((JDBCStoreMBean)object).getName())) != null) {
            this.domainBean.destroyJMSJDBCStore(jMSJDBCStoreMBean);
        }
    }

    private static void updateStoreAndTargets(DomainMBean domainMBean, JMSServerMBean jMSServerMBean, JMSStoreMBean jMSStoreMBean, TargetMBean[] targetMBeanArray) {
        block7: {
            try {
                PersistentStoreMBean persistentStoreMBean;
                PersistentStoreMBean persistentStoreMBean2 = jMSServerMBean.getPersistentStore();
                if (!(jMSStoreMBean == null || StoreCompatibilityUpgrader.areTargetsNull(targetMBeanArray) || persistentStoreMBean2 != null && persistentStoreMBean2.getName().equals(jMSStoreMBean.getName()) || (persistentStoreMBean = jMSStoreMBean instanceof JMSFileStoreMBean ? domainMBean.lookupFileStore(jMSStoreMBean.getName()) : domainMBean.lookupJDBCStore(jMSStoreMBean.getName())) == null)) {
                    if (StoreCompatibilityUpgrader.areTargetsNull(persistentStoreMBean.getTargets())) {
                        persistentStoreMBean.setTargets(jMSServerMBean.getTargets());
                    }
                    jMSServerMBean.setPersistentStore(persistentStoreMBean);
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServerMBean " + jMSServerMBean.getName() + ": Set PersistentStore to " + persistentStoreMBean.getName());
                    }
                }
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                if (StoreDebug.storeAdmin.isDebugEnabled()) {
                    StoreDebug.storeAdmin.debug("Error setting PersistentStore", (Throwable)invalidAttributeValueException);
                }
            }
            catch (DistributedManagementException distributedManagementException) {
                if (!StoreDebug.storeAdmin.isDebugEnabled()) break block7;
                StoreDebug.storeAdmin.debug("Error setting PersistentStore", (Throwable)distributedManagementException);
            }
        }
    }

    private static void setPersistentStoreAttribute(DomainMBean domainMBean, JMSServerMBean jMSServerMBean, PersistentStoreMBean persistentStoreMBean) {
        block7: {
            try {
                JMSStoreMBean jMSStoreMBean;
                JMSStoreMBean jMSStoreMBean2 = jMSServerMBean.getStore();
                if (persistentStoreMBean == null && jMSStoreMBean2 != null) {
                    jMSServerMBean.setStore(null);
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServerMBean " + jMSServerMBean.getName() + ": Set Store to null");
                    }
                } else if (!(persistentStoreMBean == null || jMSStoreMBean2 != null && jMSStoreMBean2.getName().equals(persistentStoreMBean.getName()) || (jMSStoreMBean = persistentStoreMBean instanceof FileStoreMBean ? domainMBean.lookupJMSFileStore(persistentStoreMBean.getName()) : domainMBean.lookupJMSJDBCStore(persistentStoreMBean.getName())) == null)) {
                    jMSServerMBean.setStore(jMSStoreMBean);
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServerMBean " + jMSServerMBean.getName() + ": Set Store to " + jMSStoreMBean.getName());
                    }
                }
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                if (!StoreDebug.storeAdmin.isDebugEnabled()) break block7;
                StoreDebug.storeAdmin.debug("Error setting Store", (Throwable)invalidAttributeValueException);
            }
        }
    }

    private static void setPagingDirectoryAttribute(DomainMBean domainMBean, JMSServerMBean jMSServerMBean, String string) {
        block10: {
            try {
                JMSStoreMBean jMSStoreMBean = jMSServerMBean.getPagingStore();
                if (StoreCompatibilityUpgrader.isStringEmpty(string) && jMSStoreMBean != null) {
                    jMSServerMBean.setPagingStore(null);
                    if (jMSStoreMBean instanceof JMSFileStoreMBean) {
                        domainMBean.destroyJMSFileStore((JMSFileStoreMBean)jMSStoreMBean);
                    }
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServer " + jMSServerMBean.getName() + " set PagingDirectory to null and deleted paging store");
                    }
                } else if (!StoreCompatibilityUpgrader.isStringEmpty(string) && jMSStoreMBean == null) {
                    JMSFileStoreMBean jMSFileStoreMBean = domainMBean.createJMSFileStore(jMSServerMBean.getName() + "PagingStore");
                    jMSFileStoreMBean.setSynchronousWritePolicy("Disabled");
                    jMSFileStoreMBean.setDelegatedJMSServer(jMSServerMBean);
                    jMSServerMBean.setPagingStore(jMSFileStoreMBean);
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServer " + jMSServerMBean.getName() + " created a JMSFileStore and set it to the PagingStore attribute");
                    }
                }
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                if (StoreDebug.storeAdmin.isDebugEnabled()) {
                    StoreDebug.storeAdmin.debug("Error setting PagingStore attribute", (Throwable)invalidAttributeValueException);
                }
            }
            catch (DistributedManagementException distributedManagementException) {
                if (!StoreDebug.storeAdmin.isDebugEnabled()) break block10;
                StoreDebug.storeAdmin.debug("Error setting PagingStore attribute", (Throwable)distributedManagementException);
            }
        }
    }

    private static void setPagingStoreAttribute(DomainMBean domainMBean, JMSServerMBean jMSServerMBean, JMSStoreMBean jMSStoreMBean) {
        block8: {
            try {
                String string = jMSServerMBean.getPagingDirectory();
                if (jMSStoreMBean == null && !StoreCompatibilityUpgrader.isStringEmpty(string)) {
                    jMSServerMBean.setPagingDirectory(null);
                    if (StoreDebug.storeAdmin.isDebugEnabled()) {
                        StoreDebug.storeAdmin.debug("JMSServer " + jMSServerMBean.getName() + " setting PagingDirectory to null");
                    }
                    break block8;
                }
                if (jMSStoreMBean == null || !(jMSStoreMBean instanceof JMSFileStoreMBean) || !StoreCompatibilityUpgrader.isStringEmpty(string)) break block8;
                JMSFileStoreMBean jMSFileStoreMBean = (JMSFileStoreMBean)jMSStoreMBean;
                try {
                    if (jMSFileStoreMBean.getDirectory() != null) {
                        jMSServerMBean.setPagingDirectory(jMSFileStoreMBean.getDirectory());
                    }
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    // empty catch block
                }
                jMSFileStoreMBean.setDelegatedJMSServer(jMSServerMBean);
                if (StoreDebug.storeAdmin.isDebugEnabled()) {
                    StoreDebug.storeAdmin.debug("JMSServer " + jMSServerMBean.getName() + " setting PagingDirectory from PagingStore parameters");
                }
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                if (!StoreDebug.storeAdmin.isDebugEnabled()) break block8;
                StoreDebug.storeAdmin.debug("Error setting PagingDirectory attribute", (Throwable)invalidAttributeValueException);
            }
        }
    }

    private static boolean isStringEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static boolean areTargetsNull(TargetMBean[] targetMBeanArray) {
        return targetMBeanArray == null || targetMBeanArray.length == 0;
    }

    private final class ServerListener
    implements PropertyChangeListener {
        private JMSServerMBean server;

        ServerListener(JMSServerMBean jMSServerMBean) {
            this.server = jMSServerMBean;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Targets")) {
                StoreCompatibilityUpgrader.updateStoreAndTargets(StoreCompatibilityUpgrader.this.domainBean, this.server, this.server.getStore(), (TargetMBean[])propertyChangeEvent.getNewValue());
            }
        }
    }
}

