/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.security.AccessController;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelLogManager;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccessSettable;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.ExecutionContext;
import weblogic.t3.srvr.JVMRuntime;
import weblogic.t3.srvr.Scavenger;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.t3.srvr.SetUIDRendezvous;
import weblogic.t3.srvr.T3Srvr;
import weblogic.time.common.internal.TimeEventGenerator;
import weblogic.time.server.TimerMBean;
import weblogic.version;
import weblogic.work.RequestManager;
import weblogic.work.ServerWorkManagerFactory;

public class BootService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public String getName() {
        return "Kernel";
    }

    public String getVersion() {
        return "Commonj WorkManager v1.1";
    }

    public void start() throws ServiceFailureException {
        try {
            ServerRuntime serverRuntime = ServerRuntime.init();
            ((RuntimeAccessSettable)((Object)ManagementService.getRuntimeAccess(kernelId))).setServerRuntime(serverRuntime);
            SetUIDRendezvous.initialize();
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            if (!serverMBean.getUse81StyleExecuteQueues()) {
                if (serverMBean.isUseConcurrentQueueForRequestManager()) {
                    RequestManager.enableBufferQueue((boolean)true);
                }
                ServerWorkManagerFactory.initialize(ManagementService.getRuntimeAccess(kernelId).getServer());
            }
            KernelLogManager.initialize(ManagementService.getRuntimeAccess(kernelId).getServer());
            Kernel.initialize(ManagementService.getRuntimeAccess(kernelId).getServer());
            TimeEventGenerator timeEventGenerator = TimeEventGenerator.init(T3Srvr.getT3Srvr().getStartupThreadGroup());
            new TimerMBean(timeEventGenerator);
            JVMRuntime.init();
            T3SrvrLogger.logStartupBuildName((String)version.getVersions(), (String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
            new ExecutionContext("systemContext");
            new Scavenger();
        }
        catch (ConfigurationException configurationException) {
            T3SrvrLogger.logConfigFailure((String)configurationException.getMessage());
            throw new ServiceFailureException((Throwable)configurationException);
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
    }

    public void stop() {
        this.shutdown();
    }

    public void halt() {
        this.shutdown();
    }

    public void shutdown() {
        T3SrvrLogger.logKernelShutdown();
        Kernel.shutdown();
    }
}

